package jp.sf.nikonikofw.action;

import jp.sf.nikonikofw.Config;

public class DefaultActionMapping implements IActionMapping {

	@Override
	public IAction getAction(String contextPath) {
		if(contextPath.endsWith(".do")){
			contextPath = contextPath.substring(0, contextPath.length() - 3);
		}
		
		String packageName = "";
		String className = contextPath;
		
		int index = contextPath.indexOf('/');
		if(index >= 0){
			packageName = contextPath.substring(0, index + 1).replace('/', '.');
			className = contextPath.substring(index + 1);
		}
		
		for(String rootPackage: Config.getRootPackages()){
			String fullClassName = rootPackage + packageName + 
				className.substring(0, 1).toUpperCase() + className.substring(1) + "Action";		
			try {
				Class<?> clazz = Class.forName(fullClassName);
				return (IAction) clazz.newInstance();
				
			} catch(Exception ex){
				;
			}
		}
		
		return null;
	}

}
