/*******************************************************************************************
 * setup softkeyboard(NicoTouch)
 */
package com.hiroshica.android.input.nicownn2.JAJP;

import android.inputmethodservice.Keyboard;
import com.hiroshica.android.input.nicownn2.*;
import java.util.HashMap;

public class SetupKeyboardNico2 implements SetupKeyboard {
	/** Toggle cycle table for full-width Nicotouch */
	public static final String[][][] JP_FULL_NICO2_CYCLE_TABLE = {
		{
			/** a **/
			{"\u3042"}, {"\u3044"}, {"\u3046"}, {     " "}, {     " "},
			{     "1"}, {"\u3048"}, {"\u304a"}, {     " "}, {     " "},
			{     "."}, {     "-"}, {     "@"}, {     "_"}, {     " "},
			/** k **/
			{     " "}, {"\u304b"}, {"\u304d"}, {"\u304f"}, {     " "},
			{     " "}, {     "2"}, {"\u3051"}, {"\u3053"}, {     " "},
			{     "a"}, {     "b"}, {     "c"}, {     " "}, {     " "},
			/** s **/
			{     " "}, {     "#"}, {"\u3055"}, {"\u3057"}, {"\u3059"},
			{     " "}, {     "/"}, {     "3"}, {"\u305b"}, {"\u305d"},
			{     " "}, {     "d"}, {     "e"}, {     "f"}, {     " "},
			/** t **/
			{     " "}, {"\u3064"}, {"\u3061"}, {"\u305f"}, {"\u3063"},
			{     " "}, {"\u3068"}, {"\u3066"}, {     "4"}, {     " "},
			{     " "}, {     " "}, {     "g"}, {     "h"}, {     "i"},
			/** n **/
			{     " "}, {     "("}, {"\u306c"}, {"\u306b"}, {"\u306a"},
			{     " "}, {     ")"}, {"\u306e"}, {"\u306d"}, {     "5"},
			{     " "}, {     " "}, {     "j"}, {     "k"}, {     "l"},
			/** h **/
			{     "6"}, {"\u3078"}, {"\u307b"}, {     " "}, {     " "},
			{"\u306f"}, {"\u3072"}, {"\u3075"}, {     " "}, {     " "},
			{     "m"}, {     "n"}, {     "o"}, {     " "}, {     " "},
			/** m **/
			{     " "}, {     "7"}, {"\u3081"}, {"\u3082"}, {     " "},
			{     " "}, {"\u307e"}, {"\u307f"}, {"\u3080"}, {     " "},
			{     "p"}, {     "q"}, {     "r"}, {     "s"}, {     " "},
			/** y **/
			{     " "}, {"\u3085"}, {     "8"}, {"\u3087"}, {     " "},
			{     " "}, {"\u3083"}, {"\u3084"}, {"\u3086"}, {"\u3088"},
			{     " "}, {     "t"}, {     "u"}, {     "v"}, {     " "},
			/** r **/
			{     " "}, {"\u308d"}, {"\u308c"}, {     "9"}, {     " "},
			{     " "}, {"\u308b"}, {"\u308a"}, {"\u3089"}, {     " "},
			{     " "}, {     "w"}, {     "x"}, {     "y"}, {     "z"},
			/** w **/
			{     " "}, {     " "}, {"\uff01"}, {"\uff1f"}, {     "0"},
			{     " "}, {"\u30fb"}, {"\u3093"}, {"\u3092"}, {"\u308f"},
			{     " "}, {     " "}, {"\u3001"}, {"\u3002"}, {"\u30fc"},

		},
		{
			{"\u3042"}, {"\u3044"}, {"\u3046"}, {"\u3048"}, {"\u304a"},      {"1"},      {"."},      {"-"},      {"@"},      {"_"},  {" "},  {" "},  {" "},  {" "},  {" "},
			{"\u3053"}, {"\u304b"}, {"\u304d"}, {"\u304f"}, {"\u3051"},      {" "},      {"2"},      {" "},      {" "},      {" "},  {"A"},  {"B"},  {"C"},  {" "},  {" "},
			{"\u305b"}, {"\u305d"}, {"\u3055"}, {"\u3057"}, {"\u3059"},      {" "},      {"/"},      {"3"},      {"#"},      {" "},  {"D"},  {"E"},  {"F"},  {" "},  {" "},
			{"\u3064"}, {"\u3066"}, {"\u3068"}, {"\u305f"}, {"\u3061"},      {" "},      {" "}, {"\u3063"},      {"4"},      {" "},  {"G"},  {"H"},  {"I"},  {" "},  {" "},
			{"\u306b"}, {"\u306c"}, {"\u306d"}, {"\u306e"}, {"\u306a"},      {" "},      {" "},      {"("},      {")"},      {"5"},  {"J"},  {"K"},  {"L"},  {" "},  {" "},
			{     "6"},      {" "},      {" "},      {" "},      {" "}, {"\u306f"}, {"\u3072"}, {"\u3075"}, {"\u3078"}, {"\u307b"},  {"M"},  {"N"},  {"O"},  {" "},  {" "},
			{     " "},      {"7"},      {" "},      {" "},      {" "}, {"\u3082"}, {"\u307e"}, {"\u307f"}, {"\u3080"}, {"\u3081"},  {"P"},  {"Q"},  {"R"},  {"S"},  {" "},
			{     " "}, {"\u3085"},      {"8"}, {"\u3087"},      {" "},      {" "}, {"\u3083"}, {"\u3084"}, {"\u3086"}, {"\u3088"},  {"T"},  {"U"},  {"V"},  {" "},  {" "},
			{     " "},      {" "},      {" "},      {"9"},      {" "}, {"\u308b"}, {"\u308c"}, {"\u308d"}, {"\u3089"}, {"\u308a"},  {"W"},  {"X"},  {"Y"},  {"Z"},  {" "},
			{     " "},      {" "}, {"\uff01"}, {"\uff1f"},      {"0"},      {" "}, {"\u30fb"}, {"\u3093"}, {"\u3092"}, {"\u308f"},  {" "},  {" "}, {"\u3001"}, {"\u3002"}, {"\u30fc"},
		}
	};

	/** Replace table for full-width Nicotouch */
	public static final HashMap<String, String> JP_FULL_NICO2_REPLACE_TABLE = new HashMap<String, String>() {
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;

	{
			put("\u3042", "\u3041"); put("\u3044", "\u3043"); put("\u3046", "\u3045"); put("\u3048", "\u3047"); put("\u304a", "\u3049"); // A
			put("\u3041", "\u3042"); put("\u3043", "\u3044"); put("\u3045", "\u30f4"); put("\u3047", "\u3048"); put("\u3049", "\u304a"); // a
			put("\u304b", "\u304c"); put("\u304d", "\u304e"); put("\u304f", "\u3050"); put("\u3051", "\u3052"); put("\u3053", "\u3054"); // K
			put("\u304c", "\u304b"); put("\u304e", "\u304d"); put("\u3050", "\u304f"); put("\u3052", "\u3051"); put("\u3054", "\u3053"); // k
			put("\u3055", "\u3056"); put("\u3057", "\u3058"); put("\u3059", "\u305a"); put("\u305b", "\u305c"); put("\u305d", "\u305e"); // S
			put("\u3056", "\u3055"); put("\u3058", "\u3057"); put("\u305a", "\u3059"); put("\u305c", "\u305b"); put("\u305e", "\u305d"); // s
			put("\u305f", "\u3060"); put("\u3061", "\u3062"); put("\u3064", "\u3065"); put("\u3066", "\u3067"); put("\u3068", "\u3069"); // T
			put("\u3060", "\u305f"); put("\u3062", "\u3061"); put("\u3065", "\u3063"); put("\u3067", "\u3066"); put("\u3069", "\u3068"); // t
			put("\u3063", "\u3064"); put("\u30f4", "\u3046");
			put("\u306f", "\u3070"); put("\u3072", "\u3073"); put("\u3075", "\u3076"); put("\u3078", "\u3079"); put("\u307b", "\u307c"); // H
			put("\u3070", "\u3071"); put("\u3073", "\u3074"); put("\u3076", "\u3077"); put("\u3079", "\u307a"); put("\u307c", "\u307d"); // h
			put("\u3071", "\u306f"); put("\u3074", "\u3072"); put("\u3077", "\u3075"); put("\u307a", "\u3078"); put("\u307d", "\u307b"); // h.
			put("\u3084", "\u3083"); put("\u3086", "\u3085"); put("\u3088", "\u3087"); // Y
			put("\u3083", "\u3084"); put("\u3085", "\u3086"); put("\u3087", "\u3088"); // y
			put("\u308f", "\u308e");
			put("\u308e", "\u308f");
			put("\u309b", "\u309c");
			put("\u309c", "\u309b");

			put("a", "A"); put("b", "B"); put("c", "C"); put("d", "D"); put("e", "E"); put("f", "F"); put("g", "G"); put("h", "H"); put("i", "I"); put("j", "J");
			put("k", "K"); put("l", "L"); put("m", "M"); put("n", "N"); put("o", "O"); put("p", "P"); put("q", "Q"); put("r", "R"); put("s", "S"); put("t", "T");
			put("u", "U"); put("v", "V"); put("w", "W"); put("x", "X"); put("y", "Y"); put("z", "Z");
			put("A", "a"); put("B", "b"); put("C", "c"); put("D", "d"); put("E", "e"); put("F", "f"); put("G", "g"); put("H", "h"); put("I", "i"); put("J", "j");
			put("K", "k"); put("L", "l"); put("M", "m"); put("N", "n"); put("O", "o"); put("P", "p"); put("Q", "q"); put("R", "r"); put("S", "s"); put("T", "t");
			put("U", "u"); put("V", "v"); put("W", "w"); put("X", "x"); put("Y", "y"); put("Z", "z");

			put("1", "\uff11"); put("2", "\uff12"); put("3", "\uff13"); put("4", "\uff14"); put("5", "\uff15");
			put("6", "\uff16"); put("7", "\uff17"); put("8", "\uff18"); put("9", "\uff19"); put("0", "\uff10");
			put("\uff11", "1"); put("\uff12", "2"); put("\uff13", "3"); put("\uff14", "4"); put("\uff15", "5");
			put("\uff16", "6"); put("\uff17", "7"); put("\uff18", "8"); put("\uff19", "9"); put("\uff10", "0");

			put(".", "\uff0e"); put("-", "\u2015"); put("@", "\uff20"); put("_", "\uff3f");
			put("\uff0e", "."); put("\u2015", "-"); put("\uff20", "@"); put("\uff3f", "_");

			put("\uff01", "!"); put("\uff1f", "?");
			put("!", "\uff01"); put("?", "\uff1f");

			put("\u3000", " "); put(" ", "\u3000");

			put("(", "["); put("[", "\u300c"); put("\u300c", "\u300e"); put("\u300e", "\u3010"); put("\u3010", "(");
			put(")", "]"); put("]", "\u300d"); put("\u300d", "\u300f"); put("\u300f", "\u3011"); put("\u3011", ")");
		}};

	/******************************************************************************************/
	/*********************************
	 *
	 */
	public Keyboard[][] SetupSoftKeyboard(NicoWnn parent, int displaymode) {
		Keyboard[][] nicokeyboard = new Keyboard[11][2];
		if (DefaultSoftKeyboard.PORTRAIT == displaymode) {
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_TOP][0]   = new Keyboard(parent, R.xml.key_nico2_top);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_A][0]     = new Keyboard(parent, R.xml.key_nico2_a);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_K][0]     = new Keyboard(parent, R.xml.key_nico2_k);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_S][0]     = new Keyboard(parent, R.xml.key_nico2_s);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_T][0]     = new Keyboard(parent, R.xml.key_nico2_t);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_N][0]     = new Keyboard(parent, R.xml.key_nico2_n);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_H][0]     = new Keyboard(parent, R.xml.key_nico2_h);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_M][0]     = new Keyboard(parent, R.xml.key_nico2_m);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_Y][0]     = new Keyboard(parent, R.xml.key_nico2_y);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_R][0]     = new Keyboard(parent, R.xml.key_nico2_r);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_W][0]     = new Keyboard(parent, R.xml.key_nico2_w);

			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_TOP][1]   = new Keyboard(parent, R.xml.key_nico2_input_top);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_A][1]     = new Keyboard(parent, R.xml.key_nico2_input_a);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_K][1]     = new Keyboard(parent, R.xml.key_nico2_input_k);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_S][1]     = new Keyboard(parent, R.xml.key_nico2_input_s);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_T][1]     = new Keyboard(parent, R.xml.key_nico2_input_t);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_N][1]     = new Keyboard(parent, R.xml.key_nico2_input_n);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_H][1]     = new Keyboard(parent, R.xml.key_nico2_input_h);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_M][1]     = new Keyboard(parent, R.xml.key_nico2_input_m);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_Y][1]     = new Keyboard(parent, R.xml.key_nico2_input_y);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_R][1]     = new Keyboard(parent, R.xml.key_nico2_input_r);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_W][1]     = new Keyboard(parent, R.xml.key_nico2_input_w);
		}
		else{
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_TOP][0]   = new Keyboard(parent, R.xml.key_nico2_top);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_A][0]     = new Keyboard(parent, R.xml.key_nico2_a);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_K][0]     = new Keyboard(parent, R.xml.key_nico2_k);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_S][0]     = new Keyboard(parent, R.xml.key_nico2_s);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_T][0]     = new Keyboard(parent, R.xml.key_nico2_t);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_N][0]     = new Keyboard(parent, R.xml.key_nico2_n);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_H][0]     = new Keyboard(parent, R.xml.key_nico2_h);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_M][0]     = new Keyboard(parent, R.xml.key_nico2_m);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_Y][0]     = new Keyboard(parent, R.xml.key_nico2_y);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_R][0]     = new Keyboard(parent, R.xml.key_nico2_r);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_W][0]     = new Keyboard(parent, R.xml.key_nico2_w);

			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_TOP][1]   = new Keyboard(parent, R.xml.key_nico2_input_top);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_A][1]     = new Keyboard(parent, R.xml.key_nico2_input_a);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_K][1]     = new Keyboard(parent, R.xml.key_nico2_input_k);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_S][1]     = new Keyboard(parent, R.xml.key_nico2_input_s);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_T][1]     = new Keyboard(parent, R.xml.key_nico2_input_t);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_N][1]     = new Keyboard(parent, R.xml.key_nico2_input_n);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_H][1]     = new Keyboard(parent, R.xml.key_nico2_input_h);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_M][1]     = new Keyboard(parent, R.xml.key_nico2_input_m);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_Y][1]     = new Keyboard(parent, R.xml.key_nico2_input_y);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_R][1]     = new Keyboard(parent, R.xml.key_nico2_input_r);
			nicokeyboard[DefaultSoftKeyboard.NICO_SLIDE_MODE_W][1]     = new Keyboard(parent, R.xml.key_nico2_input_w);
		}
		return nicokeyboard;
	}
	/*********************************
	 *
	 */
	public String[][][] SetupCycleTable() {
		return JP_FULL_NICO2_CYCLE_TABLE;
	}
	/*********************************
	 *
	 */
	public HashMap<String, String> SetupReplaceTable() {
		return JP_FULL_NICO2_REPLACE_TABLE;
	}
	/*********************************
	 *
	 */
	public int SetupIcon() {
		return R.drawable.immodeic_niko;
	}
}
/******************** end of file ********************/
