package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChat;
import jp.sourceforge.nicoro.MessageChatFork;
import junit.framework.TestCase;

public class NicoScriptReplaceTest extends TestCase {
    public void testCallback() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠置換 A B", chat);
        assertEquals(NicoScriptReplace.class, ns.getClass());

        NicoScriptReplace script = (NicoScriptReplace) ns;
        assertEquals(NicoScript.UNDEFINED_DEFAULT_TIME, chat.getTime());

        FakeMessageChatController fake = new FakeMessageChatController();
        assertNull(fake.scriptReplace);
        assertFalse(fake.calledAddCommandReplace);
        assertFalse(fake.calledRemoveCommandReplace);

        script.onDraw(fake);
        assertEquals(script, fake.scriptReplace);
        assertTrue(fake.calledAddCommandReplace);
        assertFalse(fake.calledRemoveCommandReplace);

        script.onPrepareRemove(fake);
        assertEquals(script, fake.scriptReplace);
        assertTrue(fake.calledRemoveCommandReplace);
    }

    public void testDefault() {
        MessageChatFork chat = new MessageChatFork("@120 red small ue", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠置換 hello world", chat);
        assertEquals(NicoScriptReplace.class, ns.getClass());

        NicoScriptReplace script = (NicoScriptReplace) ns;
        assertEquals(MessageChat.COLOR_RED, script.getColor());
        assertEquals(MessageChat.FONTSIZE_PX_SMALL, script.getFontSize());
        assertEquals(MessageChat.FONTSIZE_TYPE_SMALL, script.getFontSizeType());
        assertEquals(MessageChat.POS_UE, script.getPos());
        assertEquals(120, chat.getTime());
        assertFalse(script.isSaveLocal());

        assertFalse(script.isIncludeContributor());
        assertTrue(script.match("Hihellobye"));
        assertFalse(script.match("world"));
        assertEquals("Hiworldbye", script.replace("Hihellobye"));
    }

    public void testOption1() {
        MessageChatFork chat = new MessageChatFork("@120 red small ue", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠置換 printf ｢hello, world!｣ 単 含まない 部分一致", chat);
        assertEquals(NicoScriptReplace.class, ns.getClass());

        NicoScriptReplace script = (NicoScriptReplace) ns;
        assertEquals(MessageChat.COLOR_RED, script.getColor());
        assertEquals(MessageChat.FONTSIZE_PX_SMALL, script.getFontSize());
        assertEquals(MessageChat.FONTSIZE_TYPE_SMALL, script.getFontSizeType());
        assertEquals(MessageChat.POS_UE, script.getPos());
        assertEquals(120, chat.getTime());

        assertFalse(script.isIncludeContributor());
        assertTrue(script.match("Hiprintfbye"));
        assertFalse(script.match("print"));
        assertEquals("Hihello, world!bye", script.replace("Hiprintfbye"));
    }

    public void testOption2() {
        MessageChatFork chat = new MessageChatFork("@120 red small ue", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠置換 printf ｢hello, world!｣ 全 含む 部分一致", chat);
        assertEquals(NicoScriptReplace.class, ns.getClass());

        NicoScriptReplace script = (NicoScriptReplace) ns;
        assertEquals(MessageChat.COLOR_RED, script.getColor());
        assertEquals(MessageChat.FONTSIZE_PX_SMALL, script.getFontSize());
        assertEquals(MessageChat.FONTSIZE_TYPE_SMALL, script.getFontSizeType());
        assertEquals(MessageChat.POS_UE, script.getPos());
        assertEquals(120, chat.getTime());

        assertTrue(script.isIncludeContributor());
        assertTrue(script.match("Hiprintfbye"));
        assertFalse(script.match("print"));
        assertEquals("hello, world!", script.replace("Hiprintfbye"));
    }

    public void testOption3() {
        MessageChatFork chat = new MessageChatFork("@120 red small ue", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠置換 printf ｢hello, world!｣ 完全一致", chat);
        assertEquals(NicoScriptReplace.class, ns.getClass());

        NicoScriptReplace script = (NicoScriptReplace) ns;
        assertEquals(MessageChat.COLOR_RED, script.getColor());
        assertEquals(MessageChat.FONTSIZE_PX_SMALL, script.getFontSize());
        assertEquals(MessageChat.FONTSIZE_TYPE_SMALL, script.getFontSizeType());
        assertEquals(MessageChat.POS_UE, script.getPos());
        assertEquals(120, chat.getTime());

        assertFalse(script.isIncludeContributor());
        assertFalse(script.match("Hiprintfbye"));
        assertFalse(script.match("print"));
        assertTrue(script.match("printf"));
        assertEquals("hello, world!", script.replace("printf"));
    }

    public void testIsSaveLocal() {
        MessageChatFork chat = new MessageChatFork("@120 red small ue local", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠置換 hello world", chat);
        assertEquals(NicoScriptReplace.class, ns.getClass());

        NicoScriptReplace script = (NicoScriptReplace) ns;
        assertTrue(script.isSaveLocal());
    }
}
