package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChatFork;
import junit.framework.TestCase;

public class NicoScriptForbidSeekTest extends TestCase {
    public void testDefault() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠シーク禁止", chat);
        assertEquals(NicoScriptForbidSeek.class, ns.getClass());

        NicoScriptForbidSeek script = (NicoScriptForbidSeek) ns;
        assertEquals(NicoScript.UNDEFINED_DEFAULT_TIME, chat.getTime());
        FakeMessageChatController fake = new FakeMessageChatController();
        assertFalse(fake.calledForbidSeek);
        assertFalse(fake.calledAllowSeek);

        script.onDraw(fake);
        assertTrue(fake.calledForbidSeek);
        assertFalse(fake.calledAllowSeek);

        script.onPrepareRemove(fake);
        assertTrue(fake.calledAllowSeek);
    }

    public void testSetTime() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠シーク禁止", chat);
        assertEquals(NicoScriptForbidSeek.class, ns.getClass());

        assertEquals(90, chat.getTime());
    }

}
