
package jp.sourceforge.nicoro;

public interface MessageSenderInterface extends XmlLoaderInterface {

    public interface EventListener {
        /**
         * コメント書き込み完了
         * @param no
         * @param mail
         * @param body
         * @param vpos
         */
        void onFinished(int no, String mail, String body, int vpos);
        /**
         * コメント書き込みでエラー発生
         * @param errorMessage
         */
        void onOccurredError(String errorMessage);
    }

    boolean isNull();

    void setTicket(String ticket, String nicosTicket);

    boolean send(String mail, String body, int vpos, boolean toNicos);

    void setEventListener(MessageSenderInterface.EventListener eventListener);

    boolean isStarted();

    public static class NullObject extends XmlLoader.AbstractNullObject
    implements MessageSenderInterface {
        private static final NullObject sInstance = new NullObject();
        public static NullObject getInstance() {
            return sInstance;
        }

        private NullObject() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public void setTicket(String ticket, String nicosTicket) {
        }

        @Override
        public boolean send(String mail, String body, int vpos, boolean toNicos) {
            return false;
        }

        @Override
        public void setEventListener(EventListener eventListener) {
        }

        @Override
        public boolean isStarted() {
            return false;
        }
    }
}
