package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChatFork;
import junit.framework.TestCase;

public class NicoScriptDoorTest extends TestCase {

    // TODO 後で追加実装すべきテストあり

    public void testCallback() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠ドア", chat);
        assertEquals(NicoScriptDoor.class, ns.getClass());

        NicoScriptDoor script = (NicoScriptDoor) ns;
        assertEquals(NicoScript.UNDEFINED_DEFAULT_TIME, chat.getTime());

        FakeMessageChatController fake = new FakeMessageChatController();
        assertNull(fake.scriptDoor);
        assertFalse(fake.calledSetCommandDoor);
        assertFalse(fake.calledClearCommandDoor);

        script.onDraw(fake);
        assertEquals(script, fake.scriptDoor);
        assertTrue(fake.calledSetCommandDoor);
        assertFalse(fake.calledClearCommandDoor);

        script.onPrepareRemove(fake);
        assertEquals(script, fake.scriptDoor);
        assertTrue(fake.calledClearCommandDoor);

    }

    public void testDefault() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠ドア", chat);
        assertEquals(NicoScriptDoor.class, ns.getClass());

        NicoScriptDoor script = (NicoScriptDoor) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());

        assertEquals(5, script.getCount());

        assertTrue(script.match("左"));
        assertTrue(script.match("右"));
        assertTrue(script.match("次は左"));
        assertTrue(script.match("次は右"));
    }

    public void testIsSaveLocal() {
        MessageChatFork chat = new MessageChatFork("@90 local", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠ドア", chat);
        assertEquals(NicoScriptDoor.class, ns.getClass());

        NicoScriptDoor script = (NicoScriptDoor) ns;
        assertTrue(script.isSaveLocal());
    }

    public void testOption1() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠ドア left、right 左右 10 部分一致", chat);
        assertEquals(NicoScriptDoor.class, ns.getClass());

        NicoScriptDoor script = (NicoScriptDoor) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());

        assertEquals(10, script.getCount());

        assertTrue(script.match("left"));
        assertTrue(script.match("right"));
        assertTrue(script.match("次はleft"));
        assertTrue(script.match("次はright"));
    }

    public void testOption2() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠ドア left、right 50%,50%,50%,50% 10 完全一致", chat);
        assertEquals(NicoScriptDoor.class, ns.getClass());

        NicoScriptDoor script = (NicoScriptDoor) ns;
        assertEquals(90, chat.getTime());
        assertFalse(script.isSaveLocal());

        assertEquals(10, script.getCount());

        assertTrue(script.match("left"));
        assertTrue(script.match("right"));
        assertFalse(script.match("次はleft"));
        assertFalse(script.match("次はright"));
    }

}
