package jp.sourceforge.nicoro;

import android.os.Bundle;

import junit.framework.TestCase;

public class StateManagerTest extends TestCase {

    public void testNormalSequence() {
        StateManager st = new StateManager();
        assertFalse(st.wasCreated());

        st.onCreate(null);
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onStart();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onResume();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertTrue(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onPause();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onStop();
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertTrue(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onDestroy();
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertTrue(st.wasSavedInstanceState());
        assertTrue(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());
    }

    public void testRestored() {
        StateManager st = new StateManager();
        assertFalse(st.wasCreated());

        st.onCreate(new Bundle());
        assertTrue(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());
    }

    public void testRestarted() {
        StateManager st = new StateManager();
        assertFalse(st.wasCreated());

        st.onCreate(null);
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onStart();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onResume();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertTrue(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onPause();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onStop();
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertTrue(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onRestart();
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertTrue(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onStart();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertTrue(st.wasRestarted());
        assertTrue(st.wasCreated());
    }

    public void testSaveInstanceState() {
        StateManager st = new StateManager();
        assertFalse(st.wasCreated());

        st.onCreate(null);
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onStart();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onResume();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertTrue(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onPause();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onSaveInstanceState();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertTrue(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onStop();
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertTrue(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());

        st.onDestroy();
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertTrue(st.wasSavedInstanceState());
        assertTrue(st.wasDestroyed());
        assertFalse(st.wasRestarted());
        assertTrue(st.wasCreated());
    }
}
