package jp.gr.java_conf.shiseissi.commonlib;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;

/**
 * 単純なメッセージを表示するだけの {@link DialogFragment}
 *
 * @author shisei
 *
 */
public class SimpleMessageDialogFragment extends DialogFragment {
    private static final String EXTRA_TEXT = "EXTRA_TEXT";
    private static final String EXTRA_TEXT_ID = "EXTRA_TEXT_ID";
    private static final String EXTRA_TITLE = "EXTRA_TITLE";
    private static final String EXTRA_TITLE_ID = "EXTRA_TITLE_ID";
    private static final String EXTRA_TITLE_ICON_ID = "EXTRA_TITLE_ICON_ID";

    private static final String KEY_ARGUMENTS = "KEY_ARGUMENTS";

    /**
     *
     * @param text 表示するメッセージ
     * @param title タイトル。無いならnull
     * @param titleIconId タイトルアイコンの画像リソース。無いなら0
     * @return
     */
    public static SimpleMessageDialogFragment newInstance(CharSequence text,
            CharSequence title, int titleIconId) {
        SimpleMessageDialogFragment fragment = new SimpleMessageDialogFragment();
        Bundle args = new Bundle(3);
        args.putCharSequence(EXTRA_TEXT, text);
        args.putCharSequence(EXTRA_TITLE, title);
        args.putInt(EXTRA_TITLE_ICON_ID, titleIconId);
        fragment.setArguments(args);
        return fragment;
    }

    /**
     *
     * @param textId 表示するメッセージの文字列リソース
     * @param titleId タイトルの文字列リソース。無いなら0
     * @param titleIconId タイトルアイコンの画像リソース。無いなら0
     * @return
     */
    public static SimpleMessageDialogFragment newInstance(int textId,
            int titleId, int titleIconId) {
        SimpleMessageDialogFragment fragment = new SimpleMessageDialogFragment();
        Bundle args = new Bundle(3);
        args.putInt(EXTRA_TEXT_ID, textId);
        args.putInt(EXTRA_TITLE_ID, titleId);
        args.putInt(EXTRA_TITLE_ICON_ID, titleIconId);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setCancelable(true);
        setStyle(DialogFragment.STYLE_NORMAL, 0);
        Bundle args = getArguments();
        if (args == null && savedInstanceState != null) {
            args = savedInstanceState.getBundle(KEY_ARGUMENTS);
            setArguments(args);
        }
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Activity activity = getActivity();
        AlertDialog.Builder builder = new AlertDialog.Builder(activity)
            .setPositiveButton(android.R.string.ok, null);
        Bundle args = getArguments();
        if (args != null) {
            CharSequence text = args.getCharSequence(EXTRA_TEXT);
            if (text == null) {
                int textId = args.getInt(EXTRA_TEXT_ID);
                if (textId != 0) {
                    builder.setMessage(textId);
                }
            } else {
                builder.setMessage(text);
            }

            CharSequence title = args.getCharSequence(EXTRA_TITLE);
            if (title == null) {
                int titleId = args.getInt(EXTRA_TITLE_ID);
                if (titleId != 0) {
                    builder.setTitle(titleId);
                }
            } else {
                builder.setTitle(title);
            }

            int titleIconId = args.getInt(EXTRA_TITLE_ICON_ID);
            if (titleIconId != 0) {
                builder.setIcon(titleIconId);
            }
        }
        return builder.create();
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBundle(KEY_ARGUMENTS, getArguments());
    }
}
