package jp.sourceforge.nicoro.nicoscript;

import android.text.TextUtils;

import jp.sourceforge.nicoro.MessageChatController;
import jp.sourceforge.nicoro.MessageChatFork;
import jp.sourceforge.nicoro.Util;

// TODO 動画以外のジャンプ先コンテンツへの対応

public class NicoScriptJump extends NicoScript
implements NicoScript.Jump {
    protected static final String COMMAND = "ジャンプ";

    private String mJumpTo;
    private int mJumpToSecond = -1;
    private String mJumpToLabel = null;
    private String mJumpMessage;
    private int mJumpStartTimeSecond = -1;
    private int mReturnTimeSecond = -1;
    private String mReturnMessage;

    public NicoScriptJump(MessageChatFork chat, CommandSplitter commandSplitter) {
        super(chat);
        if (chat.getTime() < 0) {
            chat.setTime(Integer.MAX_VALUE);
        }

        mJumpTo = commandSplitter.getNextCommand();
        if (TextUtils.isEmpty(mJumpTo)) {
            return;
        }
        char ch0 = mJumpTo.charAt(0);
        if (ch0 == COMMAND_NUMBER_0 || ch0 == COMMAND_NUMBER_1) {
            String label = mJumpTo.substring(1);
            int time = getTimeSecond(label);
            if (time >= 0) {
                mJumpToSecond = time;
            } else {
                mJumpToLabel = label;
            }
        }
        mJumpMessage = commandSplitter.getNextCommandPhraze();
        if (mJumpMessage == null) {
            mJumpMessage = UNDEFINED_DEFAULT_JUMP_MESSAGE;
            return;
        }

        String jumpStartTime = commandSplitter.getNextCommand();
        if (jumpStartTime == null) {
            return;
        }
        mJumpStartTimeSecond = getTimeSecond(jumpStartTime);

        String returnTime = commandSplitter.getNextCommand();
        if (returnTime == null) {
            return;
        }
        mReturnTimeSecond = Util.parseInt(returnTime, -1);
        mReturnMessage = commandSplitter.getNextCommandPhraze();
    }

    @Override
    public String getJumpToVideoNumber() {
        if (mJumpToSecond >= 0 || mJumpToLabel != null) {
            return null;
        } else {
            return mJumpTo;
        }
    }

    @Override
    public int getJumpToSecond() {
        return mJumpToSecond;
    }

    @Override
    public String getJumpToLabel() {
        return mJumpToLabel;
    }

    @Override
    public String getJumpMessage() {
        return mJumpMessage;
    }

    @Override
    public int getJumpStartTimeSecond() {
        return mJumpStartTimeSecond;
    }

    @Override
    public int getReturnTimeSecond() {
        return mReturnTimeSecond;
    }

    @Override
    public String getReturnMessage() {
        return mReturnMessage;
    }

    @Override
    public boolean hasJumpMessage() {
        return mJumpMessage != UNDEFINED_DEFAULT_JUMP_MESSAGE;
    }

    @Override
    public void onPrepareRemove(MessageChatController controller) {
        controller.clearCommandJump(this);
    }

    @Override
    public void onDraw(MessageChatController controller) {
        controller.setCommandJump(this);
    }
}
