package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;
import static jp.sourceforge.nicoro.PlayerConstants.*;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.speech.RecognizerIntent;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;

import java.util.ArrayList;
import java.util.List;

import jp.gr.java_conf.shiseissi.commonlib.ViewUtil;

public class PlayerActivity extends FragmentActivity
implements DestroyTask.Callback, Handler.Callback {
    private static final boolean DEBUG_LOGV = Release.IS_DEBUG & true;
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;

    private static final long INTERVAL_TIME_UPDATE = 100L;
    private static final long INTERVAL_NOTIFICATION_TIME_UPDATE = 3000L;

    private static final String WAKELOCK_TAG_SUFFIX = "WakeLock";

    private Context mContext;
    private SharedPreferences mSharedPreferences;

    private RelativeLayout mParentScreen;
    private PlayerProgressViews mProgressViews = new PlayerProgressViews();
    private PlayerInfoViews mInfoViews = new PlayerInfoViews();
    private PlayerControllerViews mPlayerControllerViews = new PlayerControllerViews();

    private PlayerInfoControllerManager mPlayerInfoControllerManager;

    private AlertDialog mPlayFinishDialog;
    private AlertDialog mErrorDialog;

    private Rational mRationalCurrentPlayTime = new Rational();

    private final HandlerWrapper mHandler = new HandlerWrapper(this);

    private boolean mMessageDisable;
    private boolean mPauseCommentWrite;

    private StateManager mStateManager = new StateManager();
    private boolean mDidStartPlay = false;
    /** 生放送再生か否か */
    private boolean mIsLive;
//    private boolean mMoveTaskToBackAfterPlay;

    private boolean mIsThumbInfoOk;

    private int mLastOrientation;

    private PowerManager.WakeLock mWakeLock;

    private PhoneStateListener mPhoneStateListener;

    private AbstractPlayerFragment mPlayerFragment;
    private AbstractPlayerFragment mNextPlayerFragment;

    private NotificationController mNotificationController;

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case MSG_ID_MESSAGE_FINISHED:
                mProgressViews.setTextMessageFinished();
                break;
            case MSG_ID_MESSAGE_OCCURRED_ERROR:
                mProgressViews.setTextMessageError();
                showErrorDialog((String) msg.obj);
                break;
            case MSG_ID_THUMBINFO_FINISHED:
                ThumbInfoInterface thumbInfo = (ThumbInfoInterface) msg.obj;
                boolean isVideoDownloadOk = (msg.arg1 != 0);
                mProgressViews.setTextThumbinfoFinished();

                mInfoViews.setTitle(thumbInfo.getParsedTitle());
                mInfoViews.setDescription(thumbInfo.getDescription());
                mPlayerControllerViews.setSeekBarMax(thumbInfo.getLengthBySecond());
                mIsThumbInfoOk = true;

                if (isVideoDownloadOk) {
                    mPlayerControllerViews.setSeekBarSecondaryMax();
                }
                break;
            case MSG_ID_THUMBINFO_OCCURRED_ERROR:
                mProgressViews.setTextThumbinfoError();
                showErrorDialog((String) msg.obj);
                break;
            case MSG_ID_VIDEO_OCCURRED_ERROR:
                mProgressViews.setTextVideoError();
                showErrorDialog((String) msg.obj);
                break;
            case MSG_ID_VIDEO_NOTIFY_PROGRESS:
                mProgressViews.setTextVideoNotifyProgress(
                        msg.arg1, msg.arg2);
                mPlayerControllerViews.setSeekBarSecondaryProgress(msg.arg1, msg.arg2);
                break;
            case MSG_ID_INFO_TIME_UPDATE:
                if (!mStateManager.wasDestroyed()) {
                    AbstractPlayerFragment playerFragment = mPlayerFragment;
                    if (playerFragment != null && playerFragment.didStartPlay()) {
                        StringBuilder infoTimeData =
                            mInfoViews.setTime(playerFragment);

                        if (!mIsLive) {
                            mPlayerControllerViews.setTime(infoTimeData.toString());

                            mPlayerControllerViews.setSeekBarMax(
                                    playerFragment.getThumbInfo().getLengthBySecond());
                            if (mPlayerControllerViews.canUpdateSeekBarProgress()) {
                                // TODO: 二重呼び出しでちょっと無駄
                                playerFragment.getCurrentPositionVideoPlay(
                                        mRationalCurrentPlayTime);
                                mPlayerControllerViews.setSeekBarProgress(
                                        (int) (mRationalCurrentPlayTime.num / mRationalCurrentPlayTime.den));
                            }
                        }
                    }

                    // 繰り返し
                    mHandler.sendEmptyMessageDelayed(
                            MSG_ID_INFO_TIME_UPDATE, INTERVAL_TIME_UPDATE);
                }
                break;
            case MSG_ID_PLAY_ERROR:
                showErrorDialog((String) msg.obj);
                break;
            case MSG_ID_ENABLE_SEEK_BAR:
                mPlayerControllerViews.setEnabledSeekController(true);
                break;
            case MSG_ID_INFO_PLAY_DATA_UPDATE:
                AbstractPlayerFragment playerFragment = mPlayerFragment;
                if (playerFragment != null) {
                    mInfoViews.setPlayData(playerFragment);
                }
                break;
            case MSG_ID_PLAY_FINISHED_DIALOG: {
                DialogInterface.OnCancelListener onCancelListener =
                    new DialogInterface.OnCancelListener() {
                    @Override
                    public void onCancel(DialogInterface dialog) {
                        dialog.dismiss();
                        mPlayFinishDialog = null;
                    }
                };
                View.OnClickListener onClickListener = new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (mPlayFinishDialog != null) {
                            mPlayFinishDialog.dismiss();
                            mPlayFinishDialog = null;
                        }
                        Handler handler = mHandler;
                        handler.removeMessages(MSG_ID_AUTO_CLOSE);
                        switch (v.getId()) {
                            case R.id.button_quit:
                                finish();
                                break;
                            case R.id.button_replay:
                                // いったんシークバー他無効化
                                mPlayerControllerViews.setEnabledSeekController(false);
                                mPlayerControllerViews.setSeekBarProgress(0);
                                seekBySecond(0);
                                restartPlay();
                                break;
                            case R.id.button_dialog_close:
                                break;
                            default:
                                assert false : v.getId();
                                break;
                        }
                    }
                };
                Activity activity = PlayerActivity.this;
                LayoutInflater inflater = Util.getInflaterForDialogDark(activity);
                // LayoutParams生成のためダミーのViewも使用
                View playFinish = inflater.inflate(
                        R.layout.play_finish_dialog,
                        new FrameLayout(activity), false);
                playFinish.findViewById(R.id.button_quit).setOnClickListener(onClickListener);
                playFinish.findViewById(R.id.button_replay).setOnClickListener(onClickListener);
                playFinish.findViewById(R.id.button_dialog_close).setOnClickListener(onClickListener);
                mPlayFinishDialog = new AlertDialog.Builder(activity)
                    .setTitle(R.string.dialog_title_player_finish)
                    .setView(playFinish)
                    .setCancelable(true)
                    .setOnCancelListener(onCancelListener)
                    .show();
                mHandler.removeMessages(MSG_ID_AUTO_CLOSE);
                mHandler.sendEmptyMessageDelayed(MSG_ID_AUTO_CLOSE, 30000);
            } break;
            case MSG_ID_AUTO_CLOSE:
                finish();
                break;
            case MSG_ID_VIDEO_DOWNLOAD_FINISHED:
                mProgressViews.setTextVideoDownloadFinished();
                if (mIsThumbInfoOk) {
                    mPlayerControllerViews.setSeekBarSecondaryMax();
                }
                break;
            case MSG_ID_LIVE_MESSAGE_CONNECTED:
                mProgressViews.setTextMessageLiveConnected();
                break;
            case MSG_ID_LIVE_MESSAGE_OCCURRED_ERROR:
                mProgressViews.setTextMessageLiveError();
                break;
            case MSG_ID_GET_PLAYER_STATUS_SUCCEEDED:
                LivePlayerFragment.InfoData infoData =
                    (LivePlayerFragment.InfoData) msg.obj;
                if (DEBUG_LOGD) {
                    Log.d(LOG_TAG, infoData.toString());
                }
                mProgressViews.setTextThumbinfoFinished();
                mInfoViews.setTitle(infoData.title);
                mInfoViews.setDescription(infoData.description);
                mInfoViews.setLiveCountWatch(infoData.watchCount);
                mInfoViews.setLiveCountComment(infoData.commentCount);
                mInfoViews.setSheet(infoData.sheet);
                break;
            case MSG_ID_FORBID_SEEK_BY_CONTRIBUTOR:
                mPlayerControllerViews.setEnabledSeekController(false);
                mPlayerControllerViews.setContributorForbidSeekVisibility(true);
                break;
            case MSG_ID_ALLOW_SEEK_BY_CONTRIBUTOR:
                mPlayerControllerViews.setEnabledSeekController(true);
                mPlayerControllerViews.setContributorForbidSeekVisibility(false);
                break;
            case MSG_ID_FORBID_COMMENT_BY_CONTRIBUTOR:
                String disableMessage = getString(
                        R.string.forbid_comment_by_contributor);
                disableComment(disableMessage);
                break;
            case MSG_ID_ALLOW_COMMENT_BY_CONTRIBUTOR:
                enableComment();
                break;
            case MSG_ID_NOTIFICATION_TIME_UPDATE:
                if (!mStateManager.wasDestroyed()) {
                    mNotificationController.addRunningPlayer(getClass(), mPlayerFragment);
                    if (!mStateManager.isResuming() && mPlayerFragment != null) {
                        mPlayerFragment.savePlayState();
                    }

                    // 繰り返し
                    mHandler.sendEmptyMessageDelayed(
                            MSG_ID_NOTIFICATION_TIME_UPDATE,
                            INTERVAL_NOTIFICATION_TIME_UPDATE);
                }
                break;
            default:
                assert false : msg.what;
                break;
        }
        return true;
    }

    /**
     * 再生状態と一時停止状態を切り替える
     * @return 成否
     */
    protected boolean switchPausePlay() {
        AbstractPlayerFragment playerFragment = mPlayerFragment;
        if (playerFragment == null || !playerFragment.wasCreated()) {
            return false;
        } else {
            return playerFragment.switchPausePlay();
        }
    }

    /**
     * 再生を一時停止する
     */
    protected void pausePlay() {
        AbstractPlayerFragment playerFragment = mPlayerFragment;
        if (playerFragment != null && playerFragment.wasCreated()) {
            playerFragment.pausePlay();
        }
    }

    /**
     * 一時停止していた再生を再開する
     */
    protected void restartPlay() {
        AbstractPlayerFragment playerFragment = mPlayerFragment;
        if (playerFragment != null && playerFragment.wasCreated()) {
            playerFragment.restartPlay();
        }
    }

    /**
     * 再生が一時停止中か確認する
     * @return
     */
    protected boolean isPausePlay() {
        AbstractPlayerFragment playerFragment = mPlayerFragment;
        if (playerFragment == null || !playerFragment.wasCreated()) {
            return false;
        } else {
            return playerFragment.isPausePlay();
        }
    }
    /**
     * 秒単位でシークする
     * @param second
     */
    protected void seekBySecond(int second) {
        AbstractPlayerFragment playerFragment = mPlayerFragment;
        if (playerFragment != null) {
            playerFragment.seekBySecond(second);
        }
    }

    public void startPlay(ThumbInfoInterface thumbInfo) {
        startWakeLock();

        mProgressViews.setVisibilityGone();
        if (!mPlayerInfoControllerManager.isPlayerInfoShown()) {
            mPlayerInfoControllerManager.showPlayerInfo();
        }

        if (!thumbInfo.isNull()) {
            // 通常動画
            mInfoViews.setCountPlay(thumbInfo.getViewCounter());
            mInfoViews.setCountComment(thumbInfo.getCommentNum());
            mInfoViews.setCountMylist(thumbInfo.getMylistCounter());
        }

        mDidStartPlay = true;

//        if (mMoveTaskToBackAfterPlay) {
//            moveTaskToBack(true);
//            mMoveTaskToBackAfterPlay = false;
//        }
    }

    public void postStartPlay(int second, int maxSecond) {
        // 再開できるようにコントローラ表示
        mPlayerInfoControllerManager.showPlayerController();
        if (second > 0) {  // 0のときはシーク不要、マイナスは時間指定無し
            // いったんシークバー他無効化
            mPlayerControllerViews.setEnabledSeekController(false);
            mPlayerControllerViews.setSeekBarMax(maxSecond);
            mPlayerControllerViews.setSeekBarProgress(second);
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onCreate: savedInstanceState=")
                    .append(savedInstanceState).toString());
        }
        super.onCreate(savedInstanceState);
        mStateManager.onCreate(savedInstanceState);

        mContext = getApplicationContext();

        mSharedPreferences = Util.getDefaultSharedPreferencesMultiProcess(
                mContext);

        PowerManager powerManager = (PowerManager) getSystemService(POWER_SERVICE);
        mWakeLock = powerManager.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK,
                getClass().getSimpleName() + WAKELOCK_TAG_SUFFIX);
        mWakeLock.setReferenceCounted(false);

        mNotificationController = NotificationController.getInstance(mContext);

        Intent intent = getIntent();
        Bundle extras = intent.getExtras();
        if (extras == null) {
            if (savedInstanceState != null) {
                extras = savedInstanceState.getBundle(Util.KEY_EXTRAS);
            }
            if (extras == null) {
                // パラメータ無し起動：プレイヤーは終了してメインActivityへ
                Intent newIntent = new Intent(mContext, LoginActivity.class)
                    .setAction(Intent.ACTION_MAIN)
                    .addCategory(Intent.CATEGORY_DEFAULT)
                    .setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT
                            | Intent.FLAG_ACTIVITY_RESET_TASK_IF_NEEDED);
                startActivity(newIntent);
                finish();
                return;
            } else {
                intent.putExtras(extras);
            }
        }

        mDidStartPlay = false;
        mIsThumbInfoOk = false;
        mIsLive = intent.hasExtra(INTENT_NAME_LIVE_NUMBER);

        boolean playerLandscapeOnly = mSharedPreferences.getBoolean(
                getString(R.string.pref_key_player_landscape_only), false);
        if (playerLandscapeOnly) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        }

        mMessageDisable = mSharedPreferences.getBoolean(
                getString(R.string.pref_key_message_disable), false);
        mPauseCommentWrite = mSharedPreferences.getBoolean(
                getString(R.string.pref_key_pause_comment_write), true);

        boolean showHintToast = mSharedPreferences.getBoolean(
                getString(R.string.pref_key_show_hint_toast), true);
        if (showHintToast) {
            Util.showInfoToast(mContext,
                    R.string.toast_explain_player_ctrl);
        }

        Configuration config = getResources().getConfiguration();
        mLastOrientation = config.orientation;

        TelephonyManager telephonyManager = (TelephonyManager) getSystemService(
                TELEPHONY_SERVICE);
        if (telephonyManager != null) {
            mPhoneStateListener = new PhoneStateListener() {
                private boolean pauseOnCall = false;

                @Override
                public void onCallStateChanged(int state, String incomingNumber) {
                    // XXX 再生開始前に電話がかかってきた場合の状態管理が危うい
                    // TODO 通常動画と生放送の分け方
                    switch (state) {
                        case TelephonyManager.CALL_STATE_IDLE:
                            if (mIsLive) {
                            } else {
                                if (pauseOnCall) {
                                    restartPlay();
                                    setButtonPauseImage();
                                    pauseOnCall = false;
                                }
                            }
                            break;
                        case TelephonyManager.CALL_STATE_RINGING:
                        case TelephonyManager.CALL_STATE_OFFHOOK:
                            if (mIsLive) {
                                // TODO 電話かかってきたらとりあえず生放送は完全に停止
                                finish();
                            } else {
                                // 電話かかってきたら一時停止
                                if (!isPausePlay()) {
                                    pausePlay();
                                    setButtonPauseImage();
                                    pauseOnCall = true;
                                }
                            }
                            break;
                    }

                    super.onCallStateChanged(state, incomingNumber);
                }
            };
            telephonyManager.listen(mPhoneStateListener,
                    PhoneStateListener.LISTEN_CALL_STATE);
        }

        setContentView(getLayoutResID());
        initializeView();

        mPlayerFragment = ViewUtil.findFragmentById(getSupportFragmentManager(),
                R.id.video_area);
        if (mPlayerFragment == null) {
            mPlayerFragment = createPlayerFragment(
                    intent.getStringExtra(INTENT_NAME_VIDEO_URL));
            mPlayerFragment.setArguments(extras);
            getSupportFragmentManager().beginTransaction().add(
                    R.id.video_area, mPlayerFragment).commit();
        }
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        mStateManager.onRestart();
    }

    @Override
    protected void onStart() {
        super.onStart();
        mStateManager.onStart();
    }


    @Override
    protected void onResume() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onResume").toString());
        }
        super.onResume();
        mStateManager.onResume();

        if (mNextPlayerFragment != null) {
            replacePlayerFragmentInner(mNextPlayerFragment);
            mNextPlayerFragment = null;
            Util.showInfoToast(mContext, R.string.toast_jump_video_background);
        }
    }


    @Override
    protected void onSaveInstanceState(Bundle outState) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onSaveInstanceState: outState=")
                    .append(outState).toString());
        }
        super.onSaveInstanceState(outState);
        mStateManager.onSaveInstanceState();
        Bundle extras = getIntent().getExtras();
        if (extras != null) {
            outState.putBundle(Util.KEY_EXTRAS, extras);
        }
    }


    @Override
    protected void onPause() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onPause").toString());
        }
        super.onPause();
        mStateManager.onPause();
    }

    @Override
    protected void onStop() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onStop").toString());
        }
        super.onStop();
        mStateManager.onStop();
    }

    private class AsyncDestroyTask extends DestroyTask {
        private ProgressDialog progressDialog;

        AsyncDestroyTask() {
            super(PlayerActivity.this);
        }

        @Override
        protected void onPreExecuteImpl() {
            if (!mStateManager.wasDestroyed()) {
                ProgressDialog pd = Util.createProgressDialogLoading(
                        PlayerActivity.this,
                        R.string.progress_finish, null);
                pd.show();
                progressDialog = pd;
            }
        }
        @Override
        protected void onPostExecuteImpl() {
            closeProgressDialog();
        }

        @Override
        protected void timeoutImpl() {
            closeProgressDialog();
        }

        public void closeProgressDialog() {
            ProgressDialog pd = progressDialog;
            progressDialog = null;
            if (pd != null) {
                pd.dismiss();
            }
        }
    }
    private AsyncDestroyTask mDestroyTask = new AsyncDestroyTask();

    @Override
    public void finish() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#finish").toString());
        }

        if (mPlayFinishDialog != null) {
            mPlayFinishDialog.dismiss();
            mPlayFinishDialog = null;
        }
        if (mErrorDialog != null) {
            mErrorDialog.dismiss();
            mErrorDialog = null;
        }

        mDestroyTask.finishActivity();
        AbstractPlayerFragment playerFragment = mPlayerFragment;
        if (playerFragment != null) {
            playerFragment.finishFragment();
        }
    }

    @Override
    public void finishReally() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#finishReally").toString());
        }

        if (!mStateManager.wasDestroyed()) {
            super.finish();
        }
    }

    @Override
    protected void onDestroy() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onDestroy").toString());
        }
        mStateManager.onDestroy();

        if (!mDestroyTask.onDestroy()) {
            // 警告表示
            Util.showErrorToast(mContext,
                    R.string.toast_finish_timeout);
            mDestroyTask.closeProgressDialog();
        }
        super.onDestroy();
    }

    @Override
    public void onDestroyImplPre() {
        stopWakeLock();

        mHandler.release();

        if (mPhoneStateListener != null) {
            TelephonyManager telephonyManager = (TelephonyManager) getSystemService(
                    TELEPHONY_SERVICE);
            if (telephonyManager != null) {
                telephonyManager.listen(mPhoneStateListener,
                        PhoneStateListener.LISTEN_NONE);
            }
            mPhoneStateListener = null;
        }
    }

    @Override
    public void onDestroyImpl() {
        AbstractPlayerFragment playerFragment = mPlayerFragment;
        if (playerFragment != null) {
            playerFragment.waitOnDestroyImpl();
        }
    }

    @Override
    public void onDestroyImplPost() {
    }

    @Override
    public boolean wasDestroyed() {
        return mStateManager.wasDestroyed();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (mLastOrientation != newConfig.orientation) {
            onOrientationChanged(newConfig.orientation);
            mLastOrientation = newConfig.orientation;
        }
    }

    private void onOrientationChanged(int orientation) {
        RelativeLayout temp = ViewUtil.inflate(getLayoutInflater(),
                getLayoutResID(),
                (ViewGroup) getWindow().getDecorView(), false);

        mProgressViews.copyLayoutParamsFrom(temp);

        mInfoViews.copyLayoutParamsFrom(temp);

        mPlayerControllerViews.copyLayoutParamsFrom(temp);

        mPlayerInfoControllerManager.onOrientationChanged(orientation);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onTouchEvent: event=").append(event)
                    .toString());
        }
        if (mPlayerInfoControllerManager.onTouchEvent(event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onKeyDown: keyCode=").append(keyCode)
                    .append(" event=").append(event)
                    .toString());
        }
        if (mPlayerInfoControllerManager.onKeyDown(keyCode, event)) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onKeyUp: keyCode=").append(keyCode)
                    .append(" event=").append(event)
                    .toString());
        }
        return super.onKeyUp(keyCode, event);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == REQUEST_RECOGNIZE_SPEECH) {
            if (resultCode == RESULT_OK) {
                ArrayList<String> results = data.getStringArrayListExtra(
                        RecognizerIntent.EXTRA_RESULTS);
                if (results.size() > 0) {
                    mPlayerControllerViews.addCommentBody(results.get(0));
                }
            }
        }
    }

    protected void initializeView() {
        mParentScreen = ViewUtil.findViewById(this, R.id.parent_screen);

        mProgressViews.initializeView(this);

        mInfoViews.initializeView(this);

        mPlayerControllerViews.initializeView(this);
        mPlayerControllerViews.setButtonPauseOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mDidStartPlay) {
                    switchPausePlay();
                }
            }
        });
        mPlayerControllerViews.setButtonFromBeginOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // いったんシークバー他無効化
                mPlayerControllerViews.setEnabledSeekController(false);
                mPlayerControllerViews.setSeekBarProgress(0);
                seekBySecond(0);

                // TODO 最初に戻った後の再度再生するのはどうするか
            }
        });
        mPlayerControllerViews.setButtonCommentOnOffOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView,
                    boolean isChecked) {
                boolean messageDisable = !isChecked;
                if (mMessageDisable != messageDisable) {
                    mMessageDisable = messageDisable;
                    SharedPreferences.Editor editor = mSharedPreferences.edit();
                    editor.putBoolean(
                            getString(R.string.pref_key_message_disable),
                            mMessageDisable);
                    editor.commit();
                }
            }
        });
        mPlayerControllerViews.setCheckedButtonCommentOnOff(!mMessageDisable);
        mPlayerControllerViews.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress,
                    boolean fromUser) {
            }
            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
            }
            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                int second = seekBar.getProgress();
                int cacheSecond = seekBar.getSecondaryProgress();
                if (second > cacheSecond) {
                    // シーク位置はキャッシュの範囲内に抑える
                    second = cacheSecond;
                }
                // いったんシークバー他無効化
                mPlayerControllerViews.setEnabledSeekController(false);

//              // いったんポーズ
//              final boolean isPause = isPausePlay();
//              if (!isPause) {
//                  pausePlay();
//              }

//              seekBySecondCommon(second);
                seekBySecond(second);

//              if (!isPause) {
//                  restartPlay();
//              }
            }
        });
        mPlayerControllerViews.setOnSendCommentClickListener(new PlayerControllerViews.OnSendCommentClickListener() {
            @Override
            public void onClick(String mail, String body) {
                AbstractPlayerFragment playerFragment = mPlayerFragment;
                if (playerFragment == null) {
                    return;
                }
                playerFragment.sendComment(mail, body);
            }
        });
        mPlayerControllerViews.setOnCommentControllerClickListener(new PlayerControllerViews.OnCommentControllerClickListener() {
            @Override
            public void onClick() {
                if (mPauseCommentWrite) {
                    pausePlay();
                    setButtonPauseImage();
                }
            }
        });

        if (canUseRegonizeSpeech()) {
            mPlayerControllerViews.setSpeakVisibility(true);
            mPlayerControllerViews.setOnSpeakClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        Intent intent = new Intent(
                                RecognizerIntent.ACTION_RECOGNIZE_SPEECH);
                        intent.putExtra(
                                RecognizerIntent.EXTRA_LANGUAGE_MODEL,
                                RecognizerIntent.LANGUAGE_MODEL_FREE_FORM);
                        intent.putExtra(
                                RecognizerIntent.EXTRA_MAX_RESULTS ,
                                1);
                        intent.putExtra(
                                RecognizerIntent.EXTRA_PROMPT,
                                getString(R.string.prompt_speak_comment));
                        startActivityForResult(intent, REQUEST_RECOGNIZE_SPEECH);
                    } catch (ActivityNotFoundException e) {
                        Log.e(LOG_TAG, "queryIntentActivities return OK but ACTION_RECOGNIZE_SPEECH activity is not found",
                                e);
                    }
                }
            });
        } else {
            mPlayerControllerViews.setSpeakVisibility(false);
        }

        View timeView;
        if (mIsLive) {
            timeView = null;
        } else {
            timeView = mInfoViews.getTimeView();
        }
        // Viewが必要なためここで初期化
        mPlayerInfoControllerManager = new PlayerInfoControllerManager(
                mContext, mInfoViews.getInfoView(),
                mPlayerControllerViews.getControllerView(),
                timeView);
    }

    protected void setButtonPauseImage() {
        mPlayerControllerViews.setButtonPauseImage(isPausePlay());
    }

    void showErrorDialog(String errorMessage) {
        AlertDialog errorDialog = Util.createErrorDialog(this,
                errorMessage + getString(R.string.dialog_text_suffix_player_auto_close),
                true);
        if (!mStateManager.wasDestroyed()) {
            errorDialog.show();
        }
        onShowErrorDialog(errorDialog);
    }

    public void onShowErrorDialog(AlertDialog errorDialog) {
        mErrorDialog = errorDialog;
        stopWakeLock();
        Handler handler = mHandler;
        handler.removeMessages(MSG_ID_AUTO_CLOSE);
        handler.sendEmptyMessageDelayed(MSG_ID_AUTO_CLOSE, 30000);
    }

    private void startWakeLock() {
        if (!mWakeLock.isHeld()) {
            mWakeLock.acquire();
        }
        mNotificationController.addRunningPlayer(getClass(), mPlayerFragment);
    }
    public void stopWakeLock() {
        if (mWakeLock.isHeld()) {
            mWakeLock.release();
        }
        mNotificationController.cancelRunningPlayer();
    }

    public Handler getHandler() {
        return mHandler;
    }

    public boolean getMessageDisable() {
        return mMessageDisable;
    }

    public boolean canShowErrorDialog() {
        return (!isFinishing() && !mStateManager.wasDestroyed() &&
                (mErrorDialog == null || !mErrorDialog.isShowing()));
    }

    public RelativeLayout getParentScreen() {
        return mParentScreen;
    }

    public AbstractPlayerFragment createPlayerFragment(String getflvUrl) {
        if (mIsLive) {
            return new LivePlayerFragment();
        }

        if (getflvUrl == null) {
            // 想定外
            Log.w(LOG_TAG, "Video URL is null");
            // とりあえずデフォルトで起動を試みる
            return new FFmpegPlayerFragment();
        }

        if (NicoroAPIManager.isGetflvUrlFlv(getflvUrl)) {
            // flv
            return new FFmpegPlayerFragment();
        } else if (NicoroAPIManager.isGetflvUrlMp4(getflvUrl)) {
            // mp4
            if (mSharedPreferences.getBoolean(
                    mContext.getString(R.string.pref_key_mp4_mediaplayer), true)) {
                return new MediaPlayerFragment();
            } else {
                return new FFmpegPlayerFragment();
            }
        } else if (NicoroAPIManager.isGetflvUrlSwf(getflvUrl)) {
            return new SwfPlayerFragment();
        } else {
            // 想定外
            Log.w(LOG_TAG, Log.buf().append("Unrecognized video URL:")
                    .append(getflvUrl).toString());
            // とりあえずデフォルトで起動を試みる
            return new FFmpegPlayerFragment();
        }
    }

    public void setProgressTextInnerSwfPrepareWait() {
        mProgressViews.setTextInnerSwfPrepareWait();
    }
    public void setProgressTextInnerSwfPrepareFinished() {
        mProgressViews.setTextInnerSwfPrepareFinished();
    }

    private int getLayoutResID() {
        if (mIsLive) {
            return R.layout.liveplayer;
        } else {
            return R.layout.player;
        }
    }

    public void setPlayerFragment(AbstractPlayerFragment playerFragment) {
        mPlayerFragment = playerFragment;

        if (playerFragment != null) {
            Bundle args = playerFragment.getArguments();
            WatchVideo currentVideo = getIntent().getParcelableExtra(
                    INTENT_NAME_WATCH_VIDEO);
            WatchVideo newVideo = args.getParcelable(INTENT_NAME_WATCH_VIDEO);
            if (currentVideo != null && newVideo != null
                    && !newVideo.hasVideoNumber(currentVideo.v())) {
                Intent result = new Intent();
                result.putExtra(INTENT_NAME_WATCH_VIDEO, newVideo);
                setResult(Activity.RESULT_OK, result);
            }
        }
    }

    public void forbidSeekByContributor() {
        Handler handler = mHandler;
        handler.sendEmptyMessage(MSG_ID_FORBID_SEEK_BY_CONTRIBUTOR);
    }

    public void allowSeekByContributor() {
        Handler handler = mHandler;
        handler.sendEmptyMessage(MSG_ID_ALLOW_SEEK_BY_CONTRIBUTOR);
    }

    public void resetProgress() {
        mProgressViews.resetViewData();
        mProgressViews.setVisibilityVisible();
        mPlayerControllerViews.setSeekBarProgress(0);
        mPlayerControllerViews.setTime("");
    }

    public boolean isStarting() {
        return mStateManager.isStarting();
    }

    public void replacePlayerFragment(AbstractPlayerFragment playerFragment,
            boolean showProgress) {
        if (mStateManager.wasDestroyed()) {
            return;
        }

        if (showProgress) {
            resetProgress();
        }

        if (mStateManager.isStarting()) {
            replacePlayerFragmentInner(playerFragment);
        } else {
            // commitAllowingStateLossならバックグラウンドでも直接置換可能だが
            // 他にも問題があるので、Activityを表に戻してから差し替え

            mNextPlayerFragment = playerFragment;
//            mMoveTaskToBackAfterPlay = true;

            Intent intent = new Intent(mContext, PlayerActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK
//                    | Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT
                    | Intent.FLAG_ACTIVITY_RESET_TASK_IF_NEEDED
                    );
            // バックグラウンド状態ではActivity#startActivityでは起動しない
            mContext.startActivity(intent);
        }
    }

    private void replacePlayerFragmentInner(AbstractPlayerFragment playerFragment) {
        FragmentManager fm = getSupportFragmentManager();
        fm.beginTransaction().replace(
                R.id.video_area, playerFragment).commit();
        setPlayerFragment(playerFragment);
    }

    public void enableComment() {
        mPlayerControllerViews.enableComment();
    }

    public void disableComment(String disableMessage) {
        mPlayerControllerViews.disableComment(disableMessage);
    }

    public void forbidCommentByContributor() {
        Handler handler = mHandler;
        handler.sendEmptyMessage(MSG_ID_FORBID_COMMENT_BY_CONTRIBUTOR);
    }

    public void allowCommentByContributor() {
        Handler handler = mHandler;
        handler.sendEmptyMessage(MSG_ID_ALLOW_COMMENT_BY_CONTRIBUTOR);
    }

    private boolean canUseRegonizeSpeech() {
        PackageManager packageManager = getPackageManager();
        List<ResolveInfo> activities = packageManager.queryIntentActivities(
                new Intent(RecognizerIntent.ACTION_RECOGNIZE_SPEECH), 0);
        return !activities.isEmpty();
    }
}
