package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;
import android.graphics.Canvas;
import android.graphics.Paint;

import jp.sourceforge.nicoro.nicoscript.NicoScript;

/**
 * 投稿者コメント (chat)
 */
public class MessageChatFork extends MessageChat {
	private boolean mIsScript = false;
	private boolean mWasRunCommand;

	private NicoScript mNicoScript;

	public MessageChatFork(String mail, int vpos, int no,
            long date, String userId, int score) {
		super(mail, vpos, no, date, userId, score);
	}

	@Override
	public void setText(String text) {
		if (text != null) {
		    NicoScript script = NicoScript.createNicoScript(text, this);
		    if (script != null) {
                mIsScript = true;
                mNicoScript = script;
		    } else if (text.startsWith("＠") || text.startsWith("@")) {
		        // TODO NicoScriptが完成したら消す
				mIsScript = true;

				int separate1 = text.indexOf(' ');
				int separate2 = text.indexOf('　');
				String commandMain;
				int commandParamIndex;
				if (separate1 < 0) {
					if (separate2 < 0) {
						commandMain = text.substring(1);
						commandParamIndex = -1;
					} else {
						commandMain = text.substring(1, separate2);
						commandParamIndex = separate2 + 1;
					}
				} else {
					if (separate2 < 0) {
						commandMain = text.substring(1, separate1);
						commandParamIndex = separate1 + 1;
					} else if (separate1 < separate2) {
						commandMain = text.substring(1, separate1);
						commandParamIndex = separate1 + 1;
					} else {
						commandMain = text.substring(1, separate2);
						commandParamIndex = separate2 + 1;
					}
				}
                if (commandMain.equals("コメントマスク")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("キーワードメッセージ")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("ボタン")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("ポーズ")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("投票結果")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("投票ジャンプ")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("BGM")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("CM")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("玉窓ジャンプ")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("テキスト")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
				} else {
					Log.d(LOG_TAG, Log.buf().append("Unknown script=")
							.append(text).toString());
				}
			} else if (text.startsWith("/")) {
				// TODO ニワン語
				mIsScript = true;
			}
		}

		super.setText(text);
	}

	@Override
	protected boolean isScript() {
	    // TODO mNicoScriptの有無で判定するようにすべき
		return mIsScript;
	}
	@Override
	protected boolean isFork() {
		return true;
	}

	@Override
	public void prepareAdd(MessageChatController controller,
			Paint paintText, int vpos) {
		super.prepareAdd(controller, paintText, vpos);
		mWasRunCommand = false;
	}

    @Override
	public void prepareRemove(MessageChatController controller) {
		super.prepareRemove(controller);
		if (isScript()) {
		    if (mNicoScript != null) {
		        mNicoScript.onPrepareRemove(controller);
		    }
		}
	}

	@Override
	public void draw(int vpos, Canvas canvas, Paint paint,
			MessageChatController controller) {
		if (isScript()) {
			if (!mWasRunCommand) {
				if (vpos >= getVpos()) {
		            if (mNicoScript != null) {
		                // XXX ここで処理すると描画しないときにスクリプト処理されない
		                // canvas = nullで通るようにしたが処理的にちょっと無駄
		                mNicoScript.onDraw(controller);
		            }
					mWasRunCommand = true;
				}
			}
			return;
		}
		super.draw(vpos, canvas, paint, controller);
	}
}
