
package jp.sourceforge.nicoro;

public interface LiveMessageLoaderInterface extends XmlLoaderInterface {

    public interface EventListener {
        /**
         * サーバーと接続した
         * @param loader
         */
        void onConnected(LiveMessageLoaderInterface loader);
    	/**
    	 * 新しいMessageChatが追加された
    	 * 注意：連続して呼ばれる可能性あり
    	 * @param loader
    	 */
    	void onAddedMessage(LiveMessageLoaderInterface loader);
    	/**
    	 * ファイル全体の読み込み完了
    	 * @param loader
    	 */
    	void onFinished(LiveMessageLoaderInterface loader);
    	/**
    	 * エラー発生
    	 * @param loader
    	 * @param errorMessage
    	 */
    	void onOccurredError(LiveMessageLoaderInterface loader, String errorMessage);
    }

    boolean isNull();

    MessageChat poll();

    void setEventListener(LiveMessageLoaderInterface.EventListener eventListener);

    public static class NullObject extends XmlLoader.AbstractNullObject
    implements LiveMessageLoaderInterface {
        private static final NullObject sInstance = new NullObject();
        public static NullObject getInstance() {
            return sInstance;
        }

        private NullObject() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public MessageChat poll() {
            return null;
        }

        @Override
        public void setEventListener(EventListener eventListener) {
        }
    }

}
