package jp.sourceforge.nicoro;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;

import jp.gr.java_conf.shiseissi.commonlib.ViewUtil;

/**
 * プレイヤー画面のProgress Viewの集合
 */
public class PlayerProgressViews {
    private RelativeLayout mProgressGroup;
    private ProgressBar mProgressBar;
    private VariableLabelView mProgressTextVideo;
    private VariableLabelView mProgressTextThumbinfo;
    private VariableLabelView mProgressTextMessage;
    private VariableLabelView mProgressTextInner;

    private Context mContext;
    private Resources mRes;

    public void initializeView(Activity activity) {
        View root = activity.getWindow().getDecorView();
        initializeView(root);
    }

    public void initializeView(View root) {
        Context context = root.getContext().getApplicationContext();
        Resources res = root.getResources();
        mContext = context;
        mRes = res;

        mProgressGroup = ViewUtil.findViewById(root, R.id.progress_group);
        mProgressBar = ViewUtil.findViewById(root, R.id.progress);
        mProgressTextVideo = ViewUtil.findViewById(root, R.id.progress_text_video);
        mProgressTextThumbinfo = ViewUtil.findViewById(root, R.id.progress_text_thumbinfo);
        mProgressTextMessage = ViewUtil.findViewById(root, R.id.progress_text_message);
        mProgressTextInner = ViewUtil.findViewById(root, R.id.progress_text_inner);
        resetViewData();
    }

    public void resetViewData() {
        Context context = mContext;
        Resources res = mRes;

        mProgressTextVideo.setText(res.getString(R.string.progress_video_wait_connect));
        mProgressTextVideo.startAnimation(
                AnimationUtils.loadAnimation(context,
                        R.anim.blink));
        mProgressTextThumbinfo.setText(res.getString(R.string.progress_thumbinfo_wait));
        mProgressTextThumbinfo.startAnimation(
                AnimationUtils.loadAnimation(context,
                        R.anim.blink));
        mProgressTextMessage.setText(res.getString(R.string.progress_message_wait));
        mProgressTextMessage.startAnimation(
                AnimationUtils.loadAnimation(context,
                        R.anim.blink));
        mProgressTextInner.setText("");
        mProgressTextInner.clearAnimation();
    }

    public void copyLayoutParamsFrom(ViewGroup src) {
        ViewUtil.copyLayoutParamsById(mProgressBar, src);
        ViewUtil.copyLayoutParamsById(mProgressTextVideo, src);
        ViewUtil.copyLayoutParamsById(mProgressTextThumbinfo, src);
        ViewUtil.copyLayoutParamsById(mProgressTextMessage, src);
        ViewUtil.copyLayoutParamsById(mProgressTextInner, src);
    }

    public void setVisibilityGone() {
        mProgressGroup.setVisibility(View.GONE);
    }

    public void setVisibilityVisible() {
        mProgressGroup.setVisibility(View.VISIBLE);
    }

    public void setTextVideoDownloadFinished() {
        setTextVideo(
                mRes.getString(R.string.progress_video_finished));
    }
    public void setTextVideoError() {
        setTextVideo(
                mRes.getString(R.string.progress_video_error));
    }
    public void setTextVideoNotifyProgress(int num, int den) {
        StringBuilder textData = mProgressTextVideo.getTextBuilderWithClear();
        textData.append(num).append('/').append(den);
        mProgressTextVideo.notifyUpdateText();
        mProgressTextVideo.clearAnimation();
    }
    private void setTextVideo(String text) {
        mProgressTextVideo.setText(text);
        mProgressTextVideo.clearAnimation();
    }

    public void setTextThumbinfoFinished() {
        setTextThumbinfo(
                mRes.getString(R.string.progress_thumbinfo_finished));
    }
    public void setTextThumbinfoError() {
        setTextThumbinfo(
                mRes.getString(R.string.progress_thumbinfo_error));
    }
    private void setTextThumbinfo(String text) {
        mProgressTextThumbinfo.setText(text);
        mProgressTextThumbinfo.clearAnimation();
    }

    public void setTextMessageFinished() {
        setTextMessage(
                mRes.getString(R.string.progress_message_finished));
    }
    public void setTextMessageError() {
        setTextMessage(
                mRes.getString(R.string.progress_message_error));
    }
    public void setTextMessageLiveConnected() {
        setTextMessage(
                mRes.getString(R.string.progress_message_live_connected));
    }
    public void setTextMessageLiveError() {
        setTextMessage(
                mRes.getString(R.string.progress_message_live_error));
    }
    private void setTextMessage(String text) {
        mProgressTextMessage.setText(text);
        mProgressTextMessage.clearAnimation();
    }

    public void setTextInnerSwfPrepareWait() {
        mProgressTextInner.setText(
                mRes.getString(R.string.progress_swf_prepare_wait));
        mProgressTextInner.startAnimation(
                AnimationUtils.loadAnimation(mContext,
                        R.anim.blink));
    }
    public void setTextInnerSwfPrepareFinished() {
        mProgressTextInner.setText(
                mRes.getString(R.string.progress_swf_prepare_finished));
        mProgressTextInner.clearAnimation();
    }
}