package jp.sourceforge.nicoro;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.app.NavUtils;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;

import static jp.sourceforge.nicoro.Log.LOG_TAG;
import jp.gr.java_conf.shiseissi.commonlib.APILevelWrapper;
import jp.gr.java_conf.shiseissi.commonlib.ViewUtil;
import jp.sourceforge.nicoro.StaticRes.string;

public class MainFragmentActivity extends FragmentActivity
implements ListMenuUpdater, Handler.Callback {
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;

//    public static final String INTENT_EXTRA_MAIN_PANE_TYPE = "MAIN_PANE_TYPE";
//    public static final int MAIN_PANE_TYPE_BROWSER = 0;
//    public static final int MAIN_PANE_TYPE_LISTMENU = 1;

    private static final int MSG_ID_START_BROWSER = 1;
    private static final int MSG_ID_START_LISTMENU = 2;

    static final String KEY_SHOW_LIST_MENU_IN_DUAL_PANE = "ShowListMenuInDualPane";

    private Configuration mCurrentConfig;
    private boolean mIsDualPane;
    private boolean mReservePaneChange;
    private boolean mResumed = false;
    private boolean mShowListMenuInDualPane;
    private boolean mSavedInstanceState;

    private Bundle mBundleListMenu;

    private CallbackMessage<String, Void> mBrowserStarter;
    private CallbackMessage<Bundle, Void> mListMenuStarter;

    private View mViewPaneListMenu;

    private MenuItem mOptionsMenuListMenu;

    private final HandlerWrapper mHandler = new HandlerWrapper(this);

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case MSG_ID_START_BROWSER:
                String url = (String) msg.obj;
                updateWebBrowserUrl(url);
                break;
            case MSG_ID_START_LISTMENU:
                Bundle bundle = (Bundle) msg.obj;
                updateListMenu(bundle);
                break;
        }
        return true;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        mCurrentConfig = new Configuration(getResources().getConfiguration());
        updateIsDualPane(mCurrentConfig);

        setContentView(R.layout.main_fragment);
        mViewPaneListMenu = findViewById(R.id.pane_listmenu);

        Intent intent = getIntent();
        FragmentManager manager = getSupportFragmentManager();
        ListMenuFragment listMenuFragment;
        WebBrowserFragment webBrowserFragment;
        if (savedInstanceState == null) {
            if (mIsDualPane) {
                listMenuFragment = new ListMenuFragment();
                webBrowserFragment = new WebBrowserFragment();
                manager.beginTransaction()
                    .add(R.id.pane_listmenu, listMenuFragment,
                            string.tag_list_menu_fragment)
                    .add(R.id.pane_main, webBrowserFragment,
                            string.tag_webbrowser_fragment)
                    .commit();
                mShowListMenuInDualPane = true;
            } else {
                Fragment mainFragment;
                String tag;
//                int mainPaneType = intent.getIntExtra(INTENT_EXTRA_MAIN_PANE_TYPE,
//                        MAIN_PANE_TYPE_BROWSER);
//                switch (mainPaneType) {
//                    case MAIN_PANE_TYPE_LISTMENU:
//                        listMenuFragment = new ListMenuFragment();
//                        webBrowserFragment = null;
//                        mainFragment = listMenuFragment;
//                        tag = string.tag_list_menu_fragment;
//                        break;
//                    case MAIN_PANE_TYPE_BROWSER:
//                    default: // デフォルトはbrowser
                        listMenuFragment = null;
                        webBrowserFragment = new WebBrowserFragment();
                        mainFragment = webBrowserFragment;
                        tag = string.tag_webbrowser_fragment;
//                        break;
//                }
                manager.beginTransaction()
                    .add(R.id.pane_main, mainFragment, tag)
                    .commit();
                mShowListMenuInDualPane = false;
            }
        } else {
            FragmentTransaction transaction = manager.beginTransaction();
            if (mIsDualPane) {
                listMenuFragment = ViewUtil.findFragmentByTag(manager,
                        string.tag_list_menu_fragment);
                if (listMenuFragment == null) {
                    listMenuFragment = new ListMenuFragment();
                    transaction.add(R.id.pane_listmenu, listMenuFragment,
                            string.tag_list_menu_fragment);
                }
            } else {
                listMenuFragment = null;
            }
            webBrowserFragment = ViewUtil.findFragmentByTag(manager,
                    string.tag_webbrowser_fragment);
            if (webBrowserFragment == null) {
                webBrowserFragment = new WebBrowserFragment();
                transaction.add(R.id.pane_main, webBrowserFragment,
                        string.tag_webbrowser_fragment);
            }
            transaction.commit();

            mShowListMenuInDualPane = savedInstanceState.getBoolean(
                    KEY_SHOW_LIST_MENU_IN_DUAL_PANE, mIsDualPane);
        }
        int listMenuVisibility;
        if (mShowListMenuInDualPane) {
            listMenuVisibility = View.VISIBLE;
        } else {
            listMenuVisibility = View.GONE;
        }
        mViewPaneListMenu.setVisibility(listMenuVisibility);

        mBrowserStarter =
            new CallbackMessage<String, Void>(mHandler, MSG_ID_START_BROWSER);
        if (listMenuFragment != null) {
            listMenuFragment.setBrowserStarterCallback(mBrowserStarter);
            if (savedInstanceState == null) {
                // TODO ここでのintentそのまま使って良かったどうか
                listMenuFragment.update(intent);
            }
        }

        mListMenuStarter =
            new CallbackMessage<Bundle, Void>(mHandler, MSG_ID_START_LISTMENU);
        if (webBrowserFragment != null) {
            webBrowserFragment.setListMenuStarterCallback(mListMenuStarter);
            if (savedInstanceState == null) {
                // TODO Intentこの形式のままでいいのか？
                String url = getUrlFromIntentActionView(intent);
                webBrowserFragment.setStartUrl(url);
            }
        }

        mBundleListMenu = intent.getExtras();

        mOptionsMenuListMenu = null;
    }

    @Override
    protected void onStart() {
        super.onStart();
        mSavedInstanceState = false;

        APILevelWrapper api = APILevelWrapper.createInstance();
        api.setDisplayHomeAsUpEnabled_ActionBar(this, true);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        setIntent(intent);
        mBundleListMenu = intent.getExtras();

        String url = getUrlFromIntentActionView(intent);
        if (url != null) {
            updateWebBrowserUrl(url);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        mResumed = true;

        // 表示直後のIntent処理はFragment側から行う

        if (mReservePaneChange) {
            reflectPaneChange();
            mReservePaneChange = false;
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        mResumed = false;
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean(KEY_SHOW_LIST_MENU_IN_DUAL_PANE,
                mShowListMenuInDualPane);
        mSavedInstanceState = true;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        // 1.6向けなのでonKeyDownでback key監視
        // onBackPressedの活用は、API5からのため駄目
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            Fragment fragment = ViewUtil.findFragmentById(
                    getSupportFragmentManager(),
                    R.id.pane_main);
            if (fragment instanceof WebBrowserFragment) {
                if (((WebBrowserFragment) fragment).goBackWebView()) {
                    return true;
                }
            }
        }
        // TODO 何故かFragmentManagerImplでIllegalStateException起きるときがある？
        return super.onKeyDown(keyCode, event);
    }

    void updateListMenu(Bundle bundle) {
//        if (mSavedInstanceState) {
//            if (DEBUG_LOGD) {
//                Log.d(LOG_TAG, "after onSaveInstanceState, ignore MainFragmentActivity#updateListMenu");
//            }
//            return;
//        }

        if (mIsDualPane) {
            updateFragmentBookmarks(bundle);
            updateFragmentRelatedVideo(bundle);
            updateFragmentListMenu(bundle);
        } else {
//            FragmentManager manager = getSupportFragmentManager();
//            Fragment fragment = Util.findFragmentById(
//                    manager, R.id.pane_main);
//            if (fragment instanceof ListMenuFragment) {
//                updateFragmentBookmarks(bundle);
//                updateFragmentRelatedVideo(bundle);
//                updateFragmentListMenu(bundle);
//            } else {
//                FragmentTransaction transaction = manager.beginTransaction();
//                ListMenuFragment listMenuFragment =
//                    Util.findFragmentByTag(manager,
//                            string.tag_list_menu_fragment);
//                if (listMenuFragment == null) {
//                    mBundleListMenu = bundle;
//                    listMenuFragment = new ListMenuFragment();
//                    listMenuFragment.setBrowserStarterCallback(mBrowserStarter);
//                    transaction.addToBackStack(null)
//                        .add(R.id.pane_main, listMenuFragment,
//                                string.tag_list_menu_fragment);
//                } else {
//                    // TODO 子Fragment削除のため意味ないのでタイミングずらす？
//                    mBundleListMenu = bundle;
//                    listMenuFragment.clearChildFragments();
//                    transaction.addToBackStack(null)
//                        .remove(listMenuFragment)
//                        .add(R.id.pane_main, listMenuFragment,
//                                string.tag_list_menu_fragment);
////                    updateFragmentBookmarks(bundle);
////                    updateFragmentRelatedVideo(bundle);
////                    updateFragmentListMenu(bundle);
//                }
//                transaction.commit();
//            }

            Intent intent = new Intent(this, ListMenuActivity.class)
                .setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
            intent.replaceExtras(bundle);
            startActivity(intent);
        }
    }

    void updateFragmentBookmarks(Bundle bundle) {
        FragmentManager fragment = getSupportFragmentManager();
        BookmarksFragment bookmarks = ViewUtil.findFragmentByTag(fragment,
                string.tag_bookmarks_fragment);
        ListMenuFragment.updateFragmentBookmarks(bundle, bookmarks);
    }

    void updateFragmentRelatedVideo(Bundle bundle) {
        FragmentManager fragment = getSupportFragmentManager();
        RelatedVideoFragment relatedVideo = ViewUtil.findFragmentByTag(fragment,
                string.tag_related_video_fragment);
        ListMenuFragment.updateFragmentRelatedVideo(bundle, relatedVideo);
    }
    void updateFragmentListMenu(Bundle bundle) {
        FragmentManager fragment = getSupportFragmentManager();
        ListMenuFragment listMenu = ViewUtil.findFragmentByTag(fragment,
                string.tag_list_menu_fragment);
        listMenu.update(bundle);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        boolean lastIsDualPane = mIsDualPane;
        updateIsDualPane(newConfig);

        if (lastIsDualPane != mIsDualPane) {
            if (mResumed) {
                reflectPaneChange();
            } else {
                mReservePaneChange = true;
            }
            updateOptionsMenu();
        }

        mCurrentConfig.updateFrom(newConfig);
    }

    private void reflectPaneChange() {
//      FragmentManager manager = getSupportFragmentManager();
//      FragmentTransaction transaction = manager.beginTransaction();
//      ListMenuFragment listMenuFragment = Util.findFragmentByTag(
//              manager, string.tag_list_menu_fragment);
//      WebBrowserFragment webBrowserFragment = Util.findFragmentByTag(
//              manager, string.tag_webbrowser_fragment);
//      int listMenuVisibility;
//      if (mIsDualPane) {
//          listMenuVisibility = View.VISIBLE;
//
//          if (listMenuFragment == null) {
//              listMenuFragment = new ListMenuFragment();
//              listMenuFragment.setBrowserStarterCallback(mBrowserStarter);
//              // TODO 空のBundle作るのはちょっと無駄
//              listMenuFragment.update(new Bundle());
//          } else {
//              transaction.remove(listMenuFragment);
//          }
//          transaction.add(R.id.pane_listmenu, listMenuFragment,
//                  string.tag_list_menu_fragment);
//          if (webBrowserFragment == null) {
//              webBrowserFragment = new WebBrowserFragment();
//              webBrowserFragment.setListMenuStarterCallback(mListMenuStarter);
//              transaction.add(R.id.pane_main, webBrowserFragment,
//                      string.tag_webbrowser_fragment);
//          } else if (webBrowserFragment.getId() != R.id.pane_main) {
//              assert false;
//              transaction.remove(webBrowserFragment).add(
//                      R.id.pane_main, webBrowserFragment,
//                      string.tag_webbrowser_fragment);
//          }
//      } else {
//          listMenuVisibility = View.GONE;
//
//          if (listMenuFragment != null) {
//              assert listMenuFragment.getId() == R.id.pane_listmenu;
//              assert webBrowserFragment != null;
//              transaction.remove(listMenuFragment);
//          } else {
//              assert false;
//          }
//      }
//      View listMenuView = mViewPaneListMenu;
//      listMenuView.setVisibility(listMenuVisibility);
//      transaction.commit();

        FragmentManager manager = getSupportFragmentManager();
        ListMenuFragment listMenuFragment = ViewUtil.findFragmentByTag(
                manager, string.tag_list_menu_fragment);
        int listMenuVisibility;
        if (mIsDualPane) {
            if (mShowListMenuInDualPane) {
                listMenuVisibility = View.VISIBLE;
            } else {
                listMenuVisibility = View.GONE;
            }
            FragmentTransaction transaction = manager.beginTransaction();
            if (listMenuFragment == null) {
                listMenuFragment = new ListMenuFragment();
                listMenuFragment.setBrowserStarterCallback(mBrowserStarter);
                // TODO 空のBundle作るのはちょっと無駄
                listMenuFragment.update(new Bundle());
                transaction.add(R.id.pane_listmenu, listMenuFragment,
                        string.tag_list_menu_fragment);
            } else {
                transaction.show(listMenuFragment);
            }
            transaction.commit();
        } else {
            listMenuVisibility = View.GONE;
            if (listMenuFragment != null) {
                // TODO メモリのためにremoveすべき？
                manager.beginTransaction().hide(listMenuFragment).commit();
            }
        }
        mViewPaneListMenu.setVisibility(listMenuVisibility);
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        if (mOptionsMenuListMenu == null) {
            mOptionsMenuListMenu = menu.findItem(R.id.menu_list_menu);
            assert mOptionsMenuListMenu != null;
        }
        updateOptionsMenu();
        return super.onPrepareOptionsMenu(menu);
    }

    private void updateOptionsMenu() {
        if (mOptionsMenuListMenu == null) {
            return;
        }

        String listMenuTitle = getString(R.string.menu_list_menu);
        if (mIsDualPane) {
            if (mShowListMenuInDualPane) {
                listMenuTitle += " OFF";
            } else {
                listMenuTitle += " ON";
            }
        }
        if (!listMenuTitle.equals(mOptionsMenuListMenu.getTitle())) {
            mOptionsMenuListMenu.setTitle(listMenuTitle);
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case R.id.menu_list_menu:
                if (mIsDualPane) {
                    // リストメニューON/OFF切り替え
//                    int lastVisibility = mViewPaneListMenu.getVisibility();
                    int newVisibility;
//                    if (lastVisibility == View.VISIBLE) {
                    if (mShowListMenuInDualPane) {
                        newVisibility = View.GONE;
                        mShowListMenuInDualPane = false;
                    } else {
                        newVisibility = View.VISIBLE;
                        mShowListMenuInDualPane = true;

                        FragmentManager manager = getSupportFragmentManager();
                        ListMenuFragment listMenuFragment = ViewUtil.findFragmentByTag(
                                manager, string.tag_list_menu_fragment);
                        if (listMenuFragment == null) {
                            listMenuFragment = new ListMenuFragment();
                            listMenuFragment.setBrowserStarterCallback(mBrowserStarter);
                            // TODO 空のBundle作るのはちょっと無駄
                            listMenuFragment.update(new Bundle());
                            manager.beginTransaction().add(R.id.pane_listmenu,
                                    listMenuFragment, string.tag_list_menu_fragment)
                                .commit();
                        } else {
                            if (listMenuFragment.isHidden()) {
                                manager.beginTransaction().show(listMenuFragment)
                                    .commit();
                            }
                        }
                    }
                    mViewPaneListMenu.setVisibility(newVisibility);
                    updateOptionsMenu();
                    return true;
                }
                break;
            case android.R.id.home:
                NavUtils.navigateUpFromSameTask(this);
                return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public static boolean isDualPane(Configuration config) {
        return (config.orientation == Configuration.ORIENTATION_LANDSCAPE
                && ((config.screenLayout & Configuration.SCREENLAYOUT_SIZE_MASK)
                        >= Configuration.SCREENLAYOUT_SIZE_LARGE));
    }
    private void updateIsDualPane(Configuration config) {
        mIsDualPane = isDualPane(config);
    }

    void updateWebBrowserUrl(String url) {
        FragmentManager manager = getSupportFragmentManager();
        if (mIsDualPane) {
            WebBrowserFragment webBrowserFragment =
                ViewUtil.findFragmentByTag(manager,
                        string.tag_webbrowser_fragment);
            webBrowserFragment.updateCurrentUrl(url);
        } else {
            Fragment fragment = ViewUtil.findFragmentById(
                    manager, R.id.pane_main);
            if (fragment instanceof WebBrowserFragment) {
                ((WebBrowserFragment) fragment).updateCurrentUrl(url);
            } else {
                if (mSavedInstanceState) {
                    if (DEBUG_LOGD) {
                        Log.d(LOG_TAG, "after onSaveInstanceState, ignore MainFragmentActivity#updateWebBrowserUrl");
                    }
                } else {
                    FragmentTransaction transaction = manager.beginTransaction();
                    WebBrowserFragment webBrowserFragment =
                        ViewUtil.findFragmentByTag(manager,
                                string.tag_webbrowser_fragment);
                    if (webBrowserFragment == null) {
                        webBrowserFragment = new WebBrowserFragment();
                        webBrowserFragment.setStartUrl(url);
                        webBrowserFragment.setListMenuStarterCallback(mListMenuStarter);
                        transaction.addToBackStack(null)
                            .add(R.id.pane_main, webBrowserFragment,
                                    string.tag_webbrowser_fragment);
                    } else {
                        webBrowserFragment.updateCurrentUrl(url);
                        transaction.addToBackStack(null)
                            .remove(webBrowserFragment)
                            .add(R.id.pane_main, webBrowserFragment,
                                    string.tag_webbrowser_fragment);
                    }
                    transaction.commit();
                }
            }
        }
    }

    public static void startBrowserActivity(Activity activity, String url) {
        Intent intent;
        if (url == null) {
            intent = new Intent(activity, MainFragmentActivity.class);
        } else {
            intent = new Intent(
                    Intent.ACTION_VIEW,
                    Uri.parse(url),
                    activity, MainFragmentActivity.class)
                .addCategory(Intent.CATEGORY_BROWSABLE);
        }
        intent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
//        intent.putExtra(INTENT_EXTRA_MAIN_PANE_TYPE, MAIN_PANE_TYPE_BROWSER);
        activity.startActivity(intent);
    }

    public static void startListMenuActivity(Activity activity, int idListMenu) {
        Configuration config = activity.getResources().getConfiguration();
        Intent intent;
        if (isDualPane(config)) {
            intent = new Intent(activity, MainFragmentActivity.class);
        } else {
            intent = new Intent(activity, ListMenuActivity.class);
//            intent = new Intent(activity, MainFragmentActivity.class);
//            intent.putExtra(MainFragmentActivity.INTENT_EXTRA_MAIN_PANE_TYPE,
//                    MainFragmentActivity.MAIN_PANE_TYPE_LISTMENU);
        }
        intent.setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
        if (idListMenu != 0) {
            intent.putExtra(ListMenuActivity.INTENT_EXTRA_DEFAULT_LIST_RADIO,
                    idListMenu);
        }
        activity.startActivity(intent);
    }

    @Override
    public Bundle getExtrasForListMenu() {
        Bundle ret = mBundleListMenu;
        // TODO 二重更新いやなのでいったん消す
        mBundleListMenu = null;
        return ret;
    }

    public static String getUrlFromIntentActionView(Intent intent) {
        if (intent == null) {
            return null;
        }
        if (Intent.ACTION_VIEW.equals(intent.getAction())) {
            Uri uri = intent.getData();
            if (uri != null) {
                return uri.toString();
            }
        }
        return null;
    }

    /**
     * Auto Test向け
     * @return
     */
    boolean isDualPane() {
        return mIsDualPane;
    }

    /**
     * Auto Test向け
     * @return
     */
    boolean showListMenuInDualPane() {
        return mShowListMenuInDualPane;
    }
}
