
package jp.sourceforge.nicoro;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

import jp.sourceforge.nicoro.LiveVideoLoader.ErrorCode;

public interface LiveVideoLoaderInterface extends FFmpegIOCallback {

    boolean isNull();

    void startConnect(String url, String ticket, String playpath, boolean live, int start,
            String liveNumber, String extras, CallbackMessage<Void, ErrorCode> callback);

    void startConnect(String url, String ticket, String playpath, boolean live, int start,
            String liveNumber, String akamaiUser, String akamaiPassword, String extras,
            CallbackMessage<Void, ErrorCode> callback);

    void startReconnect();

    void close();

    void closeAsync(ExecutorService executorService, final CountDownLatch latch);

    void free();

    void start();

    boolean quit();

    public static class NullObject implements LiveVideoLoaderInterface {
        private static final NullObject sInstance = new NullObject();
        public static NullObject getInstance() {
            return sInstance;
        }

        private NullObject() {
        }

        @Override
        public int readFromNativeCallback(int bufSize, byte[] buffer) {
            return -1;
        }

        @Override
        public long seekFromNativeCallback(long offset, int whence) {
            return -1;
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public void startConnect(String url, String ticket, String playpath, boolean live,
                int start, String liveNumber, String extras,
                CallbackMessage<Void, ErrorCode> callback) {
        }

        @Override
        public void startConnect(String url, String ticket, String playpath, boolean live,
                int start, String liveNumber, String akamaiUser, String akamaiPassword,
                String extras, CallbackMessage<Void, ErrorCode> callback) {
        }

        @Override
        public void startReconnect() {
        }

        @Override
        public void close() {
        }

        @Override
        public void closeAsync(ExecutorService executorService, CountDownLatch latch) {
            latch.countDown();
        }

        @Override
        public void free() {
        }

        @Override
        public void start() {
        }

        @Override
        public boolean quit() {
            return true;
        }
    }
}
