package jp.sourceforge.nicoro;

import android.app.Instrumentation;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.test.ActivityUnitTestCase;

public abstract class AbstractListMenuFragmentBodyUnitTest extends ActivityUnitTestCase<ListMenuActivity> {
    protected Instrumentation mInstr;
    protected Context mContext;

    private ListMenuActivity mActivity;

    public AbstractListMenuFragmentBodyUnitTest(Class<ListMenuActivity> activityClass) {
        super(activityClass);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        mInstr = getInstrumentation();
        mContext = mInstr.getTargetContext();
    }

    @Override
    protected void tearDown() throws Exception {
        mInstr = null;
        mContext = null;
        mActivity = null;
        super.tearDown();
    }

    protected void commonTestOnCreate(final int radioId,
            final String fragmentTag) throws Throwable {
        runTestOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    mActivity = startActivity(null, radioId);
                } catch (RuntimeException e) {
                    throw e;
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        callActivityOnStart();
        callActivityOnResume();
        Fragment fragment = Util.findFragmentByTag(
                mActivity.getSupportFragmentManager(),
                fragmentTag);
        assertNotNull(fragment);
        callActivityOnPause();
        callActivityOnStop();
        callActivityOnDestroy();
    }

    protected void commonTestOnCreateSavedInstanceStateAnyItem(final int radioId,
            final String fragmentTag) throws Throwable {
        final Bundle savedInstanceState = new Bundle();
        runTestOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    mActivity = startActivity(null, radioId);
                } catch (RuntimeException e) {
                    throw e;
                } catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        callActivityOnStart();
        callActivityOnResume();
        Fragment fragment = Util.findFragmentByTag(
                mActivity.getSupportFragmentManager(),
                fragmentTag);
        assertNotNull(fragment);
        callActivityOnPause();
        callActivityOnSaveInstanceState(savedInstanceState);
        callActivityOnStop();
        callActivityOnDestroy();

        callActivityOnCreate(savedInstanceState);
        callActivityOnStart();
        callActivityOnResume();
        fragment = Util.findFragmentByTag(
                mActivity.getSupportFragmentManager(),
                fragmentTag);
        assertNotNull(fragment);
        callActivityOnPause();
        callActivityOnSaveInstanceState(savedInstanceState);
        callActivityOnStop();
        callActivityOnDestroy();
    }

    protected ListMenuActivity startActivity(
            Bundle savedInstanceState, int radioId) throws Exception {
        NicoroApplication application = (NicoroApplication) Instrumentation.newApplication(
                NicoroApplication.class, mContext);
        setApplication(application);
        Intent intent = new Intent(mContext, ListMenuActivity.class);
        intent.putExtra(ListMenuActivity.INTENT_EXTRA_DEFAULT_LIST_RADIO,
                radioId);
        return startActivity(intent, savedInstanceState, null);
    }

    private void callActivityOnCreate(final Bundle savedInstanceState) throws Throwable {
        TestUtil.callActivityOnCreate(this, mActivity, savedInstanceState);
    }
    private void callActivityOnStart() throws Throwable {
        TestUtil.callActivityOnStart(this, mActivity);
    }
    private void callActivityOnResume() throws Throwable {
        TestUtil.callActivityOnResume(this, mActivity);
    }
    private void callActivityOnPause() throws Throwable {
        TestUtil.callActivityOnPause(this, mActivity);
    }
    private void callActivityOnStop() throws Throwable {
        TestUtil.callActivityOnStop(this, mActivity);
    }
    private void callActivityOnDestroy() throws Throwable {
        TestUtil.callActivityOnDestroy(this, mActivity);
    }
    private void callActivityOnSaveInstanceState(final Bundle savedInstanceState) throws Throwable {
        TestUtil.callActivityOnSaveInstanceState(this, mActivity, savedInstanceState);
    }
}
