package jp.sourceforge.nicoro;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;

/**
 * プレイヤー画面のProgress Viewの集合
 */
public class PlayerProgressViews {
    private RelativeLayout mProgressGroup;
    private ProgressBar mProgressBar;
    private VariableLabelView mProgressTextVideo;
    private VariableLabelView mProgressTextThumbinfo;
    private VariableLabelView mProgressTextMessage;
    private VariableLabelView mProgressTextMessageFork;
    private VariableLabelView mProgressTextInner;

    private Context mContext;
    private Resources mRes;

    public void initializeView(Activity activity) {
        View root = activity.getWindow().getDecorView();
        initializeView(root);
    }

    public void initializeView(View root) {
        Context context = root.getContext().getApplicationContext();
        Resources res = root.getResources();
        mContext = context;
        mRes = res;

        mProgressGroup = Util.findViewById(root, R.id.progress_group);
        mProgressBar = Util.findViewById(root, R.id.progress);
        mProgressTextVideo = Util.findViewById(root, R.id.progress_text_video);
        mProgressTextVideo.setText(res.getString(R.string.progress_video_wait_connect));
        mProgressTextVideo.startAnimation(
                AnimationUtils.loadAnimation(context,
                        R.anim.blink));
        mProgressTextThumbinfo = Util.findViewById(root, R.id.progress_text_thumbinfo);
        mProgressTextThumbinfo.setText(res.getString(R.string.progress_thumbinfo_wait));
        mProgressTextThumbinfo.startAnimation(
                AnimationUtils.loadAnimation(context,
                        R.anim.blink));
        mProgressTextMessage = Util.findViewById(root, R.id.progress_text_message);
        mProgressTextMessage.setText(res.getString(R.string.progress_message_wait));
        mProgressTextMessage.startAnimation(
                AnimationUtils.loadAnimation(context,
                        R.anim.blink));
        mProgressTextMessageFork = Util.findViewById(root, R.id.progress_text_message_fork);
        mProgressTextMessageFork.setText(res.getString(R.string.progress_message_fork_wait));
        mProgressTextMessageFork.startAnimation(
                AnimationUtils.loadAnimation(context,
                        R.anim.blink));
        mProgressTextInner = Util.findViewById(root, R.id.progress_text_inner);
    }

    public void copyLayoutParamsFrom(ViewGroup src) {
        Util.copyLayoutParamsById(mProgressBar, src);
        Util.copyLayoutParamsById(mProgressTextVideo, src);
        Util.copyLayoutParamsById(mProgressTextThumbinfo, src);
        Util.copyLayoutParamsById(mProgressTextMessage, src);
        Util.copyLayoutParamsById(mProgressTextMessageFork, src);
        Util.copyLayoutParamsById(mProgressTextInner, src);
    }

    public void setVisibilityGone() {
        mProgressGroup.setVisibility(View.GONE);
    }

    public void setTextVideoDownloadFinished() {
        setTextVideo(
                mRes.getString(R.string.progress_video_finished));
    }
    public void setTextVideoError() {
        setTextVideo(
                mRes.getString(R.string.progress_video_error));
    }
    public void setTextVideoNotifyProgress(int num, int den) {
        StringBuilder textData = mProgressTextVideo.getTextBuilder();
        textData.setLength(0);
        textData.append(num).append('/').append(den);
        mProgressTextVideo.notifyUpdateText();
        mProgressTextVideo.clearAnimation();
    }
    private void setTextVideo(String text) {
        mProgressTextVideo.setText(text);
        mProgressTextVideo.clearAnimation();
    }

    public void setTextThumbinfoFinished() {
        setTextThumbinfo(
                mRes.getString(R.string.progress_thumbinfo_finished));
    }
    public void setTextThumbinfoError() {
        setTextThumbinfo(
                mRes.getString(R.string.progress_thumbinfo_error));
    }
    private void setTextThumbinfo(String text) {
        mProgressTextThumbinfo.setText(text);
        mProgressTextThumbinfo.clearAnimation();
    }

    public void setTextMessageFinished() {
        setTextMessage(
                mRes.getString(R.string.progress_message_finished));
    }
    public void setTextMessageError() {
        setTextMessage(
                mRes.getString(R.string.progress_message_error));
    }
    public void setTextMessageLiveConnected() {
        setTextMessage(
                mRes.getString(R.string.progress_message_live_connected));
    }
    public void setTextMessageLiveError() {
        setTextMessage(
                mRes.getString(R.string.progress_message_live_error));
    }
    private void setTextMessage(String text) {
        mProgressTextMessage.setText(text);
        mProgressTextMessage.clearAnimation();
    }

    public void setTextMessageForkFinished() {
        setTextMessageFork(
                mRes.getString(R.string.progress_message_fork_finished));
    }
    public void setTextMessageForkError() {
        setTextMessageFork(
                mRes.getString(R.string.progress_message_fork_error));
    }
    private void setTextMessageFork(String text) {
        mProgressTextMessageFork.setText(text);
        mProgressTextMessageFork.clearAnimation();
    }

    public void setVisibilityGoneMessageFork() {
        mProgressTextMessageFork.setVisibility(View.GONE);
    }

    public void setTextInnerSwfPrepareWait() {
        mProgressTextInner.setText(
                mRes.getString(R.string.progress_swf_prepare_wait));
        mProgressTextInner.startAnimation(
                AnimationUtils.loadAnimation(mContext,
                        R.anim.blink));
    }
    public void setTextInnerSwfPrepareFinished() {
        mProgressTextInner.setText(
                mRes.getString(R.string.progress_swf_prepare_finished));
        mProgressTextInner.clearAnimation();
    }
}