package jp.sourceforge.nicoro;

import android.app.Activity;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AnalogClock;

public class PlayerInfoViews {
//    private VariableLabelView mInfoClock;
    private VariableLabelView mInfoCountPlay;
    private VariableLabelView mInfoCountComment;
    /** nullの可能性あり */
    private VariableLabelView mInfoCountMylist;
    private VariableLabelView mInfoTitle;
    private VariableLabelView mInfoDescription;
    private VariableLabelView mInfoPlayData;
    private VariableLabelView mInfoTime;
    /** nullの可能性あり */
    private VariableLabelView mInfoSheet;
    private AnalogClock mInfoClock;
    private ViewGroup mPlayerInfo;

    private Resources mRes;

    public void initializeView(Activity activity) {
        View root = activity.getWindow().getDecorView();
        initializeView(root);
    }

    public void initializeView(View root) {
        mRes = root.getResources();

        mInfoClock = Util.findViewById(root, R.id.info_clock);
        mInfoCountPlay = Util.findViewById(root, R.id.info_count_play);
        mInfoCountComment = Util.findViewById(root, R.id.info_count_comment);
        mInfoCountMylist = Util.findViewById(root, R.id.info_count_mylist);
        mInfoTime = Util.findViewById(root, R.id.info_time);
        mInfoTitle = Util.findViewById(root, R.id.info_title);
        mInfoDescription = Util.findViewById(root, R.id.info_description);
        mInfoPlayData = Util.findViewById(root, R.id.info_play_data);
        mPlayerInfo = Util.findViewById(root, R.id.player_info);
        mInfoSheet = Util.findViewById(root, R.id.info_sheet);
    }

    public void copyLayoutParamsFrom(ViewGroup src) {
        Util.copyLayoutParamsById(mInfoClock, src);
        Util.copyLayoutParamsById(mInfoCountPlay, src);
        Util.copyLayoutParamsById(mInfoCountComment, src);
        if (mInfoCountMylist != null) {
            Util.copyLayoutParamsById(mInfoCountMylist, src);
        }
        Util.copyLayoutParamsById(mInfoTime, src);
        Util.copyLayoutParamsById(mInfoTitle, src);
        Util.copyLayoutParamsById(mInfoDescription, src);
        Util.copyLayoutParamsById(mInfoPlayData, src);
        Util.copyLayoutParamsById(mPlayerInfo, src);
        if (mInfoSheet != null) {
            Util.copyLayoutParamsById(mInfoSheet, src);
        }
    }

    public void setCountPlay(int count) {
        mInfoCountPlay.getTextBuilder()
            .append(mRes.getString(R.string.info_count_play))
            .append(count);
        mInfoCountPlay.notifyUpdateText();
    }
    public void setLiveCountWatch(String count) {
        mInfoCountPlay.getTextBuilder()
            .append(mRes.getString(R.string.info_live_count_watch))
            .append(count);
        mInfoCountPlay.notifyUpdateText();
    }

    public void setCountComment(int count) {
        mInfoCountComment.getTextBuilder()
            .append(mRes.getString(R.string.info_count_comment))
            .append(count);
        mInfoCountComment.notifyUpdateText();
    }
    public void setLiveCountComment(String count) {
        mInfoCountComment.getTextBuilder()
            .append(mRes.getString(R.string.info_live_count_comment))
            .append(count);
        mInfoCountComment.notifyUpdateText();
    }

    public void setCountMylist(int count) {
        if (mInfoCountMylist == null) {
            return;
        }
        mInfoCountMylist.getTextBuilder()
            .append(mRes.getString(R.string.info_count_mylist))
            .append(count);
        mInfoCountMylist.notifyUpdateText();
    }

    public void setTitle(String text) {
        mInfoTitle.setText(text);
    }

    public void setDescription(String text) {
        mInfoDescription.setText(text);
    }

    public void setSheet(String text) {
        if (mInfoSheet != null) {
            mInfoSheet.setText(text);
        }
    }

    public void setPlayData(PlayDataAppender appender) {
        StringBuilder builderInfoPlayData = mInfoPlayData.getTextBuilderWithClear();
        builderInfoPlayData.append(mRes.getString(R.string.info_play_data_pre));
        appender.appendMovieType(builderInfoPlayData);
        builderInfoPlayData.append(' ');
        appender.appendVideoResolution(builderInfoPlayData).append(' ');
        appender.appendPlayerInfo(builderInfoPlayData);
        mInfoPlayData.notifyUpdateText();
    }

    /**
     *
     * @param appender
     * @return 文字列生成後のStringBuilder
     */
    public StringBuilder setTime(TimeAppender appender) {
        StringBuilder infoTimeData = mInfoTime.getTextBuilderWithClear();
        appender.appendCurrentPlayTime(infoTimeData);
        if (appender.hasTotalPlayTime()) {
            infoTimeData.append('/');
            appender.appendTotalPlayTime(infoTimeData);
        }
        mInfoTime.notifyUpdateText();
        return infoTimeData;
    }

    public ViewGroup getInfoView() {
        return mPlayerInfo;
    }
    public View getTimeView() {
        return mInfoTime;
    }

    public interface PlayDataAppender {
        StringBuilder appendMovieType(StringBuilder builder);
        StringBuilder appendVideoResolution(StringBuilder builder);
        StringBuilder appendPlayerInfo(StringBuilder builder);
    }

    public interface TimeAppender {
        StringBuilder appendCurrentPlayTime(StringBuilder builder);
        StringBuilder appendTotalPlayTime(StringBuilder builder);
        boolean hasTotalPlayTime();
    }
}
