package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;
import android.graphics.Canvas;
import android.graphics.Paint;

import jp.sourceforge.nicoro.nicoscript.NicoScript;

/**
 * 投稿者コメント (chat)
 */
public class MessageChatFork extends MessageChat {
	private boolean mIsScript = false;
	private boolean mWasRunCommand;

	private NicoScript mNicoScript;

	public MessageChatFork(String mail, int vpos, int no,
            long date, String userId) {
		super(mail, vpos, no, date, userId, true);
	}

	@Override
	public void setText(String text) {
		if (text != null) {
		    NicoScript script = NicoScript.createNicoScript(text, this);
		    if (script != null) {
                mIsScript = true;
                mNicoScript = script;
		    } else if (text.startsWith("＠") || text.startsWith("@")) {
		        // TODO NicoScriptが完成したら消す
				mIsScript = true;

				int separate1 = text.indexOf(' ');
				int separate2 = text.indexOf('　');
				String commandMain;
				int commandParamIndex;
				if (separate1 < 0) {
					if (separate2 < 0) {
						commandMain = text.substring(1);
						commandParamIndex = -1;
					} else {
						commandMain = text.substring(1, separate2);
						commandParamIndex = separate2 + 1;
					}
				} else {
					if (separate2 < 0) {
						commandMain = text.substring(1, separate1);
						commandParamIndex = separate1 + 1;
					} else if (separate1 < separate2) {
						commandMain = text.substring(1, separate1);
						commandParamIndex = separate1 + 1;
					} else {
						commandMain = text.substring(1, separate2);
						commandParamIndex = separate2 + 1;
					}
				}
//				if (commandMain.equals("デフォルト")) {
//					mScriptCommand = SCRIPT_COMMAND_DEFAULT;
//                } else
                if (commandMain.equals("置換")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
//				} else if (commandMain.equals("逆")) {
//					mScriptCommand = SCRIPT_COMMAND_GYAKU;
//					if (mTime < 0) {
//						mTime = 30; // デフォルト値
//					}
//					if (commandParamIndex < 0) {
//						mScriptCommandSub = SCRIPT_COMMAND_SUB_GYAKU_SUBE;
//					} else {
//						String commandSub = text.substring(commandParamIndex);
//						if (commandSub.startsWith("全")) {
//							mScriptCommandSub = SCRIPT_COMMAND_SUB_GYAKU_SUBE;
//						} else if (commandSub.startsWith("コメ")) {
//							mScriptCommandSub = SCRIPT_COMMAND_SUB_GYAKU_COMME;
//						} else if (commandSub.startsWith("投コメ")) {
//							mScriptCommandSub = SCRIPT_COMMAND_SUB_GYAKU_TOUCOMME;
//						} else {
//							mScriptCommandSub = SCRIPT_COMMAND_SUB_GYAKU_SUBE;
//						}
//					}
                } else if (commandMain.equals("コメントマスク")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("コメント禁止")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("キーワードメッセージ")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("ボタン")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("シーク禁止")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("ポーズ")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("ジャンプ")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("キーワードジャンプ")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("ジャンプマーカー")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("投票")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("投票結果")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("投票ジャンプ")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("スコア")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("スコア表示")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("スコアジャンプ")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("BGM")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("CM")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("玉")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("窓")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("玉窓ジャンプ")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("ドア")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
                } else if (commandMain.equals("テキスト")) {
                    // TODO
                    Log.d(LOG_TAG, Log.buf().append("Unimplement script=")
                            .append(text).toString());
				} else {
					Log.d(LOG_TAG, Log.buf().append("Unknown script=")
							.append(text).toString());
				}
			} else if (text.startsWith("/")) {
				// TODO ニワン語
				mIsScript = true;
			}
		}

		super.setText(text);
	}

	@Override
	protected boolean isScript() {
	    // TODO mNicoScriptの有無で判定するようにすべき
		return mIsScript;
	}
	@Override
	protected boolean isFork() {
		return true;
	}

	@Override
	public void prepareAdd(MessageChatController controller,
			Paint paintText, int vpos) {
		super.prepareAdd(controller, paintText, vpos);
		mWasRunCommand = false;
	}

    @Override
	public void prepareRemove(MessageChatController controller) {
		super.prepareRemove(controller);
		if (isScript()) {
		    if (mNicoScript != null) {
		        mNicoScript.onPrepareRemove(controller);
		    }
		}
	}

	@Override
	public void draw(int vpos, Canvas canvas, Paint paint,
			MessageChatController controller) {
		if (isScript()) {
			if (!mWasRunCommand) {
				if (vpos >= getVpos()) {
		            if (mNicoScript != null) {
		                mNicoScript.onDraw(controller);
		            }
					mWasRunCommand = true;
				}
			}
			return;
		}
		super.draw(vpos, canvas, paint, controller);
	}
}
