package jp.sourceforge.nicoro;

import java.lang.ref.SoftReference;

public abstract class Log {
	public static final String LOG_TAG = "NicoRo";

	private static final String MSG_NULL = "(msg=null)";

	private static final int LONG_DIVIDE_SIZE = 2048;

	private static ThreadLocal<SoftReference<StringBuilder>> sLogBuffer =
		new ThreadLocalStringBuilder();

    public static int v(String tag, String msg) {
        return android.util.Log.v(tag, msg == null ? MSG_NULL : msg);
    }
    public static int v(String tag, String msg, Throwable tr) {
        return android.util.Log.v(tag, msg == null ? MSG_NULL : msg, tr);
    }
    public static int d(String tag, String msg) {
        return android.util.Log.d(tag, msg == null ? MSG_NULL : msg);
    }
    public static int d(String tag, String msg, Throwable tr) {
        return android.util.Log.d(tag, msg == null ? MSG_NULL : msg, tr);
    }
    public static int i(String tag, String msg) {
        return android.util.Log.i(tag, msg == null ? MSG_NULL : msg);
    }
    public static int i(String tag, String msg, Throwable tr) {
        return android.util.Log.i(tag, msg == null ? MSG_NULL : msg, tr);
    }
    public static int w(String tag, String msg) {
        return android.util.Log.w(tag, msg == null ? MSG_NULL : msg);
    }
    public static int w(String tag, String msg, Throwable tr) {
        return android.util.Log.w(tag, msg == null ? MSG_NULL : msg, tr);
    }
    public static int e(String tag, String msg) {
        return android.util.Log.e(tag, msg == null ? MSG_NULL : msg);
    }
    public static int e(String tag, String msg, Throwable tr) {
        return android.util.Log.e(tag, msg == null ? MSG_NULL : msg, tr);
    }

    public static int dLong(String tag, String msg) {
        if (msg == null) {
            return d(tag, null);
        }
        int length = msg.length();
        if (length <= LONG_DIVIDE_SIZE) {
            return d(tag, msg);
        }
        int start = 0;
        int end = LONG_DIVIDE_SIZE;
        while (end < length) {
            d(tag, msg.substring(start, end));
            start = end;
            end += LONG_DIVIDE_SIZE;
        }
        return d(tag, msg.substring(start));
    }

    public static StringBuilder buf() {
        SoftReference<StringBuilder> ref = sLogBuffer.get();
        StringBuilder sb = (ref == null) ? null : ref.get();
        if (sb == null) {
            sb = new StringBuilder(ThreadLocalStringBuilder.DEFAULT_CAPACITY_SIZE);
            sLogBuffer.set(new SoftReference<StringBuilder>(sb));
        } else {
            sb.setLength(0);
        }
        return sb;
    }
}
