package jp.sourceforge.nicoro;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;

public class ListMenuActivity extends FragmentActivity {
    public static final String INTENT_EXTRA_BOOKMARKS_ADD_URL = "BOOKMARKS_ADD_URL";
    public static final String INTENT_EXTRA_BOOKMARKS_ADD_TITLE = "BOOKMARKS_ADD_TITLE";
    public static final String INTENT_EXTRA_VIDEO_NUMBER = "VIDEO_NUMBER";
    public static final String INTENT_EXTRA_DEFAULT_LIST_RADIO = "DEFAULT_LIST_RADIO";

    private static final int MSG_ID_START_BROWSER = 1;

    private Context mContext;
    private MenuInflater mMenuInflater;

    private boolean mOnNewIntent;
    private boolean mResumed = false;

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case MSG_ID_START_BROWSER:
                    String url = (String) msg.obj;
                    MainFragmentActivity.startBrowserActivity(
                            ListMenuActivity.this, url);
//                    finish();
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        mContext = getApplicationContext();
        mMenuInflater = getMenuInflater();

        CallbackMessage<String, Void> browserStarter =
            new CallbackMessage<String, Void>(mHandler, MSG_ID_START_BROWSER);
        String tag = getString(R.string.tag_list_menu_fragment);
        ListMenuFragment fragment;
        if (savedInstanceState == null) {
            fragment = new ListMenuFragment();
            getSupportFragmentManager().beginTransaction().add(
                    android.R.id.content, fragment,
                    tag).commit();
            fragment.update(getIntent());
        } else {
            fragment = Util.findFragmentByTag(getSupportFragmentManager(),
                    tag);
        }
        fragment.setBrowserStarterCallback(browserStarter);

        mOnNewIntent = false;
    }

    @Override
    protected void onResume() {
        super.onResume();

        mResumed = true;

        // 表示直後のIntent処理はFragment側から行う

        if (mOnNewIntent) {
            Intent intent = getIntent();
            updateFragmentBookmarks(intent);
            updateFragmentRelatedVideo(intent);
            updateFragmentListMenu(intent);
            mOnNewIntent = false;
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        mResumed = false;
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        setIntent(intent);
        mOnNewIntent = true;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (MainFragmentActivity.isDualPane(newConfig)) {
            if (mResumed) {
                // TODO 表示中のリストメニュー項目をdual paneに引き継ぎたい
                MainFragmentActivity.startBrowserActivity(this, null);
            }
            finish();
        }
    }

    void updateFragmentBookmarks(Intent intent) {
        FragmentManager fragment = getSupportFragmentManager();
        BookmarksFragment bookmarks = Util.findFragmentByTag(fragment,
                getString(R.string.tag_bookmarks_fragment));
        ListMenuFragment.updateFragmentBookmarks(intent, bookmarks);
    }

    void updateFragmentRelatedVideo(Intent intent) {
        FragmentManager fragment = getSupportFragmentManager();
        RelatedVideoFragment relatedVideo = Util.findFragmentByTag(fragment,
                getString(R.string.tag_related_video_fragment));
        ListMenuFragment.updateFragmentRelatedVideo(intent, relatedVideo);
    }
    void updateFragmentListMenu(Intent intent) {
        FragmentManager fragment = getSupportFragmentManager();
        ListMenuFragment listMenu = Util.findFragmentByTag(fragment,
                getString(R.string.tag_list_menu_fragment));
        listMenu.update(intent);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        mMenuInflater.inflate(R.menu.list_menu_menu, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        Intent intent;
        switch (item.getItemId()) {
//            case R.id.menu_top:
//                mHandler.obtainMessage(MSG_ID_START_BROWSER,
//                        "http://www.nicovideo.jp/").sendToTarget();
//                return true;
            case R.id.menu_config:
                intent = new Intent(mContext, NicoroConfig.class);
                startActivity(intent);
                return true;
            case R.id.menu_help:
                intent = new Intent(mContext, NicoroHelp.class);
                startActivity(intent);
                return true;
            case R.id.menu_search:
                onSearchRequested();
                return true;
            case R.id.menu_exit:
                finish();
                return true;
            case R.id.menu_last_url:
                mHandler.obtainMessage(MSG_ID_START_BROWSER
                        ).sendToTarget();
                return true;
            default:
                assert false : item.getItemId();
                break;
        }
        return false;
    }
}
