package jp.sourceforge.nicoro;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.GridView;

public class DashBoardActivity extends Activity implements View.OnClickListener {

    static final int BUTTON_BROWSER = 0;
    static final int BUTTON_LIST_MENU = 1;
    static final int BUTTON_SEARCH = 2;
    static final int BUTTON_SETTINGS = 3;
//    static final int BUTTON_HELP = 4;

//    static final int BUTTON_SIZE = 5;
    static final int BUTTON_SIZE = 4;
    final String[] mButtonText = new String[BUTTON_SIZE];

    private Context mContext;

    private int mLastOrientation;

    private ViewGroup mDashBoard;
    private GridView mLauncher;
    private LauncherListAdapter mAdapter;
    // TODO WebViewはメモリ消費大きいか？
    private WebView mInfo;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        mContext = getApplicationContext();

        Resources res = getResources();
        mButtonText[BUTTON_BROWSER] = res.getString(
                R.string.dashboard_button_browser);
        mButtonText[BUTTON_LIST_MENU] = res.getString(
                R.string.dashboard_button_listmenu);
        mButtonText[BUTTON_SEARCH] = res.getString(
                R.string.dashboard_button_search);
        mButtonText[BUTTON_SETTINGS] = res.getString(
                R.string.dashboard_button_settings);
//        mButtonText[BUTTON_HELP] = "ヘルプ";

        Configuration config = getResources().getConfiguration();
        mLastOrientation = config.orientation;

        updateView();
        mLauncher.requestFocus();
    }

    @Override
    protected void onResume() {
        super.onResume();
        mInfo.resumeTimers();
        View v = mLauncher.getChildAt(0);
        if (v != null) {
            v.requestFocus();
        }
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (mLastOrientation != newConfig.orientation) {
            updateView();
            mLastOrientation = newConfig.orientation;
        }
    }

    private void updateView() {
        setContentView(R.layout.dash_board);
        mDashBoard = Util.findViewById(this, R.id.dash_board);
        mLauncher = Util.findViewById(mDashBoard, R.id.launcher);
        if (mAdapter == null) {
            mAdapter = new LauncherListAdapter();
        }
        mLauncher.setAdapter(mAdapter);
        mLauncher.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
                arg1.performClick();
            }
        });
        if (mInfo == null) {
            mInfo = Util.findViewById(mDashBoard, R.id.dash_board_info);
            NicoroHelp.loadHelp(mContext, mInfo);
        } else {
            Util.removeViewFromParent(mInfo);
            WebView target = Util.findViewById(mDashBoard, R.id.dash_board_info);
            Util.replaceView(target, mInfo);
            target.destroy();
        }
    }

    @Override
    public void onClick(View v) {
        Object tag = v.getTag();
        if (tag instanceof Integer) {
            int id = (Integer) tag;
            Intent intent;
            switch (id) {
                case BUTTON_BROWSER:
                    MainFragmentActivity.startBrowserActivity(this, null);
                    break;
                case BUTTON_LIST_MENU:
                    MainFragmentActivity.startListMenuActivity(this);
                    break;
                case BUTTON_SEARCH:
                    onSearchRequested();
                    break;
                case BUTTON_SETTINGS:
                    intent = new Intent(mContext, NicoroConfig.class);
                    startActivity(intent);
                    break;
//                case BUTTON_HELP:
//                    intent = new Intent(mContext, NicoroHelp.class);
//                    startActivity(intent);
//                    break;
                default:
                    assert false : id;
                    break;
            }
        } else {
            assert false : tag;
        }
    }

    private class LauncherListAdapter extends BaseAdapter {

        @Override
        public int getCount() {
            return BUTTON_SIZE;
        }

        @Override
        public Object getItem(int position) {
            return mButtonText[position];
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            Button view;
            if (convertView == null) {
                LayoutInflater inflater = getLayoutInflater();
                view = Util.inflate(inflater, R.layout.dash_board_button, parent, false);
                view.setOnClickListener(DashBoardActivity.this);
            } else {
                view = (Button) convertView;
            }
            view.setText(mButtonText[position]);
            view.setTag(Integer.valueOf(position));
            return view;
        }

    }
}
