package jp.sourceforge.nicoro;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.os.AsyncTask;
import android.os.Bundle;
import android.provider.Browser;
import android.support.v4.app.ListFragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static jp.sourceforge.nicoro.Log.LOG_TAG;
import jp.sourceforge.nicoro.StaticRes.string;

public class BookmarksFragment extends ListFragment
implements WebBrowserFragmentStarter {

    private static final String KEY_URL = "url";
    private static final String KEY_TITLE = "title";

    private static final String KEY_LAST_SELECTION = "LastSelection";

    private Context mContext;

    private ArrayList<HashMap<String, Object>> mBookmarkList;

    private String mAddBookmarkUrl = "";
    private String mAddBookmarkTitle = "";

    private View mAddBookmarkHeaderView;
    private TextView mAddBookmarkUrlView;
    private Button mAddBookmarkButtonView;

    private ListEmptyProgressManager mEmptyProgress;

    private int mLastSelection = -1;

    private CallbackMessage<String, Void> mBrowserStarter;

    private StateManager mStateManager = new StateManager();

    private class CreateBookmarkListTask extends AsyncTask<ArrayList<HashMap<String, Object>>, Void, ArrayList<HashMap<String, Object>>> {
        @Override
        protected ArrayList<HashMap<String, Object>> doInBackground(
                ArrayList<HashMap<String, Object>>... params) {
            ArrayList<HashMap<String, Object>> bookmarkList = params[0];

            ContentResolver cr = mContext.getContentResolver();
            Cursor c = cr.query(Browser.BOOKMARKS_URI,
                    new String[] {
                        Browser.BookmarkColumns.URL,
                        Browser.BookmarkColumns.TITLE },
                    "bookmark = 1", null, null);
            if (c == null) {
                // rootedでブラウザ削除していると見つからない場合も
                Log.w(LOG_TAG, "BOOKMARKS_URI are not found.");
                if (bookmarkList == null) {
                    bookmarkList = new ArrayList<HashMap<String, Object>>();
                }
                return bookmarkList;
            }
            try {
                if (bookmarkList == null) {
                    bookmarkList = new ArrayList<HashMap<String, Object>>(c.getCount() + 1);
                } else {
                    bookmarkList.clear();
                }

                if (c.moveToFirst()) {
                    Matcher matcher = Pattern.compile(
                            NicoroAPIManager.PATTERN_NICOVIDEO_URL).matcher("");
                    do {
                        final int indexUrl = c.getColumnIndex(
                                Browser.BookmarkColumns.URL);
                        final String url = c.getString(indexUrl);
                        // XXX urlが空の場合がある？
                        if (url != null) {
                            matcher.reset(url);
                            if (matcher.find()) {
                                final int indexTitle = c.getColumnIndex(
                                        Browser.BookmarkColumns.TITLE);
                                final String title = c.getString(indexTitle);

                                HashMap<String, Object> bookmark = Util.newHashMap(2);
                                bookmark.put(KEY_URL, url);
                                bookmark.put(KEY_TITLE, title);
                                bookmarkList.add(bookmark);
                            }
                        }
                    } while (c.moveToNext());
                }

                bookmarkList.trimToSize();
            } finally {
                c.close();
            }
            return bookmarkList;
        }

        @Override
        protected void onPostExecute(ArrayList<HashMap<String, Object>> result) {
            assert result != null;
            if (mCreateBookmarkListTask == this) {
                // 後から別のTaskが起動していない→表示に反映
                mBookmarkList = result;
                if (!mStateManager.wasDestroyed()) {
                    setListAdapter(createAdapter());

                    if (mLastSelection >= 0 && mLastSelection < result.size()) {
                        getListView().setSelection(mLastSelection);
                    }
                    mLastSelection = -1;
                }

                mEmptyProgress.showEmptyText();
                mCreateBookmarkListTask = null;
            }
        }
    }
    private CreateBookmarkListTask mCreateBookmarkListTask;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        mStateManager.onCreate(savedInstanceState);

        mContext = getActivity().getApplicationContext();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.bookmarks_list, container, false);
        mEmptyProgress = new ListEmptyProgressManager(v);
        return v;
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        ListView listView = getListView();
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view,
                    int position, long id) {
                if (mBrowserStarter != null) {
                    ListView listView = (ListView) parent;
                    ListAdapter adapter = listView.getAdapter();
                    @SuppressWarnings("unchecked")
                    HashMap<String, Object> bookmark =
                        (HashMap<String, Object>) adapter.getItem(position);

                    mBrowserStarter.sendMessageSuccess((String) bookmark.get(KEY_URL));
                }
            }
        });

        if (savedInstanceState != null) {
            int lastSelection = savedInstanceState.getInt(KEY_LAST_SELECTION, -1);
            if (lastSelection >= 0) {
                mLastSelection = lastSelection;
            }
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        mStateManager.onStart();
    }

    @SuppressWarnings("unchecked")
    @Override
    public void onResume() {
        super.onResume();
        mStateManager.onResume();

        // 前回のTaskがまだ動作中かもしれないがメンバ上書きして実行
        setListAdapter(null);
        mCreateBookmarkListTask = new CreateBookmarkListTask();
        mCreateBookmarkListTask.execute(mBookmarkList);

        mEmptyProgress.showEmptyProgress();

        // ブックマーク表示のタイミングでもブラウザから情報取得
        updateAddBookmarkByBrowser();

        // HeaderViewではリストが空の時に表示されなくなってしまう
        if (mAddBookmarkHeaderView == null) {
//            LayoutInflater inflater = getActivity().getLayoutInflater();
//            mAddBookmarkHeaderView = inflater.inflate(R.layout.bookmarks_add, null, true);
//            getListView().addHeaderView(mAddBookmarkHeaderView);
            mAddBookmarkHeaderView = Util.findViewById(getActivity(), R.id.bookmarks_add);
            mAddBookmarkButtonView = Util.findViewById(mAddBookmarkHeaderView,
                    android.R.id.text1);
            mAddBookmarkUrlView = Util.findViewById(mAddBookmarkHeaderView,
                    android.R.id.text2);
            mAddBookmarkButtonView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (!TextUtils.isEmpty(mAddBookmarkUrl)) {
                        BookmarksFragment.addBookmark(getActivity(),
                                mAddBookmarkTitle, mAddBookmarkUrl);
                    }
                }
            });
        }
        mAddBookmarkUrlView.setText(mAddBookmarkUrl);
    }

    @Override
    public void onPause() {
        super.onPause();
        mStateManager.onPause();
        ListView listView = getListView();
//        int selected = listView.getSelectedItemPosition();
        int selected = listView.getFirstVisiblePosition();
        if (selected >= 0) {
            mLastSelection = selected;
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        mStateManager.onStop();
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        mStateManager.onSaveInstanceState();
        ListView listView = getListView();
//        int selected = listView.getSelectedItemPosition();
        int selected = listView.getFirstVisiblePosition();
        if (selected >= 0) {
            outState.putInt(KEY_LAST_SELECTION, selected);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        mStateManager.onDestroy();
    }

    public void updateAddBookmarkByBrowser() {
        WebBrowserFragment webBrowser = Util.findFragmentByTag(
                getFragmentManager(), string.tag_webbrowser_fragment);
        if (webBrowser != null) {
            String title = webBrowser.getWebTitle();
            String url = webBrowser.getWebUrl();
            if (!TextUtils.isEmpty(title) && !TextUtils.isEmpty(url)) {
                setAddBookmark(url, title);
            }
        }
    }

    @Override
    public void onHiddenChanged(boolean hidden) {
        if (!hidden) {
            // ブックマーク表示のタイミングでもブラウザから情報取得
            updateAddBookmarkByBrowser();
        }
    }

    ListAdapter createAdapter() {
        SimpleAdapter adapter = new SimpleAdapter(
                mContext,
                mBookmarkList,
                R.layout.bookmarks,
                new String []{KEY_TITLE, KEY_URL},
                new int []{android.R.id.text1, android.R.id.text2}
                );
        return adapter;
    }

    public void setAddBookmark(String url, String title) {
        mAddBookmarkUrl = url;
        mAddBookmarkTitle = title;

        if (mAddBookmarkUrlView != null) {
            mAddBookmarkUrlView.setText(mAddBookmarkUrl);
        }
    }

    @Override
    public void setBrowserStarterCallback(CallbackMessage<String, Void> callback) {
        mBrowserStarter = callback;
    }

    public static void addBookmark(Activity activity, String title, String url) {
        Matcher matcher = Pattern.compile(NicoroAPIManager.PATTERN_NICOVIDEO_URL).matcher(url);
        if (matcher.find()) {
            Browser.saveBookmark(activity, title, url);
        } else {
            Util.showErrorToast(activity.getApplicationContext(),
                    R.string.toast_bookmark_url_not_nicovideo);
        }
    }
}
