package jp.sourceforge.nicoro;

//import java.util.Calendar;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import static jp.sourceforge.nicoro.Log.LOG_TAG;
import jp.sourceforge.nicoro.R;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.preference.PreferenceManager;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;

public abstract class AbstractNicoroPlayer extends Activity implements ViewTreeObserver.OnGlobalLayoutListener,
PlayerInfoViews.PlayDataAppender, PlayerInfoViews.TimeAppender, DestroyTask.Callback {
	private static final boolean DEBUG_LOGV = Release.IS_DEBUG & true;
	private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;

	public static final String INTENT_NAME_VIDEO_URL = "VIDEO_URL";
	public static final String INTENT_NAME_COOKIE = "COOKIE";
	public static final String INTENT_NAME_VIDEO_NUMBER = "VIDEO_NUMBER";
	public static final String INTENT_NAME_MESSAGE_URL = "MESSAGE_URL";
	public static final String INTENT_NAME_THREAD_ID = "THREAD_ID";
	public static final String INTENT_NAME_USER_ID = "USER_ID";
	public static final String INTENT_NAME_THREAD_KEY = "THREAD_KEY";
	public static final String INTENT_NAME_FORCE_184 = "FORCE_184";
	public static final String INTENT_NAME_COOKIE_USER_SESSION = "COOKIE_USER_SESSION";
	public static final String INTENT_NAME_FORCE_LOW = "FORCE_LOW";

	/** コメント取得完了 */
	protected static final int MSG_ID_MESSAGE_FINISHED = 0;
	/** コメント取得エラー */
	protected static final int MSG_ID_MESSAGE_OCCURRED_ERROR = 1;
	/** 動画情報（getthumbinfo）取得完了 */
	protected static final int MSG_ID_THUMBINFO_FINISHED = 2;
    /** 動画情報（getthumbinfo）取得エラー */
	protected static final int MSG_ID_THUMBINFO_OCCURRED_ERROR = 3;
    /** 動画ファイル取得エラー */
	protected static final int MSG_ID_VIDEO_OCCURRED_ERROR = 4;
	/** 動画ファイル取得進行状況通知 */
	protected static final int MSG_ID_VIDEO_NOTIFY_PROGRESS = 5;
	/** 動画の再生時間表示を更新 */
	protected static final int MSG_ID_INFO_TIME_UPDATE = 6;
	/** 動画再生中にエラー */
	protected static final int MSG_ID_PLAY_ERROR = 7;
    /** 投稿者コメント取得完了 */
	protected static final int MSG_ID_MESSAGE_FORK_FINISHED = 8;
    /** 投稿者コメント取得エラー */
	protected static final int MSG_ID_MESSAGE_FORK_OCCURRED_ERROR = 9;
	/** SeekBarを有効化 */
	protected static final int MSG_ID_ENABLE_SEEK_BAR = 10;
//	protected static final int MSG_ID_INFO_CLOCK_UPDATE = 11;
	/** 動画の再生情報表示を更新 */
	protected static final int MSG_ID_INFO_PLAY_DATA_UPDATE = 12;
    /** 動画情報（getthumbinfo）をネットワークから新規に取得完了 */
	protected static final int MSG_ID_THUMBINFO_FINISHED_NEW = 13;
    /** 動画情報（getthumbinfo）をネットワークから新規に取得でエラー */
	protected static final int MSG_ID_THUMBINFO_OCCURRED_ERROR_NEW = 14;
	/** 動画を最後まで再生完了 */
    protected static final int MSG_ID_PLAY_FINISHED = 15;
    /** 動画再生完了時のダイアログを表示 */
    protected static final int MSG_ID_PLAY_FINISHED_DIALOG = 16;
    /** Playerをタイマーで自動終了 */
    protected static final int MSG_ID_AUTO_CLOSE = 17;
    /** 動画ファイル取得完了 */
    protected static final int MSG_ID_VIDEO_DOWNLOAD_FINISHED = 18;
    /** 動画ファイルの一定以上のキャッシュ完了 */
    protected static final int MSG_ID_VIDEO_CACHED = 19;
    /** 動画ファイル取得開始 */
    protected static final int MSG_ID_VIDEO_DOWNLOAD_STARTED = 20;
    /** サブクラスで追加定義するイベントIDのオフセット */
	protected static final int MSG_ID_SUB_OFFSET = 0x100;

	public static final int REAL_PLAYER_WIDTH_PX_4_3 = 512;
	public static final int REAL_PLAYER_HEIGHT_PX_4_3 = 384;
//	public static final int REAL_PLAYER_HEIGHT_PX_16_9 = 288;
	public static final int REAL_PLAYER_WIDTH_PX_15_9 = 640;
	public static final int REAL_PLAYER_WIDTH_PX_16_9 = 684; // 682.66

	public static final int NOTIFICATION_ID_RUNNING_PLAYER = -1;

	protected static final String INFO_TIME_DEFAULT = "000:00";

	private static final long INTERVAL_TIME_UPDATE = 100L;

	private static final String KEY_SAVE_CURRENT_PLAY_TIME = "KEY_SAVE_CURRENT_PLAY_TIME";
	private static final String KEY_SAVE_IS_PAUSE_PLAY = "KEY_SAVE_IS_PAUSE_PLAY";

    private static final String WAKELOCK_TAG_SUFFIX = "WakeLock";

	protected VideoLoader mVideoLoader;
	protected MessageLoader mMessageLoader;
	protected MessageLoaderFork mMessageLoaderFork;
    protected RelativeLayout mParentScreen;

    protected PlayerProgressViews mProgressViews = new PlayerProgressViews();

	protected PlayerInfoViews mInfoViews = new PlayerInfoViews();

	protected PlayerControllerViews mPlayerControllerViews = new PlayerControllerViews();

	protected ThumbInfo mThumbInfo;

	private PlayerInfoControllerManager mPlayerInfoControllerManager;

	private AlertDialog mPlayFinishDialog;
	protected AlertDialog mErrorDialog;

	protected MessageData mMessageData = new MessageData();
	protected MessageData mMessageDataFork = new MessageData();

    protected Rational mRatinalCurrentPlayTime = new Rational();

    protected volatile MessageHandler mHandler;

//    protected Matrix mMatrixMessage = new Matrix();
//    protected Random mRandom = new Random();
//    protected Paint mPaintText = new Paint();
    protected boolean mMessageDisable;

    protected MessageChatController mMessageChatController = new MessageChatController();

    protected SharedPreferences mSharedPreferences;

//    private Calendar mClock = Calendar.getInstance();

    protected StateManager mStateManager = new StateManager();
//    private boolean mFromOnPause;
	protected boolean mDidStartPlay = false;

    private Rational mSaveStateCurrentPlayTime;
    private boolean mSaveIsPausePlay;
    protected boolean mIsThumbInfoOk;
    protected boolean mIsVideoDownloadOk;
    protected boolean mIsVideoCachedOk;

    protected boolean mShowHintToast;

    protected int mLastOrientation;

    private PowerManager.WakeLock mWakeLock;

    private PhoneStateListener mPhoneStateListener;

    protected Context mContext;

    protected abstract class MessageHandler extends Handler {
		@Override
		public void handleMessage(Message msg) {
			if (mHandler == null) {
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, Log.buf().append("Activity was destroyed. ignore message=")
							.append(msg.toString()).toString());
				}
				return;
			}
			switch (msg.what) {
			case MSG_ID_MESSAGE_FINISHED:
			    mProgressViews.setTextMessageFinished();
			    mMessageData.setChats(mMessageLoader.getChats());
				if (canStartPlay()) {
					startPlay();
				}
				break;
			case MSG_ID_MESSAGE_OCCURRED_ERROR:
                mProgressViews.setTextMessageError();
				showErrorDialog((String) msg.obj);
				break;
			case MSG_ID_THUMBINFO_FINISHED:
			    mProgressViews.setTextThumbinfoFinished();
				mMessageLoader.setVideoLength((String) msg.obj);
				mMessageLoader.startLoad();
				mMessageLoaderFork.setVideoLength((String) msg.obj);
				mMessageLoaderFork.startLoad();

				mInfoViews.setTitle(mThumbInfo.getTitle());
				mInfoViews.setDescription(mThumbInfo.getDescription());
				mPlayerControllerViews.setSeekBarMax(mThumbInfo.getLengthBySecond());
                mIsThumbInfoOk = true;

                if (mIsVideoDownloadOk) {
                    mPlayerControllerViews.setSeekBarSecondaryMax();
                }
				break;
			case MSG_ID_THUMBINFO_OCCURRED_ERROR:
			    mProgressViews.setTextThumbinfoError();
                showErrorDialog((String) msg.obj);
				break;
			case MSG_ID_VIDEO_OCCURRED_ERROR:
			    mProgressViews.setTextVideoError();
                showErrorDialog((String) msg.obj);
				break;
			case MSG_ID_VIDEO_NOTIFY_PROGRESS:
                mProgressViews.setTextVideoNotifyProgress(
                        msg.arg1, msg.arg2);
                mPlayerControllerViews.setSeekBarSecondaryProgress(msg.arg1, msg.arg2);
				break;
			case MSG_ID_INFO_TIME_UPDATE:
				if (!mStateManager.wasDestroyed()) {
				    StringBuilder infoTimeData =
				        mInfoViews.setTime(AbstractNicoroPlayer.this);

				    mPlayerControllerViews.setTime(infoTimeData.toString());

					mPlayerControllerViews.setSeekBarMax(mThumbInfo.getLengthBySecond());
					if (mPlayerControllerViews.canUpdateSeekBarProgress()) {
						// TODO: 二重呼び出しでちょっと無駄
						getCurrentPositionVideoPlay(mRatinalCurrentPlayTime);
						mPlayerControllerViews.setSeekBarProgress(
						        (int) (mRatinalCurrentPlayTime.num / mRatinalCurrentPlayTime.den));
					}

					// 繰り返し
					mHandler.sendEmptyMessageDelayed(
							MSG_ID_INFO_TIME_UPDATE, INTERVAL_TIME_UPDATE);
				}
				break;
			case MSG_ID_PLAY_ERROR:
                showErrorDialog((String) msg.obj);
				break;
			case MSG_ID_MESSAGE_FORK_FINISHED:
			    mProgressViews.setTextMessageForkFinished();
			    mMessageDataFork.setChats(mMessageLoaderFork.getChats());
				if (canStartPlay()) {
					startPlay();
				}
				break;
			case MSG_ID_MESSAGE_FORK_OCCURRED_ERROR:
			    mProgressViews.setTextMessageForkError();
				// TODO 投稿者コメントのエラーはとりあえず無視？
				Log.w(LOG_TAG, Log.buf().append("fork=\"1\" message load failed:")
						.append((String) msg.obj).toString());
                // ぬるぽ出るのでメンバも設定
				mMessageDataFork.setChats(null);
				break;
			case MSG_ID_ENABLE_SEEK_BAR:
				mPlayerControllerViews.setEnabledSeekController(true);
				break;
//			case MSG_ID_INFO_CLOCK_UPDATE:
//				StringBuilder infoClockData = mInfoClock.getTextBuilder();
//				// TODO 微妙に処理無駄
//				infoClockData.delete(0, infoClockData.length());
////				infoClockData.append(getString(R.string.info_clock));
//				infoClockData.append("[ ");
//				mClock.setTimeInMillis(System.currentTimeMillis());
//				final int hour = mClock.get(Calendar.HOUR);
//				final int minute = mClock.get(Calendar.MINUTE);
//				final int second = mClock.get(Calendar.SECOND);
//				if (hour < 10) {
//					infoClockData.append('0');
//				}
//				infoClockData.append(hour).append(':');
//				if (minute < 10) {
//					infoClockData.append('0');
//				}
//				infoClockData.append(minute).append(':');
//				if (second < 10) {
//					infoClockData.append('0');
//				}
//				infoClockData.append(second);
//				infoClockData.append(" ]");
//				mInfoClock.notifyUpdateText();
//
//				// 繰り返し
//				{
//					long now = SystemClock.uptimeMillis();
//					long next = now + (1000 - now % 1000);
//					mHandler.sendEmptyMessageAtTime(
//							MSG_ID_INFO_CLOCK_UPDATE, next);
//				}
//				break;
			case MSG_ID_INFO_PLAY_DATA_UPDATE:
			    mInfoViews.setPlayData(AbstractNicoroPlayer.this);
				break;
			case MSG_ID_THUMBINFO_FINISHED_NEW:
				mThumbInfo = (ThumbInfo) msg.obj;
				mHandler.obtainMessage(MSG_ID_THUMBINFO_FINISHED,
						mThumbInfo.getLength()).sendToTarget();
				break;
			case MSG_ID_THUMBINFO_OCCURRED_ERROR_NEW:
				String errorMessage = (String) msg.obj;
				mHandler.obtainMessage(MSG_ID_THUMBINFO_OCCURRED_ERROR,
						errorMessage).sendToTarget();
				break;
			case MSG_ID_PLAY_FINISHED:
			    // ダイアログ表示は少し遅らせる
			    mHandler.sendEmptyMessageDelayed(MSG_ID_PLAY_FINISHED_DIALOG,
			            1000);
			    break;
		    case MSG_ID_PLAY_FINISHED_DIALOG: {
	            DialogInterface.OnCancelListener onCancelListener =
	                new DialogInterface.OnCancelListener() {
	                @Override
	                public void onCancel(DialogInterface dialog) {
	                    dialog.dismiss();
	                    mPlayFinishDialog = null;
	                }
	            };
	            View.OnClickListener onClickListener = new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (mPlayFinishDialog != null) {
                            mPlayFinishDialog.dismiss();
                            mPlayFinishDialog = null;
                        }
                        Handler handler = mHandler;
                        if (handler != null) {
                            handler.removeMessages(MSG_ID_AUTO_CLOSE);
                        }
                        switch (v.getId()) {
                            case R.id.button_quit:
                                finish();
                                break;
                            case R.id.button_replay:
                                // いったんシークバー他無効化
                                mPlayerControllerViews.setEnabledSeekController(false);
                                mPlayerControllerViews.setSeekBarProgress(0);
                                seekBySecond(0);
                                restartPlay();
                                break;
                            case R.id.button_dialog_close:
                                break;
                            default:
                                assert false : v.getId();
                                break;
                        }
                    }
                };
			    Activity activity = AbstractNicoroPlayer.this;
	            LayoutInflater inflater = Util.getInflaterForDialogDark(activity);
	            // LayoutParams生成のためダミーのViewも使用
	            View playFinish = inflater.inflate(
	                    R.layout.play_finish_dialog,
	                    new FrameLayout(activity), false);
	            playFinish.findViewById(R.id.button_quit).setOnClickListener(onClickListener);
                playFinish.findViewById(R.id.button_replay).setOnClickListener(onClickListener);
                playFinish.findViewById(R.id.button_dialog_close).setOnClickListener(onClickListener);
	            mPlayFinishDialog = new AlertDialog.Builder(activity)
	                .setTitle(R.string.dialog_title_player_finish)
                    .setView(playFinish)
                    .setCancelable(true)
                    .setOnCancelListener(onCancelListener)
                    .show();
                mHandler.removeMessages(MSG_ID_AUTO_CLOSE);
	            mHandler.sendEmptyMessageDelayed(MSG_ID_AUTO_CLOSE, 30000);
			} break;
			case MSG_ID_AUTO_CLOSE:
			    finish();
			    break;
            case MSG_ID_VIDEO_DOWNLOAD_FINISHED:
                mProgressViews.setTextVideoDownloadFinished();
                if (mIsThumbInfoOk) {
                    mPlayerControllerViews.setSeekBarSecondaryMax();
                }
                mIsVideoDownloadOk = true;
                break;
			default:
				assert false : msg.what;
				break;
			}
		}
    }

    /**
     * すべての再生準備が整ったか確認する（動画ファイルのダウンロード、コメントファイルのダウンロード等）
     * @return
     */
	protected abstract boolean canStartPlay();

	/**
	 * 動画の再生位置を取得する
	 * @param rational 位置情報（秒単位の分数）
	 */
	protected abstract void getCurrentPositionVideoPlay(Rational rational);
	/**
	 * 音声の再生位置を取得する
	 * @param rational 位置情報（秒単位の分数）
	 */
	protected abstract void getCurrentPositionAudioPlay(Rational rational);
	/**
	 * 動画のデコード位置を取得する
	 * @param rational 位置情報（秒単位の分数）
	 */
	protected abstract void getCurrentPositionVideoDecode(Rational rational);
	/**
	 * 音声のデコード位置を取得する
	 * @param rational 位置情報（秒単位の分数）
	 */
	protected abstract void getCurrentPositionAudioDecode(Rational rational);

	/**
	 * 再生状態と一時停止状態を切り替える
	 * @return 成否
	 */
	protected abstract boolean switchPausePlay();
	/**
	 * 再生を一時停止する
	 */
	protected abstract void pausePlay();
	/**
	 * 一時停止していた再生を再開する
	 */
	protected abstract void restartPlay();
	/**
	 * 再生が一時停止中か確認する
	 * @return
	 */
	protected abstract boolean isPausePlay();

	/**
	 * 秒単位でシークする
	 * @param second
	 */
	protected abstract void seekBySecond(int second);

	@Override
	public StringBuilder appendMovieType(StringBuilder builder) {
        if (mVideoLoader.isLow()) {
            builder.append("low-")
                .append(mVideoLoader.getMovieType());
        } else {
            builder.append(mThumbInfo.getMovieType());
        }
	    return builder;
	}

	@Override
	public StringBuilder appendTotalPlayTime(StringBuilder builder) {
	    return builder.append(mThumbInfo.getFormattedLengthForPlayer());
	}

	protected void startPlay() {
	    startWakeLock();

	    mProgressViews.setVisibilityGone();
    	if (!mPlayerInfoControllerManager.isPlayerInfoShown()) {
    	    mPlayerInfoControllerManager.showPlayerInfo();
    	}

		mHandler.sendEmptyMessage(MSG_ID_INFO_TIME_UPDATE);

//		mHandler.sendEmptyMessage(MSG_ID_INFO_CLOCK_UPDATE);

		mInfoViews.setCountPlay(mThumbInfo.getViewCounter());
		mInfoViews.setCountComment(mThumbInfo.getCommentNum());
		mInfoViews.setCountMylist(mThumbInfo.getMylistCounter());

		mMessageChatController.setDuration(mThumbInfo.getLengthByVpos());

		mDidStartPlay = true;
	}

	protected void postStartPlayIfIsRestored() {
    	if (mStateManager.wasRestored()) {
    		// 再開時は一時停止にしておく
			pausePlay();
			setButtonPauseImage();
//			if (mSaveIsPausePlay) {
    			// 再開できるようにコントローラ表示
			    mPlayerInfoControllerManager.showPlayerController();
//			}
        	if (mSaveStateCurrentPlayTime != null) {
				int second = (int) (mSaveStateCurrentPlayTime.num / mSaveStateCurrentPlayTime.den);
				if (second != 0) {	// 0のときはシーク不要
					// いったんシークバー他無効化
				    mPlayerControllerViews.setEnabledSeekController(false);
	        		mPlayerControllerViews.setSeekBarMax(mThumbInfo.getLengthBySecond());
	        		mPlayerControllerViews.setSeekBarProgress(second);
		    		seekBySecond(second);
				}
        	}
    	}
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		if (DEBUG_LOGV) {
			Log.v(LOG_TAG, Log.buf().append(getClass().getName())
					.append("#onCreate: savedInstanceState=")
					.append(savedInstanceState).toString());
		}
		super.onCreate(savedInstanceState);
        mStateManager.onCreate(savedInstanceState);

        mContext = getApplicationContext();

		if (savedInstanceState == null) {
		} else {
			mSaveStateCurrentPlayTime = savedInstanceState.getParcelable(
					KEY_SAVE_CURRENT_PLAY_TIME);
			mSaveIsPausePlay = savedInstanceState.getBoolean(
					KEY_SAVE_IS_PAUSE_PLAY);
		}

//		mFromOnPause = false;
        mDidStartPlay = false;
        mIsThumbInfoOk = false;
        mIsVideoDownloadOk = false;
        mIsVideoCachedOk = false;

		mMessageData.clear();
		mMessageDataFork.clear();

        mSharedPreferences = PreferenceManager.getDefaultSharedPreferences(
                mContext);
        boolean playerLandscapeOnly = mSharedPreferences.getBoolean(
                getString(R.string.pref_key_player_landscape_only), false);
        if (playerLandscapeOnly) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        }

        Intent intent = getIntent();

//        mThumbInfo = createThumbInfo(intent);
//        if (mThumbInfo != null) {
//        	mThumbInfo.setEventListener(new ThumbInfo.EventListener() {
//				@Override
//				public void onFinished(ThumbInfo thumbInfo) {
//					if (mHandler != null) {
//						mHandler.obtainMessage(MSG_ID_THUMBINFO_FINISHED,
//								thumbInfo.getLength()).sendToTarget();
//					}
//				}
//				@Override
//				public void onOccurredError(ThumbInfo thumbInfo,
//						String errorMessage) {
//					if (mHandler != null) {
//						mHandler.obtainMessage(MSG_ID_THUMBINFO_OCCURRED_ERROR,
//								errorMessage).sendToTarget();
//					}
//				}
//        	});
//        	mThumbInfo.startLoad();
//        }
        getThumbInfo(intent);

		String userSession = mSharedPreferences.getString(NicoroConfig.COOKIE_USER_SESSION, null);
        mMessageLoader = createMessageLoader(intent, mContext, userSession);
        if (mMessageLoader != null) {
        	mMessageLoader.setEventListener(new MessageLoader.EventListener() {
				@Override
				public void onFinished(MessageLoader messageLoader) {
			        Handler handler = mHandler;
					if (handler != null) {
						handler.sendEmptyMessage(MSG_ID_MESSAGE_FINISHED);
					}
				}
				@Override
				public void onOccurredError(MessageLoader messageLoader,
						String errorMessage) {
			        Handler handler = mHandler;
					if (handler != null) {
						handler.obtainMessage(MSG_ID_MESSAGE_OCCURRED_ERROR,
								errorMessage).sendToTarget();
					}
				}
        	});
//        	mMessageLoader.startLoad();
        }
        mMessageLoaderFork = createMessageLoaderFork(intent, mContext, userSession);
        if (mMessageLoaderFork != null) {
        	mMessageLoaderFork.setEventListener(new MessageLoader.EventListener() {
				@Override
				public void onFinished(MessageLoader messageLoader) {
			        Handler handler = mHandler;
					if (handler != null) {
						handler.sendEmptyMessage(MSG_ID_MESSAGE_FORK_FINISHED);
					}
				}
				@Override
				public void onOccurredError(MessageLoader messageLoader,
						String errorMessage) {
//					// TODO 投稿者コメントのエラーはとりあえず無視？
//					Log.w(LOG_TAG, Log.buf().append("fork=\"1\" message load failed:")
//							.append(errorMessage).toString());
//					mMessageDataFork.mIsMessageOk = true;
			        Handler handler = mHandler;
					if (handler != null) {
						handler.obtainMessage(MSG_ID_MESSAGE_FORK_OCCURRED_ERROR,
								errorMessage).sendToTarget();
					}
				}
        	});
        }

        boolean messageAntialias = mSharedPreferences.getBoolean(
				getString(R.string.pref_key_message_antialias), false);
        mMessageChatController.setAntiAlias(messageAntialias);
//        mPaintText.setAntiAlias(messageAntialias);

        mMessageDisable = mSharedPreferences.getBoolean(
				getString(R.string.pref_key_message_disable), false);

        mShowHintToast = mSharedPreferences.getBoolean(
				getString(R.string.pref_key_show_hint_toast), true);
		if (mShowHintToast) {
			Util.showInfoToast(mContext,
					R.string.toast_explain_player_ctrl);
		}

        Configuration config = getResources().getConfiguration();
        mLastOrientation = config.orientation;

        PowerManager powerManager = (PowerManager) getSystemService(POWER_SERVICE);
        mWakeLock = powerManager.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK,
                getClass().getSimpleName() + WAKELOCK_TAG_SUFFIX);
        mWakeLock.setReferenceCounted(false);

        TelephonyManager telephonyManager = (TelephonyManager) getSystemService(
                TELEPHONY_SERVICE);
        if (telephonyManager != null) {
            mPhoneStateListener = new PhoneStateListener() {
                private boolean pauseOnCall = false;

                @Override
                public void onCallStateChanged(int state, String incomingNumber) {
                    // XXX 再生開始前に電話がかかってきた場合の状態管理が危うい
                    switch (state) {
                        case TelephonyManager.CALL_STATE_IDLE:
                            if (pauseOnCall) {
                                restartPlay();
                                setButtonPauseImage();
                                pauseOnCall = false;
                            }
                            break;
                        case TelephonyManager.CALL_STATE_RINGING:
                        case TelephonyManager.CALL_STATE_OFFHOOK:
                            // 電話かかってきたら一時停止
                            if (!isPausePlay()) {
                                pausePlay();
                                setButtonPauseImage();
                                pauseOnCall = true;
                            }
                            break;
                    }

                    super.onCallStateChanged(state, incomingNumber);
                }
            };
            telephonyManager.listen(mPhoneStateListener,
                    PhoneStateListener.LISTEN_CALL_STATE);
        }
	}

    @Override
    protected void onRestart() {
        super.onRestart();
        mStateManager.onRestart();
    }

    @Override
    protected void onStart() {
        super.onStart();
        mStateManager.onStart();
        if (!mStateManager.wasRestarted()) {
        }
    }

	@Override
	protected void onResume() {
		if (DEBUG_LOGV) {
			Log.v(LOG_TAG, Log.buf().append(getClass().getName())
					.append("#onResume").toString());
		}
		super.onResume();
		mStateManager.onResume();
//		if (mFromOnPause) {
//            if (canStartPlay()) {
//                // 再開できるようにコントローラ表示
//                mPlayerInfoControllerManager.showPlayerController();
//            }

//		    mFromOnPause = false;
//		} else {
//    		if (canStartPlay()) {
//    	        startPlay();
//    		}
//		}
		if (canStartPlay() && !mDidStartPlay) {
		    startPlay();
		}
	}

	private void savePlayState() {
        if (mDidStartPlay) {
            if (mSaveStateCurrentPlayTime == null) {
                mSaveStateCurrentPlayTime = new Rational();
            }
            getCurrentPositionVideoPlay(mSaveStateCurrentPlayTime);
            mSaveIsPausePlay = isPausePlay();
        }
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		if (DEBUG_LOGV) {
			Log.v(LOG_TAG, Log.buf().append(getClass().getName())
					.append("#onSaveInstanceState: outState=")
					.append(outState).toString());
		}
		super.onSaveInstanceState(outState);
		mStateManager.onSaveInstanceState();

		savePlayState();
		outState.putParcelable(KEY_SAVE_CURRENT_PLAY_TIME, mSaveStateCurrentPlayTime);
		outState.putBoolean(KEY_SAVE_IS_PAUSE_PLAY, mSaveIsPausePlay);
	}

	@Override
	protected void onPause() {
		if (DEBUG_LOGV) {
			Log.v(LOG_TAG, Log.buf().append(getClass().getName())
					.append("#onPause").toString());
		}
		super.onPause();
		mStateManager.onPause();
//		mFromOnPause = true;
//		// TODO とりあえず必ず一時停止
//		pausePlay();
//        setButtonPauseImage();
	}

    @Override
    protected void onStop() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onStop").toString());
        }
        super.onStop();
        mStateManager.onStop();
    }

	private class AsyncDestroyTask extends DestroyTask {
        private ProgressDialog progressDialog;

        AsyncDestroyTask() {
            super(AbstractNicoroPlayer.this);
        }

        @Override
        protected void onPreExecuteImpl() {
            if (!mStateManager.wasDestroyed()) {
                ProgressDialog pd = Util.createProgressDialogLoading(
                        AbstractNicoroPlayer.this,
                        R.string.progress_finish, null);
                pd.show();
                progressDialog = pd;
            }
        }
        @Override
        protected void onPostExecuteImpl() {
            closeProgressDialog();
        }

        @Override
        protected void timeoutImpl() {
            closeProgressDialog();
        }

        public void closeProgressDialog() {
            ProgressDialog pd = progressDialog;
            progressDialog = null;
            if (pd != null) {
                pd.dismiss();
            }
        }
	}
	private AsyncDestroyTask mDestroyTask = new AsyncDestroyTask();

	@Override
	public void finish() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#finish").toString());
        }

        if (mPlayFinishDialog != null) {
            mPlayFinishDialog.dismiss();
            mPlayFinishDialog = null;
        }
        if (mErrorDialog != null) {
            mErrorDialog.dismiss();
            mErrorDialog = null;
        }

        mDestroyTask.finishActivity();
	}

	@Override
	public void finishReally() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#finishReally").toString());
        }

	    if (!mStateManager.wasDestroyed()) {
	        super.finish();
	    }
	}

	@Override
	protected void onDestroy() {
		if (DEBUG_LOGV) {
			Log.v(LOG_TAG, Log.buf().append(getClass().getName())
					.append("#onDestroy").toString());
		}
		mStateManager.onDestroy();

		if (!mDestroyTask.onDestroy()) {
            // 警告表示
            Util.showErrorToast(mContext,
                    R.string.toast_finish_timeout);
            mDestroyTask.closeProgressDialog();
		}
		super.onDestroy();
	}

    @Override
    public void onDestroyImplPre() {
        stopWakeLock();

        mHandler = null;

        if (mPhoneStateListener != null) {
            TelephonyManager telephonyManager = (TelephonyManager) getSystemService(
                    TELEPHONY_SERVICE);
            if (telephonyManager != null) {
                telephonyManager.listen(mPhoneStateListener,
                        PhoneStateListener.LISTEN_NONE);
            }
            mPhoneStateListener = null;
        }
    }

    @Override
    public void onDestroyImpl() {
        releaseLoader();
    }

    @Override
    public void onDestroyImplPost() {
        mParentScreen.getViewTreeObserver().removeGlobalOnLayoutListener(this);
        mVideoLoader = null;
        mMessageLoader = null;
        mMessageLoaderFork = null;
        mThumbInfo = null;
//        mMessageData.mChatsWait = null;
//        mMessageData.mChatsRunningNaka = null;
//        mMessageData.mChatsRunningShita = null;
//        mMessageData.mChatsRunningUe = null;
//        mPaintText = null;
        mMessageChatController = null;
    }

    @Override
    public boolean wasDestroyed() {
        return mStateManager.wasDestroyed();
    }

	private void releaseLoader() {
        if (mVideoLoader == null && mMessageLoader == null
                && mMessageLoaderFork == null && mThumbInfo == null) {
            // すべて解放済みなら処理無し
            return;
        }

        // XXX 本当は***Loader類のabort対応が必要
        ExecutorService executorService = Executors.newCachedThreadPool();
        CountDownLatch latch = new CountDownLatch(4);
        if (mVideoLoader == null) {
            latch.countDown();
        } else {
            mVideoLoader.finishAsync(executorService, latch);
        }
        if (mMessageLoader == null) {
            latch.countDown();
        } else {
            mMessageLoader.finishAsync(executorService, latch);
        }
        if (mMessageLoaderFork == null) {
            latch.countDown();
        } else {
            mMessageLoaderFork.finishAsync(executorService, latch);
        }
        if (mThumbInfo == null) {
            latch.countDown();
        } else {
            mThumbInfo.finishAsync(executorService, latch);
        }
        while (true) {
            try {
                latch.await();
                break;
            } catch (InterruptedException e) {
                Log.d(LOG_TAG, e.toString(), e);
            }
        }
        executorService.shutdown();
	}

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (mLastOrientation != newConfig.orientation) {
            onOrientationChanged(newConfig.orientation);
            mLastOrientation = newConfig.orientation;
        }
    }

    abstract protected void onOrientationChanged(int orientation);

    protected void onOrientationChangedCommon(int orientation,
            ViewGroup temp) {
        mProgressViews.copyLayoutParamsFrom(temp);

        mInfoViews.copyLayoutParamsFrom(temp);

        mPlayerControllerViews.copyLayoutParamsFrom(temp);

        mPlayerInfoControllerManager.onOrientationChanged(orientation);
    }

	@Override
    public boolean onTouchEvent(MotionEvent event) {
		if (DEBUG_LOGV) {
			Log.v(LOG_TAG, Log.buf().append(getClass().getName())
					.append("#onTouchEvent: event=").append(event)
					.toString());
		}
		if (mPlayerInfoControllerManager.onTouchEvent(event)) {
			return true;
		}
		return super.onTouchEvent(event);
    }

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		if (DEBUG_LOGV) {
			Log.v(LOG_TAG, Log.buf().append(getClass().getName())
					.append("#onKeyDown: keyCode=").append(keyCode)
					.append(" event=").append(event)
					.toString());
		}
		if (mPlayerInfoControllerManager.onKeyDown(keyCode, event)) {
		    return true;
		}
		return super.onKeyDown(keyCode, event);
	}

	@Override
	public boolean onKeyUp(int keyCode, KeyEvent event) {
		if (DEBUG_LOGV) {
			Log.v(LOG_TAG, Log.buf().append(getClass().getName())
					.append("#onKeyUp: keyCode=").append(keyCode)
					.append(" event=").append(event)
					.toString());
		}
		return super.onKeyUp(keyCode, event);
	}

	@Override
	public void onGlobalLayout() {
	}

//    @Override
//    protected void finalize() throws Throwable {
//    	try {
//            if (DEBUG_LOGV) {
//                Log.v(LOG_TAG, "AbstractNicoroPlayer#finalize start");
//            }
//    		super.finalize();
//    	} finally {
//    	    releaseLoader();
//            if (DEBUG_LOGV) {
//                Log.v(LOG_TAG, "AbstractNicoroPlayer#finalize end");
//            }
//    	}
//    }

	protected void initializeView() {
	    mParentScreen = Util.findViewById(this, R.id.parent_screen);
	    mParentScreen.getViewTreeObserver().addOnGlobalLayoutListener(this);

	    mProgressViews.initializeView(this);

	    mInfoViews.initializeView(this);

	    mPlayerControllerViews.initializeView(this);
	    mPlayerControllerViews.setButtonPauseOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
			    if (mDidStartPlay) {
			        switchPausePlay();
			    }
			}
        });
	    mPlayerControllerViews.setButtonFromBeginOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				// いったんシークバー他無効化
			    mPlayerControllerViews.setEnabledSeekController(false);
				mPlayerControllerViews.setSeekBarProgress(0);
				seekBySecond(0);

				// TODO 最初に戻った後の再度再生するのはどうするか
			}
        });
	    mPlayerControllerViews.setButtonCommentOnOffOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView,
					boolean isChecked) {
				boolean messageDisable = !isChecked;
				if (mMessageDisable != messageDisable) {
					mMessageDisable = messageDisable;
		        	SharedPreferences.Editor editor = mSharedPreferences.edit();
		        	editor.putBoolean(
		        			getString(R.string.pref_key_message_disable),
		        			mMessageDisable);
		        	editor.commit();
				}
			}
        });
	    mPlayerControllerViews.setCheckedButtonCommentOnOff(!mMessageDisable);
	    mPlayerControllerViews.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
			@Override
			public void onProgressChanged(SeekBar seekBar, int progress,
					boolean fromUser) {
			}
			@Override
			public void onStartTrackingTouch(SeekBar seekBar) {
			}
			@Override
			public void onStopTrackingTouch(SeekBar seekBar) {
                int second = seekBar.getProgress();
                int cacheSecond = seekBar.getSecondaryProgress();
                if (second > cacheSecond) {
                    // シーク位置はキャッシュの範囲内に抑える
                    second = cacheSecond;
                }
				// いったんシークバー他無効化
                mPlayerControllerViews.setEnabledSeekController(false);

//				// いったんポーズ
//				final boolean isPause = isPausePlay();
//				if (!isPause) {
//					pausePlay();
//				}

//				seekBySecondCommon(second);
				seekBySecond(second);

//				if (!isPause) {
//					restartPlay();
//				}
			}
        });

        // Viewが必要なためここで初期化
        mPlayerInfoControllerManager = new PlayerInfoControllerManager(
                mContext, mInfoViews.getInfoView(), mPlayerControllerViews.getControllerView(), mInfoViews.getTimeView());
	}

	protected static VideoLoader createVideoLoader(Intent intent, Context context) {
		VideoLoader videoLoader = null;
        String url = intent.getStringExtra(AbstractNicoroPlayer.INTENT_NAME_VIDEO_URL);
        String cookie = intent.getStringExtra(AbstractNicoroPlayer.INTENT_NAME_COOKIE);
        String videoNumber = intent.getStringExtra(AbstractNicoroPlayer.INTENT_NAME_VIDEO_NUMBER);
        String cookieUserSession = intent.getStringExtra(AbstractNicoroPlayer.INTENT_NAME_COOKIE_USER_SESSION);

        if (DEBUG_LOGD) {
        	Log.d(LOG_TAG, Log.buf().append(" url=").append(url).append(" cookie=")
        			.append(cookie).append(" videoNumber=").append(videoNumber)
        			.append(" cookieUserSession=").append(cookieUserSession)
        			.toString());
        }
        if (url != null && cookie != null) {
        	videoLoader = new VideoLoader(url, cookie, videoNumber,
        			context, cookieUserSession,
//        			android.os.Process.THREAD_PRIORITY_BACKGROUND);
        			android.os.Process.THREAD_PRIORITY_BACKGROUND
        			+ android.os.Process.THREAD_PRIORITY_MORE_FAVORABLE * 2);
        }
		return videoLoader;
	}

	protected static MessageLoader createMessageLoader(Intent intent, Context context,
			String userSession) {
		MessageLoader messageLoader = null;
        String cookie = intent.getStringExtra(
        		AbstractNicoroPlayer.INTENT_NAME_COOKIE);
        String messageUrl = intent.getStringExtra(
        		AbstractNicoroPlayer.INTENT_NAME_MESSAGE_URL);
        String threadId = intent.getStringExtra(
        		AbstractNicoroPlayer.INTENT_NAME_THREAD_ID);
        String userId = intent.getStringExtra(
        		AbstractNicoroPlayer.INTENT_NAME_USER_ID);
        String threadKey = intent.getStringExtra(
        		AbstractNicoroPlayer.INTENT_NAME_THREAD_KEY);
        String force184 = intent.getStringExtra(
        		AbstractNicoroPlayer.INTENT_NAME_FORCE_184);
        if (DEBUG_LOGD) {
        	Log.d(LOG_TAG, Log.buf().append(" cookie=").append(cookie)
        			.append(" messageUrl=").append(messageUrl).append(" threadId=")
        			.append(threadId).append(" userId=").append(userId).append(" threadKey=")
        			.append(threadKey).append(" force184=").append(force184).toString());
        }
        if (messageUrl != null && threadId != null && cookie != null) {
        	messageLoader = new MessageLoader(messageUrl, threadId, userSession,
        			userId, threadKey, force184,
        			context);
        }
		return messageLoader;
	}

	protected static MessageLoaderFork createMessageLoaderFork(Intent intent, Context context,
			String userSession) {
		MessageLoaderFork messageLoader = null;
        String cookie = intent.getStringExtra(
        		AbstractNicoroPlayer.INTENT_NAME_COOKIE);
        String messageUrl = intent.getStringExtra(
        		AbstractNicoroPlayer.INTENT_NAME_MESSAGE_URL);
        String threadId = intent.getStringExtra(
        		AbstractNicoroPlayer.INTENT_NAME_THREAD_ID);
        String userId = intent.getStringExtra(
        		AbstractNicoroPlayer.INTENT_NAME_USER_ID);
        String threadKey = intent.getStringExtra(
        		AbstractNicoroPlayer.INTENT_NAME_THREAD_KEY);
        String force184 = intent.getStringExtra(
        		AbstractNicoroPlayer.INTENT_NAME_FORCE_184);
        if (DEBUG_LOGD) {
        	Log.d(LOG_TAG, Log.buf().append(" cookie=").append(cookie)
        			.append(" messageUrl=").append(messageUrl).append(" threadId=")
        			.append(threadId).append(" userId=").append(userId).append(" threadKey=")
        			.append(threadKey).append(" force184=").append(force184).toString());
        }
        if (messageUrl != null && threadId != null && cookie != null) {
        	messageLoader = new MessageLoaderFork(messageUrl, threadId, userSession,
        			userId, threadKey, force184,
        			context);
        }
		return messageLoader;
	}

	protected static ThumbInfo createThumbInfo(Intent intent) {
		ThumbInfo thumbInfo = null;
        String videoNumber = intent.getStringExtra(AbstractNicoroPlayer.INTENT_NAME_VIDEO_NUMBER);
        if (DEBUG_LOGD) {
        	Log.d(LOG_TAG, Log.buf().append(" videoNumber=").append(videoNumber).toString());
        }
        if (videoNumber != null) {
        	thumbInfo = new ThumbInfo(videoNumber);
        }
        return thumbInfo;
	}

	protected void getThumbInfo(Intent intent) {
        String videoNumber = intent.getStringExtra(AbstractNicoroPlayer.INTENT_NAME_VIDEO_NUMBER);
        if (DEBUG_LOGD) {
        	Log.d(LOG_TAG, Log.buf().append(" videoNumber=").append(videoNumber).toString());
        }
        getThumbInfo(videoNumber);
	}
    protected void getThumbInfo(String videoNumber) {
		ThumbInfoCacher cacher = NicoroApplication.getInstance(this
		        ).getThumbInfoCacher();
        if (videoNumber == null) {
        	return;
        }
    	ThumbInfo thumbInfo = cacher.getThumbInfo(videoNumber);
        Handler handler = mHandler;
    	if (thumbInfo == null) {
			if (handler != null) {
				cacher.loadThumbInfo(videoNumber,
				        new CallbackMessage<ThumbInfo, String>(
				                handler,
				                MSG_ID_THUMBINFO_FINISHED_NEW,
				                MSG_ID_THUMBINFO_OCCURRED_ERROR_NEW));
			}
    	} else {
    		mThumbInfo = thumbInfo;
			if (handler != null) {
				handler.obtainMessage(MSG_ID_THUMBINFO_FINISHED,
						thumbInfo.getLength()).sendToTarget();
			}
    	}
	}

    protected void seekBySecondCommon(int second) {
    	// コメントデータ初期化
    	// TODO 排他制御どうするか？
        mMessageData.resetChats(mMessageLoader.getChats());
        mMessageDataFork.resetChats(mMessageLoaderFork.getChats());
    }

	protected StringBuilder appendCurrentPlayTimeCommon(StringBuilder builder,
			final long posNum, final int posDen) {
		if (posDen != 0) {
			int minutes = (int) (posNum / ((long) posDen * 60));
			int seconds = (int) (posNum / posDen % 60);
			return Util.appendPlayTime(builder, minutes, seconds);
		} else {
			return builder.append(INFO_TIME_DEFAULT);
		}
	}

	protected void setButtonPauseImage() {
	    mPlayerControllerViews.setButtonPauseImage(isPausePlay());
	}

	void showErrorDialog(String errorMessage) {
	    onShowErrorDialog(Util.showErrorDialog(this,
                errorMessage + getString(R.string.dialog_text_suffix_player_auto_close),
                true));
	}

    protected void onShowErrorDialog(AlertDialog errorDialog) {
        mErrorDialog = errorDialog;
        stopWakeLock();
        Handler handler = mHandler;
        if (handler != null) {
            handler.removeMessages(MSG_ID_AUTO_CLOSE);
            handler.sendEmptyMessageDelayed(MSG_ID_AUTO_CLOSE, 30000);
        }
    }

	private void startWakeLock() {
        if (!mWakeLock.isHeld()) {
            mWakeLock.acquire();
        }
        AbstractNicoroPlayer.setNotificationRunningPlayer(
                mContext, getClass());
    }
    private void stopWakeLock() {
        if (mWakeLock.isHeld()) {
            mWakeLock.release();
        }
        AbstractNicoroPlayer.clearNotificationRunningPlayer(
                mContext);
    }

    public static void setNotificationRunningPlayer(Context context,
            Class<? extends Activity> activityClass) {
        NotificationManager notificationManager =
            (NotificationManager) context.getSystemService(
                    Context.NOTIFICATION_SERVICE);
        if (notificationManager != null) {
//            int icon = R.drawable.icon;
            int icon = R.drawable.status_playing;
            String title = context.getString(R.string.app_name);
            String contentText = context.getString(
                    R.string.notification_running_player);
            Notification notification = new Notification(icon,
//                    contentText,
                    null,
                    0);
            notification.flags |= Notification.FLAG_ONGOING_EVENT;
            Intent intent = new Intent(context, activityClass)
                .setFlags(Intent.FLAG_ACTIVITY_REORDER_TO_FRONT);
            PendingIntent pendingIntent = PendingIntent.getActivity(
                    context, 0, intent,
                    PendingIntent.FLAG_UPDATE_CURRENT);
            notification.setLatestEventInfo(context, title, contentText,
                    pendingIntent);
            notificationManager.notify(
                    NOTIFICATION_ID_RUNNING_PLAYER,
                    notification);
        }
    }
    public static void clearNotificationRunningPlayer(Context context) {
        NotificationManager notificationManager =
            (NotificationManager) context.getSystemService(
                    Context.NOTIFICATION_SERVICE);
        if (notificationManager != null) {
            notificationManager.cancel(
                    NOTIFICATION_ID_RUNNING_PLAYER);
        }
    }
}
