/**
 * 
 */
package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.Log.DEBUG_LOGV;
import static jp.sourceforge.nicoro.swf.Log.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.Log.LOG_TAG;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import jp.sourceforge.nicoro.FailAnalyzeSwfException;

public class PlaceObject2 extends PlaceObjectBase {
	public boolean placeFlagHasClipActions;		// UB[1]
	public boolean placeFlagHasClipDepth;		// UB[1]
	public boolean placeFlagHasName;			// UB[1]
	public boolean placeFlagHasRatio;			// UB[1]
	public boolean placeFlagHasColorTransform;	// UB[1]
	public boolean placeFlagHasMatrix;			// UB[1]
	public boolean placeFlagHasCharacter;		// UB[1]
	public boolean placeFlagMove;				// UB[1]
	public short depth;							// UI16
	public short characterId;					// UI16
	public MATRIX matirx;
	public CXFORMWITHALPHA colorTransform;
	public short ratio;							// UI16
	public String name;							// STRING
	public short clipDepth;						// UI16
	public CLIPACTIONS clipActions;
	
	public ByteBuffer read(ByteBuffer buffer) throws FailAnalyzeSwfException, UnsupportedEncodingException {
		PlaceObject2 placeObject2 = this;
		assert buffer.order() == ByteOrder.LITTLE_ENDIAN;
		byte[] bufferArray = buffer.array();
		
		byte placeFlag = buffer.get();
		placeObject2.placeFlagHasClipActions = (placeFlag & 0x80) != 0;
		placeObject2.placeFlagHasClipDepth = (placeFlag & 0x40) != 0;
		placeObject2.placeFlagHasName = (placeFlag & 0x20) != 0;
		placeObject2.placeFlagHasRatio = (placeFlag & 0x10) != 0;
		placeObject2.placeFlagHasColorTransform = (placeFlag & 0x08) != 0;
		placeObject2.placeFlagHasMatrix = (placeFlag & 0x04) != 0;
		placeObject2.placeFlagHasCharacter = (placeFlag & 0x02) != 0;
		placeObject2.placeFlagMove = (placeFlag & 0x01) != 0;
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf()
					.append("PlaceFlagHasClipActions=").append(placeObject2.placeFlagHasClipActions)
					.append(" PlaceFlagHasClipDepth=").append(placeObject2.placeFlagHasClipDepth)
					.append(" PlaceFlagHasName=").append(placeObject2.placeFlagHasName)
					.append(" PlaceFlagHasRatio=").append(placeObject2.placeFlagHasRatio)
					.append(" PlaceFlagHasColorTransform=").append(placeObject2.placeFlagHasColorTransform)
					.append(" PlaceFlagHasMatrix=").append(placeObject2.placeFlagHasMatrix)
					.append(" PlaceFlagHasCharacter=").append(placeObject2.placeFlagHasCharacter)
					.append(" PlaceFlagMove=").append(placeObject2.placeFlagMove).toString());
		}
		placeObject2.depth = buffer.getShort();
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf().append("Depth=")
					.append(placeObject2.depth).toString());
		}
		if (placeObject2.placeFlagHasCharacter) {
    		placeObject2.characterId = buffer.getShort();
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, Log.buf().append("CharacterId=")
    					.append(placeObject2.characterId).toString());
    		}
			
		}
		if (placeObject2.placeFlagHasMatrix) {
			placeObject2.matirx = new MATRIX();
			int newPosition = placeObject2.matirx.read(bufferArray, buffer.position());
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, Log.buf().append("newPosition=").append(newPosition)
    					.append(" buffer length=").append(buffer.limit()).toString());
    		}
			buffer.position(newPosition);
		}
		if (placeObject2.placeFlagHasColorTransform) {
			placeObject2.colorTransform = new CXFORMWITHALPHA();
			int newPosition = placeObject2.colorTransform.read(bufferArray, buffer.position());
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, Log.buf().append("newPosition=").append(newPosition)
    					.append(" buffer length=").append(buffer.limit()).toString());
    		}
			buffer.position(newPosition);
		}
		if (placeObject2.placeFlagHasRatio) {
    		placeObject2.ratio = buffer.getShort();
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, Log.buf().append("Ratio=")
    					.append(placeObject2.ratio).toString());
    		}
		}
		if (placeObject2.placeFlagHasName) {
			int sz;
			for (sz = buffer.position(); bufferArray[sz] != 0; ++sz) {}
			placeObject2.name = new String(bufferArray, buffer.position(), sz - buffer.position() + 1, "UTF-8");
			buffer.position(sz + 1);
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, Log.buf().append("Name=")
    					.append(placeObject2.name).toString());
    		}
		}
		if (placeObject2.placeFlagHasClipDepth) {
    		placeObject2.clipDepth = buffer.getShort();
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, Log.buf().append("ClipDepth=")
    					.append(placeObject2.clipDepth).toString());
    		}
		}
		if (placeObject2.placeFlagHasClipActions) {
			placeObject2.clipActions = new CLIPACTIONS();
			// TODO
			throw new FailAnalyzeSwfException("TODO: PlaceObject2 PlaceFlagHasClipActions is unimplemented.");
		}
		
		return buffer;
	}
}