package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.Log.DEBUG_LOGV;
import static jp.sourceforge.nicoro.swf.Log.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.Log.LOG_TAG;
import android.graphics.Color;

public class GRADRECORD {
	public byte ratio;		// UI8
	public int color;		// RGB (Shape1 or Shape2), RGBA (Shape3)
	
    public int read(byte[] bufferArray, int offset, int tagType) {
    	GRADRECORD gradRecord = this;
    	
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf().append("readGRADRECORD: offset=")
					.append(offset).toString());
		}
		
		gradRecord.ratio = bufferArray[offset];
		int offsetNext = offset + 1;
		switch (tagType) {
		case RECORDHEADER.SWFTAG_DEFINESHAPE:
		case RECORDHEADER.SWFTAG_DEFINESHAPE2:
			gradRecord.color = Color.rgb(
					bufferArray[offsetNext + 0],
					bufferArray[offsetNext + 1],
					bufferArray[offsetNext + 2]);
			offsetNext += 3;
			break;
		case RECORDHEADER.SWFTAG_DEFINESHAPE3:
			gradRecord.color = Color.argb(
					bufferArray[offsetNext + 3],
					bufferArray[offsetNext + 0],
					bufferArray[offsetNext + 1],
					bufferArray[offsetNext + 2]);
			offsetNext += 4;
			break;
		default:
			Log.w(LOG_TAG, Log.buf().append("GRADRECORD: record tag type mismatch=")
					.append(tagType).toString());
			break;
		}
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, Log.buf().append("Color=")
    				.append(Integer.toHexString(gradRecord.color)).toString());
    	}
    	
		return offsetNext;
    }
    
}
