package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.Log.DEBUG_LOGV;
import static jp.sourceforge.nicoro.swf.Log.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.Log.LOG_TAG;
import java.util.ArrayList;

import jp.sourceforge.nicoro.FailAnalyzeSwfException;

public class SHAPEWITHSTYLE {
	public FILLSTYLEARRAY fillStyles = new FILLSTYLEARRAY();
	public LINESTYLEARRAY lineStyles = new LINESTYLEARRAY();
	public byte numFillBits;		// UB[4]
	public byte numLineBits;		// UB[4]
	public ArrayList<SHAPERECORD> shapeRecords = new ArrayList<SHAPERECORD>(1);

    public int read(byte[] bufferArray, int offset, int tagType) throws FailAnalyzeSwfException {
    	SHAPEWITHSTYLE shapeWithStyle = this;
    	
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf().append("readSHAPEWITHSTYLE: offset=")
					.append(offset).toString());
		}
		
		int offsetLineStyles = shapeWithStyle.fillStyles.read(bufferArray, offset, tagType);
		int offsetNumFillBits = shapeWithStyle.lineStyles.read(bufferArray, offsetLineStyles, tagType);
		shapeWithStyle.numFillBits = (byte) ((bufferArray[offsetNumFillBits] >> 4) & 0x0f);
		shapeWithStyle.numLineBits = (byte) (bufferArray[offsetNumFillBits] & 0x0f);
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, Log.buf()
    				.append("NumFillBits=").append(shapeWithStyle.numFillBits)
    				.append(" NumLineBits=").append(shapeWithStyle.numLineBits).toString());
    	}
		
		return SwfPlayer.readSHAPERECORDs(shapeWithStyle.shapeRecords,
				shapeWithStyle.numFillBits, shapeWithStyle.numLineBits,
				bufferArray, offsetNumFillBits + 1, tagType);
    }
    
}
