package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.Log.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.Log.LOG_TAG;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

import jp.sourceforge.nicoro.FailAnalyzeSwfException;
import jp.sourceforge.nicoro.PartialInputStreamRandomAccessWrapper;
import jp.sourceforge.nicoro.Util;

public class DefineBitsJPEG2 {
	public short characterID;		// UI16

//    public void read(byte[] bufferArray, SwfPlayer swfPlayer) throws FailAnalyzeSwfException {
//		characterID = (short) ((bufferArray[0] & 0xff) | ((bufferArray[1] & 0xff) << 8));
//		if (DEBUG_LOGD) {
//			Log.d(LOG_TAG, Log.buf().append("CharacterID=")
//					.append(characterID).toString());
//		}
//		Bitmap bitmap = BitmapFactory.decodeByteArray(bufferArray, 2, bufferArray.length - 2);
//		if (bitmap == null) {
//    		throw new FailAnalyzeSwfException("tag block contents DefineBitsJPEG2 bitmap create failed.");
//		}
//		if (DEBUG_LOGD) {
//			Log.d(LOG_TAG, Log.buf()
//					.append("Bitmap getWidth()=").append(bitmap.getWidth())
//					.append(" getHeight()=").append(bitmap.getHeight()).toString());
//		}
//		swfPlayer.putBitmapToDictionary(characterID, bitmap);
//    }
	
    public void read(RandomAccessFile in, int length, SwfPlayer swfPlayer) throws IOException, FailAnalyzeSwfException {
    	long begin = in.getFilePointer();
    	readHeader(in);
    	
    	int dataLength = (int) (length - (in.getFilePointer() - begin));
    	BitmapLoader loader = new BitsJPEG2Loader(
    			in, in.getFilePointer(), dataLength);
//    	Bitmap bitmap = loader.get();
    	in.seek(in.getFilePointer() + dataLength);
//		swfPlayer.putBitmapToDictionary(characterID, bitmap);
		swfPlayer.putBitmapToDictionary(characterID, loader);
    }
    
    private void readHeader(RandomAccessFile in) throws IOException {
		characterID = (short) Util.readShortLE(in);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf().append("CharacterID=")
					.append(characterID).toString());
		}
    }
    
    private Bitmap readData(InputStream data) throws IOException, FailAnalyzeSwfException {
		Bitmap bitmap = BitmapFactory.decodeStream(data);
		if (bitmap == null) {
    		throw new FailAnalyzeSwfException("tag block contents DefineBitsJPEG2 bitmap create failed.");
		}
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf()
					.append("Bitmap getWidth()=").append(bitmap.getWidth())
					.append(" getHeight()=").append(bitmap.getHeight()).toString());
		}
		return bitmap;
    }
    
    private class BitsJPEG2Loader extends BitmapLoader {
    	private final RandomAccessFile mIn;
    	private final long mFilePointer;
    	private final int mLength;
    	
    	BitsJPEG2Loader(RandomAccessFile in, long filePointer, int length) {
    		mIn = in;
    		mFilePointer = filePointer;
    		mLength = length;
    	}
    	
		@Override
		public Bitmap load() throws IOException, FailAnalyzeSwfException {
			long last = mIn.getFilePointer();
			mIn.seek(mFilePointer);
			
			PartialInputStreamRandomAccessWrapper partialIn =
				new PartialInputStreamRandomAccessWrapper(mIn, mLength);
	    	Bitmap bitmap = readData(partialIn);
	    	
			mIn.seek(last);
			return bitmap;
		}
    }
}
