package jp.gr.java_conf.shiseissi.commonlib;

import android.test.AndroidTestCase;

import java.util.ArrayList;
import java.util.Arrays;

/**
 *
 * @author shisei
 */
public class FileSelectFragmentTest extends AndroidTestCase {
    public void testConvertToPathString() {
        ArrayList<String> path = new ArrayList<String>();

        setListPath(path, "");
        assertEquals("/", FileSelectFragment.convertToPathString(path, 0));

        setListPath(path, "", "a");

        assertEquals("/a", FileSelectFragment.convertToPathString(path, 1));
        assertEquals("/", FileSelectFragment.convertToPathString(path, 0));

        setListPath(path, "", "a", "b");

        assertEquals("/a/b", FileSelectFragment.convertToPathString(path, 2));
        assertEquals("/a", FileSelectFragment.convertToPathString(path, 1));
        assertEquals("/", FileSelectFragment.convertToPathString(path, 0));

        setListPath(path, "", "a", "b", "c");

        assertEquals("/a/b/c", FileSelectFragment.convertToPathString(path, 3));
        assertEquals("/a/b", FileSelectFragment.convertToPathString(path, 2));
        assertEquals("/a", FileSelectFragment.convertToPathString(path, 1));
        assertEquals("/", FileSelectFragment.convertToPathString(path, 0));

        setListPath(path, "a", "b", "c");

        assertEquals("a/b/c", FileSelectFragment.convertToPathString(path, 2));
        assertEquals("a/b", FileSelectFragment.convertToPathString(path, 1));
        assertEquals("a", FileSelectFragment.convertToPathString(path, 0));
    }

    private static void setListPath(ArrayList<String> path, String... args) {
        path.clear();
        path.addAll(Arrays.asList(args));
    }

    public void testConvertToListString() {
        ArrayList<String> path = FileSelectFragment.convertToListString("");
        assertListEqualsStrings(path, "");

        path = FileSelectFragment.convertToListString("/");
        assertListEqualsStrings(path, "");

        path = FileSelectFragment.convertToListString("/a");
        assertListEqualsStrings(path, "", "a");

        path = FileSelectFragment.convertToListString("/a/b");
        assertListEqualsStrings(path, "", "a", "b");

        path = FileSelectFragment.convertToListString("/a/b/c");
        assertListEqualsStrings(path, "", "a", "b", "c");

        path = FileSelectFragment.convertToListString("/a/b//c");
        assertListEqualsStrings(path, "", "a", "b", "c");

        path = FileSelectFragment.convertToListString("a/b/c");
        assertListEqualsStrings(path, "a", "b", "c");
    }

    private static void assertListEqualsStrings(ArrayList<String> path, String... args) {
        path.equals(Arrays.asList(args));
    }
}
