package jp.sourceforge.nicoro;

import android.test.AndroidTestCase;

public class UtilTest extends AndroidTestCase {
    public void testConvertHtmlEscapedCharacter() {
        assertNull(Util.convertHtmlEscapedCharacter(null));

        assertEquals("abcde", Util.convertHtmlEscapedCharacter("abcde"));

        assertEquals("\"", Util.convertHtmlEscapedCharacter("&quot;"));
        assertEquals("&", Util.convertHtmlEscapedCharacter("&amp;"));
        assertEquals("<", Util.convertHtmlEscapedCharacter("&lt;"));
        assertEquals(">", Util.convertHtmlEscapedCharacter("&gt;"));
        assertEquals(" ", Util.convertHtmlEscapedCharacter("&nbsp;"));

        assertEquals("&", Util.convertHtmlEscapedCharacter("&#38;"));
        assertEquals("&", Util.convertHtmlEscapedCharacter("&#x26;"));

        assertEquals("&#", Util.convertHtmlEscapedCharacter("&#"));
        assertEquals("&#x", Util.convertHtmlEscapedCharacter("&#x"));

        String src = "& &quot &amp &lt &gt &nbsp &#100 &x100";
        String expected = "& &quot &amp &lt &gt &nbsp &#100 &x100";
        assertEquals(expected, Util.convertHtmlEscapedCharacter(src));

        src = "&quot;quot&amp;&lt;nbsp&gt;&nbsp;&#38;and;&#x26;;end";
        expected = "\"quot&<nbsp> &and;&;end";
        assertEquals(expected, Util.convertHtmlEscapedCharacter(src));
    }
}
