package jp.sourceforge.nicoro;

import android.content.res.Resources;
import android.test.AndroidTestCase;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import jp.gr.java_conf.shiseissi.commonlib.ViewUtil;

public class PlayerInfoMiniViewsTests extends AndroidTestCase {
    private LayoutInflater mInflater;
    private View mRootView;
    private Resources mRes;
    private PlayerInfoMiniViews mViews;

    @Override
    protected void setUp() {
        mInflater = LayoutInflater.from(getContext());
        assertNotNull(mInflater);
        mRootView = createRootView(mInflater);
        assertNotNull(mRootView);
        mRes = getContext().getResources();
        mViews = new PlayerInfoMiniViews();
        mViews.initializeView(mRootView);
    }

    @Override
    protected void tearDown() {
        mInflater = null;
        mRootView = null;
        mRes = null;
        mViews = null;
    }

    public void testSetTime() {
        StringBuilder result = mViews.setTime(new PlayerInfoDialogFragment.TimeAppender() {
            @Override
            public boolean hasTotalPlayTime() {
                return true;
            }

            @Override
            public StringBuilder appendTotalPlayTime(StringBuilder builder) {
                return builder.append("99:99");
            }

            @Override
            public StringBuilder appendCurrentPlayTime(StringBuilder builder) {
                return builder.append("12:34");
            }
        });
        assertEquals("12:34/99:99", result.toString());

        VariableLabelView timeView = (VariableLabelView) mViews.getTimeView();
        assertEquals("12:34/99:99", timeView.getText());
    }

    public void testGetInfoMiniView() {
        assertNotNull(mViews.getInfoMiniView());
    }

    public void testUpdateBattery() {
        mViews.updateBattery(39, 100);

        VariableLabelView infoBattery = ViewUtil.findViewById(mRootView,
                R.id.info_mini_battery);
        assertNotNull(infoBattery);
        assertEquals(mRes.getString(R.string.bat) + ": 39%", infoBattery.getText());
    }

    protected View createRootView(LayoutInflater inflater) {
        FrameLayout temp = new FrameLayout(getContext());
        return inflater.inflate(R.layout.player_info_mini, temp, false);
    }

}
