package jp.sourceforge.nicoro;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public interface XmlLoaderInterface {
    /**
     * load開始する
     */
    void startLoad();

    /**
     * 動作中のloadを終了させる。
     * 完全に終了するまで戻らない。
     */
    void finish();

    /**
     * 動作中のloadを非同期で終了させる
     */
    void finishAsync(ExecutorService executorService,
            final CallbackMessage<Void, Void> callback);

    /**
     * 動作中のloadを非同期で終了させる
     */
    void finishAsync(ExecutorService executorService,
            final CountDownLatch latch);

    public static abstract class AbstractNullObject implements XmlLoaderInterface {
        protected AbstractNullObject() {
        }

        @Override
        public void startLoad() {
        }

        @Override
        public void finish() {
        }

        @Override
        public void finishAsync(ExecutorService executorService,
                CallbackMessage<Void, Void> callback) {
            if (callback != null) {
                callback.sendMessageSuccess(null);
            }
        }

        @Override
        public void finishAsync(ExecutorService executorService, CountDownLatch latch) {
            latch.countDown();
        }
    }
}
