package jp.sourceforge.nicoro;

import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.test.AndroidTestCase;

public class LiveVideoLoaderTests extends AndroidTestCase {
    private static final int EVT_SUCCESS = 1;
    private static final int EVT_ERROR = 2;

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            mWhatLast = msg.what;
            mObjLast = msg.obj;
            synchronized (mSync) {
                mSync.notifyAll();
            }
        }
    };
    private LiveVideoLoader mLiveVideoLoader;
    private final Object mSync = new Object();
    private int mWhatLast;
    private Object mObjLast;
    private LivePlayerStatusLoader mLivePlayerStatusLoader;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        mWhatLast = -1;
        mObjLast = null;
        mLiveVideoLoader = new LiveVideoLoader(getContext());
        mLiveVideoLoader.start();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        mLiveVideoLoader.close();
        mLiveVideoLoader.free();
        mLiveVideoLoader.quit();
        mLiveVideoLoader = null;
        if (mLivePlayerStatusLoader != null) {
            mLivePlayerStatusLoader.finish();
            mLivePlayerStatusLoader = null;
        }
    }

    // TODO 視聴確認用動画の公開期限が終わってこの方法ではテストできなくなった
//    public void testStartConnect() throws Exception {
//        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(mContext);
//        String cookieUserSession = sharedPreferences.getString(
//                NicoroConfig.COOKIE_USER_SESSION, null);
//        assertNotNull("COOKIE_USER_SESSION must be set manually before test start",
//                cookieUserSession);
//        String lvNumber = "lv25063688";
//        mLivePlayerStatusLoader = new LivePlayerStatusLoader(lvNumber,
//                cookieUserSession, getContext());
//        CallbackMessage<Void, String> callbackLivePlayerStatus = new CallbackMessage<Void, String>(
//                mHandler, EVT_SUCCESS, EVT_ERROR);
//        mLivePlayerStatusLoader.registerCallback(callbackLivePlayerStatus);
//        mLivePlayerStatusLoader.startLoad();
//        synchronized (mSync) {
//            mSync.wait(60 * 1000);
//        }
//        if (mWhatLast != EVT_SUCCESS) {
//            if (mWhatLast == EVT_ERROR) {
//                fail("EVT_ERROR, error message=" + mObjLast);
//            } else {
//                fail("mWhatLast=" + mWhatLast);
//            }
//        }
//        String url = mLivePlayerStatusLoader.getRtmpUrl();
//        String ticket = mLivePlayerStatusLoader.getRtmpTicket();
//        // TODO 動画によってはrtmp urlが無い
//        // →そのときはstream contents_list contentsを使う？
//        // →会員でなくても見られる生放送の場合は、contentsの値を見て
//        // 対応するtickets streamの値をplaypathに設定して使う？
//        assertNotNull(url);
//        assertNotNull(ticket);
//        mWhatLast = -1;
//        mObjLast = null;
//
//        CallbackMessage<Void, LiveVideoLoader.ErrorCode> callbackLiveVideo =
//            new CallbackMessage<Void, LiveVideoLoader.ErrorCode>(
//                    mHandler, EVT_SUCCESS, EVT_ERROR);
//        mLiveVideoLoader.startConnect(url + "/" + lvNumber, ticket, null, true, 0, lvNumber, null, callbackLiveVideo);
//        synchronized (mSync) {
//            mSync.wait(60 * 1000);
//        }
//        if (mWhatLast != EVT_SUCCESS) {
//            if (mWhatLast == EVT_ERROR) {
//                fail("EVT_ERROR, error code=" + mObjLast);
//            } else {
//                fail("mWhatLast=" + mWhatLast);
//            }
//        }
//
//        // TODO タイムシフトだとうまくReadできない？
//        // →quesheetが怪しいが
//        // →Flex messageを使う必要があるがlibrtmpのサポートが限定的？
//        // →駄目なのは有料放送や大会議か？
//        byte[] buffer = new byte[256];
//        int read = mLiveVideoLoader.readFromNativeCallback(256, buffer);
//        assertTrue(read > 0);
//    }
}
