/**
 *
 */
package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.Log.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.Log.LOG_TAG;
import jp.sourceforge.nicoro.BinUtil;

public class CXFORMWITHALPHA {
	public boolean hasAddTerms;		// UB[1]
	public boolean hasMultTerms;	// UB[1]
	public byte nbits;				// UB[4]
	public int redMultTerm;			// SB[Nbits] 最長31bit
	public int greenMultTerm;		// SB[Nbits] 最長31bit
	public int blueMultTerm;		// SB[Nbits] 最長31bit
	public int alphaMultTerm;		// SB[Nbits] 最長31bit
	public int redAddTerm;			// SB[Nbits] 最長31bit
	public int greenAddTerm;		// SB[Nbits] 最長31bit
	public int blueAddTerm;			// SB[Nbits] 最長31bit
	public int alphaAddTerm;		// SB[Nbits] 最長31bit

    public int read(byte[] bufferArray, int offset) {
    	CXFORMWITHALPHA cxFormWithAlpha = this;

		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf().append("readCXFORMWITHALPHA: offset=")
					.append(offset).toString());
		}
    	cxFormWithAlpha.hasAddTerms = (bufferArray[offset] & 0x80) != 0;
    	cxFormWithAlpha.hasMultTerms = (bufferArray[offset] & 0x40) != 0;
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf()
					.append("HasAddTerms=").append(cxFormWithAlpha.hasAddTerms)
					.append(" HasMultTerms=").append(cxFormWithAlpha.hasMultTerms).toString());
		}
    	byte[] binary = BinUtil.toBinaryFromBytes(bufferArray, offset * 8 + 1 + 1, 4);
    	cxFormWithAlpha.nbits = BinUtil.toByteFromBinary(binary, 0, 4);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf().append("Nbits=")
					.append(cxFormWithAlpha.nbits).toString());
		}
    	int binaryLength = 0;
    	if (cxFormWithAlpha.hasMultTerms) {
    		binaryLength += cxFormWithAlpha.nbits * 4;
    	}
    	if (cxFormWithAlpha.hasAddTerms) {
    		binaryLength += cxFormWithAlpha.nbits * 4;
    	}
    	if (cxFormWithAlpha.hasMultTerms || cxFormWithAlpha.hasAddTerms) {
    		binary = BinUtil.toBinaryFromBytes(bufferArray, offset * 8 + 1 + 1 + 4, binaryLength);
    	}
    	if (cxFormWithAlpha.hasMultTerms) {
    		cxFormWithAlpha.redMultTerm = BinUtil.toSIntFromBinary(binary, 0, cxFormWithAlpha.nbits);
    		cxFormWithAlpha.greenMultTerm = BinUtil.toSIntFromBinary(binary, cxFormWithAlpha.nbits * 1, cxFormWithAlpha.nbits);
    		cxFormWithAlpha.blueMultTerm = BinUtil.toSIntFromBinary(binary, cxFormWithAlpha.nbits * 2, cxFormWithAlpha.nbits);
    		cxFormWithAlpha.alphaMultTerm = BinUtil.toSIntFromBinary(binary, cxFormWithAlpha.nbits * 3, cxFormWithAlpha.nbits);
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, Log.buf()
    					.append("RedMultTerm=").append(cxFormWithAlpha.redMultTerm)
    					.append(" GreenMultTerm=").append(cxFormWithAlpha.greenMultTerm)
    					.append(" BlueMultTerm=").append(cxFormWithAlpha.blueMultTerm)
    					.append(" AlphaMultTerm=").append(cxFormWithAlpha.alphaMultTerm).toString());
    		}
    	}
    	if (cxFormWithAlpha.hasAddTerms) {
    		int addBinaryOffset = 0;
    		if (cxFormWithAlpha.hasMultTerms) {
    			addBinaryOffset += cxFormWithAlpha.nbits * 4;
    		}
    		cxFormWithAlpha.redAddTerm = BinUtil.toSIntFromBinary(binary, addBinaryOffset, cxFormWithAlpha.nbits);
    		cxFormWithAlpha.greenAddTerm = BinUtil.toSIntFromBinary(binary, addBinaryOffset + cxFormWithAlpha.nbits * 1, cxFormWithAlpha.nbits);
    		cxFormWithAlpha.blueAddTerm = BinUtil.toSIntFromBinary(binary, addBinaryOffset + cxFormWithAlpha.nbits * 2, cxFormWithAlpha.nbits);
    		cxFormWithAlpha.alphaAddTerm = BinUtil.toSIntFromBinary(binary, addBinaryOffset + cxFormWithAlpha.nbits * 3, cxFormWithAlpha.nbits);
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, Log.buf()
    					.append("RedAddTerm=").append(cxFormWithAlpha.redAddTerm)
    					.append(" GreenAddTerm=").append(cxFormWithAlpha.greenAddTerm)
    					.append(" BlueAddTerm=").append(cxFormWithAlpha.blueAddTerm)
    					.append(" AlphaAddTerm=").append(cxFormWithAlpha.alphaAddTerm).toString());
    		}
    	}
    	return offset + (1 + 1 + 4 + binaryLength + 7) / 8;
    }

}