
package jp.sourceforge.nicoro;

import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public interface MessageLoaderInterface extends XmlLoaderInterface {

    public interface EventListener {
    	/**
    	 * ファイル全体の読み込み完了
    	 * @param streamLoader
    	 */
    	void onFinished(MessageLoaderInterface messageLoader);
    	/**
    	 * エラー発生
    	 * @param streamLoader
    	 * @param errorMessage
    	 */
    	void onOccurredError(MessageLoaderInterface messageLoader, String errorMessage);
    }

    boolean isNull();

    Vector<MessageChat> getChats();

    Vector<MessageChat> getChatsFork();

    int getViewCounterVideo();

    int getViewCounterMylist();

    String getViewCounterId();

    int getAllLeafCount();

    int getLastRes();

    String getTicket();

    int getNicosLastRes();

    String getNicosTicket();

    String getThreadId();

    String getNicosId();

    void setVideoLength(String length);

    void setEventListener(MessageLoaderInterface.EventListener eventListener);

    public static class NullObject implements MessageLoaderInterface {
        private static final NullObject sInstance = new NullObject();
        public static NullObject getInstance() {
            return sInstance;
        }

        private NullObject() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public Vector<MessageChat> getChats() {
            return null;
        }

        @Override
        public Vector<MessageChat> getChatsFork() {
            return null;
        }

        @Override
        public int getViewCounterVideo() {
            return 0;
        }

        @Override
        public int getViewCounterMylist() {
            return 0;
        }

        @Override
        public String getViewCounterId() {
            return null;
        }

        @Override
        public int getAllLeafCount() {
            return 0;
        }

        @Override
        public int getLastRes() {
            return 0;
        }

        @Override
        public String getTicket() {
            return null;
        }

        @Override
        public int getNicosLastRes() {
            return 0;
        }

        @Override
        public String getNicosTicket() {
            return null;
        }

        @Override
        public String getThreadId() {
            return null;
        }

        @Override
        public String getNicosId() {
            return null;
        }

        @Override
        public void setVideoLength(String length) {
        }

        @Override
        public void setEventListener(EventListener eventListener) {
        }

        @Override
        public void startLoad() {
        }

        @Override
        public void finish() {
        }

        @Override
        public void finishAsync(ExecutorService executorService,
                CallbackMessage<Void, Void> callback) {
            if (callback != null) {
                callback.sendMessageSuccess(null);
            }
        }

        @Override
        public void finishAsync(ExecutorService executorService, CountDownLatch latch) {
            latch.countDown();
        }
    }
}
