package jp.sourceforge.nicoro;

/**
 * rational number, fraction
 */
public class Rational {
	/**
	 * numerator
	 */
	public int num;
	/**
	 * denominator
	 */
	public int den;
	
	public Rational() {
		num = 0;
		den = 1;
	}
	
	public Rational(int n, int d) {
		num = n;
		den = d;
	}
	
	public float getDivideFloat() {
		return (float) num / (float) den;
	}
	public int getDivideInt() {
		return num / den;
	}
	
	/**
	 * 分数が秒を表しているものとして、ミリ秒単位に変換して取得
	 * @return
	 */
	public int getMs() {
		return (int) ((long) num * 1000L / den);
	}

	/**
	 * 分数が秒を表しているものとして、10ミリ秒単位に変換して取得
	 * @return
	 */
	public int getVpos() {
		return (int) ((long) num * 100L / den);
	}
}
