package jp.sourceforge.nicoro;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import android.app.Activity;
import android.os.Bundle;
import android.webkit.WebView;

import static jp.sourceforge.nicoro.Log.LOG_TAG;;

public class NicoroHelp extends Activity {
	
	WebView mWebView;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		mWebView = new WebView(this);	// use Activity context
		setContentView(mWebView);
		InputStream in = null;
		InputStreamReader reader = null;
		try {
			in = getAssets().open("help.html");
			reader = new InputStreamReader(in, "utf-8");
			char[] buffer = new char[8192];
			StringBuilder builder = new StringBuilder(8192);
			while (true) {
				int readSize = reader.read(buffer);
				if (readSize < 0) {
					break;
				}
				builder.append(buffer, 0, readSize);
			}
			mWebView.loadDataWithBaseURL(
					"file:///android_asset/",
					builder.toString(),
					"text/html",
					"utf-8",
					null);
		} catch (IOException e) {
			Log.w(LOG_TAG, e.getMessage(), e);
		} finally {
			if (in != null) {
				try {
					reader.close();
				} catch (IOException e) {
					Log.d(LOG_TAG, e.getMessage(), e);
				}
				try {
					in.close();
				} catch (IOException e) {
					Log.d(LOG_TAG, e.getMessage(), e);
				}
			}
		}
		
	}
	
}
