package jp.sourceforge.nicoro;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

import static jp.sourceforge.nicoro.Log.LOG_TAG;;

public class NicoroAPIManager {
	private static final boolean DEBUG_LOGV = Release.IS_DEBUG && false;
	private static final boolean DEBUG_LOGD = Release.IS_DEBUG && true;
	
	public static class ParseGetFLV {
		public static final String PATTERN_THREAD_ID = "thread_id=(.+?)&";
		public static final String PATTERN_URL = "&url=http://(.+?)(/.+?)&";
		public static final String PATTERN_MS = "&ms=http://(.+?)(/.+?)&";
		public static final String HOSTNAME = "www.nicovideo.jp";
		
		public String threadId;
		public String url;
		public String ms;
		
		public void initialize(DefaultHttpClient httpClient, String videoNumber,
				String cookie, String userAgent) throws ClientProtocolException, IOException {
			String infoBody = getGetflvResult(httpClient,
					createUri(videoNumber), cookie, userAgent);
			initialize(infoBody);
		}
		
		private void initialize(String infoBody) {
			url = getVideoUrl(infoBody);
			ms = getMessageUrl(infoBody);
			threadId = getThreadId(infoBody);
		}
		
		private static String createUri(String videoNumber) {
			return "/api/getflv?v=" + videoNumber;
		}
		
		private static String getGetflvResult(DefaultHttpClient httpClient,
				String uri, String cookie, String userAgent)
		throws ClientProtocolException, IOException {
			String result = Util.getSingleLineDataFromAPI(httpClient,
					ParseGetFLV.HOSTNAME, uri, cookie, userAgent);
			return result;
		}
		
		private static String getVideoUrl(String infoBody) {
			if (infoBody != null) {
				Matcher matcher = Pattern.compile(ParseGetFLV.PATTERN_URL).matcher(infoBody);
				if (matcher.find()) {
					String url = "http://" + matcher.group(1) + matcher.group(2);
					if (url.indexOf("?s=") >= 0) {
						// swfはURL調整
						url += "as3";
					}
					if (DEBUG_LOGV) {
						Log.v(LOG_TAG, url);
					}
					
					// テスト：エコノミー
//					urlVideo += "low";
					
					return url;
				}
			}
			return null;
		}
		
		private static String getMessageUrl(String infoBody) {
			if (infoBody != null) {
				Matcher matcher = Pattern.compile(ParseGetFLV.PATTERN_MS).matcher(infoBody);
				if (matcher.find()) {
					String url = "http://" + matcher.group(1) + matcher.group(2);
					if (DEBUG_LOGV) {
						Log.v(LOG_TAG, url);
					}
					return url;
				}
			}
			return null;
		}
		
		private static String getThreadId(String infoBody) {
			if (infoBody != null) {
				String threadId = Util.getFirstMatch(infoBody, ParseGetFLV.PATTERN_THREAD_ID);
				if (DEBUG_LOGV) {
					Log.v(LOG_TAG, threadId);
				}
				return threadId;
			}
			return null;
		}
	}

	public static class ParseGetThreadKey {
		public static final String PATTERN_THREADKEY = "threadkey=(.+?)&";
		public static final String PATTERN_FORCE_184 = "&force_184=(.+)";
		public static final String HOSTNAME = "flapi.nicovideo.jp";
		
		public String threadKey;
		public String force184;
		
		public void initialize(DefaultHttpClient httpClient, String threadId,
				String cookie, String userAgent) throws ClientProtocolException, IOException {
			String threadKeyBody = getThreadKeyResult(
					httpClient, createUri(threadId), cookie, userAgent);
			initialize(threadKeyBody);
		}
		
		private void initialize(String threadKeyBody) {
			threadKey = getThreadKey(threadKeyBody);
			force184 = getForce184(threadKeyBody);
		}
		
		private static String createUri(String threadId) {
			return "/api/getthreadkey?thread=" + threadId;
		}
		
		private static String getThreadKeyResult(DefaultHttpClient httpClient,
				String uri, String cookie, String userAgent)
		throws ClientProtocolException, IOException {
			String result = Util.getSingleLineDataFromAPI(httpClient,
					ParseGetThreadKey.HOSTNAME, uri, cookie, userAgent);
			return result;
		}
		
		private static String getThreadKey(String threadKeyBody) {
			if (threadKeyBody != null) {
				String threadKey = Util.getFirstMatch(threadKeyBody, ParseGetThreadKey.PATTERN_THREADKEY);
				if (DEBUG_LOGV) {
					Log.v(LOG_TAG, threadKey);
				}
				return threadKey;
			}
			return null;
		}

		private static String getForce184(String threadKeyBody) {
			if (threadKeyBody != null) {
				String force184 = Util.getFirstMatch(threadKeyBody, ParseGetThreadKey.PATTERN_FORCE_184);
				if (DEBUG_LOGV) {
					Log.v(LOG_TAG, force184);
				}
				return force184;
			}
			return null;
		}
	}
	
	public String getAuthorizeCookie(DefaultHttpClient httpClient, String userAgent) throws ClientProtocolException, IOException {
		HttpPost httpRequest = new HttpPost("/secure/login?site=niconico");
		List<BasicNameValuePair> postParams = new ArrayList<BasicNameValuePair>();
//		postParams.add(new BasicNameValuePair("next_url", ""));
		postParams.add(new BasicNameValuePair("mail", ""));
		postParams.add(new BasicNameValuePair("password", ""));
		httpRequest.setEntity(new UrlEncodedFormEntity(postParams, HTTP.UTF_8));
		if (userAgent != null) {
			httpRequest.setHeader("User-Agent", userAgent);
		}
		
		HttpResponse httpResponse = httpClient.execute(new HttpHost("secure.nicovideo.jp", 443, "https"), httpRequest);
		
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "getAuthorizeCookie httpResponse>");
			Util.logHeaders(LOG_TAG, httpResponse.getAllHeaders());
		}
		if (httpResponse.getStatusLine().getStatusCode() != HttpStatus.SC_OK) {
			return null;
		}
		
		List<Cookie> cookies = httpClient.getCookieStore().getCookies();
		StringBuilder cookieAuthorize = new StringBuilder(64);
		boolean first = true;
		for (Cookie c : cookies) {
			if (first) {
				first = false;
			} else {
				cookieAuthorize.append("; ");
			}
			if (DEBUG_LOGD) {
				Log.d(LOG_TAG, Log.buf().append(c.getName()).append("=").append(c.getValue()).toString());
			}
			cookieAuthorize.append(c.getName()).append("=").append(c.getValue());
		}
		return cookieAuthorize.toString();
	}
	
	public String getVideoCookie(DefaultHttpClient httpClient, String uri, String cookie, String userAgent) throws ClientProtocolException, IOException {
		HttpRequest httpRequest = new HttpHead(uri);
		httpRequest.addHeader("Cookie", cookie);
		if (userAgent != null) {
			httpRequest.setHeader("User-Agent", userAgent);
		}
		HttpResponse httpResponse = httpClient.execute(
				new HttpHost("www.nicovideo.jp", 80),
				httpRequest
				);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "getVideoCookie httpResponse>>>");
			Util.logHeaders(LOG_TAG, httpResponse.getAllHeaders());
			Log.d(LOG_TAG, "<<< httpResponse end");
		}
		StringBuilder cookieVideo = new StringBuilder(64);
		if (httpResponse.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
			List<Cookie> cookies = httpClient.getCookieStore().getCookies();
			boolean first = true;
			for (Cookie c : cookies) {
				if (first) {
					first = false;
				} else {
					cookieVideo.append("; ");
				}
				if (DEBUG_LOGD) {
					Log.d(LOG_TAG, Log.buf().append(c.getName())
							.append("=").append(c.getValue()).toString());
				}
				cookieVideo.append(c.getName()).append("=").append(c.getValue());
			}
		
		}
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf().append("getVideoCookie: ")
					.append(cookieVideo).toString());
		}
		return cookieVideo.toString();
	}
	
	public static boolean checkIsCookieUserSessionValid(String cookieUserSession, String userAgent) {
		if (cookieUserSession == null || cookieUserSession.length() == 0) {
			return false;
		}
		
		HttpUriRequest httpRequest = new HttpHead("http://www.nicovideo.jp/");
		httpRequest.addHeader("Cookie", cookieUserSession);
		if (userAgent != null) {
			httpRequest.setHeader("User-Agent", userAgent);
		}
		if (DEBUG_LOGD) {
			Util.logHeaders(LOG_TAG, httpRequest.getAllHeaders());
		}
		
		DefaultHttpClient httpClient = Util.createHttpClient();
		httpClient.getCookieStore().clear();
		try {
			HttpResponse httpResponse = httpClient.execute(
					httpRequest
					);
			if (DEBUG_LOGD) {
				Log.d(LOG_TAG, httpResponse.getStatusLine().getReasonPhrase());
				Util.logHeaders(LOG_TAG, httpResponse.getAllHeaders());
			}
			
			int httpStatusCode = httpResponse.getStatusLine().getStatusCode();
			if (httpStatusCode != HttpStatus.SC_OK) {
				return false;
			}
			
			return checkNiconicoAuthflag(httpResponse);
		} catch (ClientProtocolException e) {
			Log.d(LOG_TAG, e.getMessage(), e);
			return false;
		} catch (IOException e) {
			Log.d(LOG_TAG, e.getMessage(), e);
			return false;
		} catch (NumberFormatException e) {
			Log.d(LOG_TAG, e.getMessage(), e);
			return false;
		}
	}
	
	public static boolean checkNiconicoAuthflag(HttpResponse httpResponse) {
		Header authflag = httpResponse.getFirstHeader("x-niconico-authflag");
		if (authflag == null) {
			return false;
		}
		try {
			return Integer.parseInt(authflag.getValue()) != 0;
		} catch (NumberFormatException e) {
			return false;
		}
	}
	
	public static Intent createVideoPlayerIntent(Context context,
			String videoNumber, String cookieUserSession,
			String cookieNicoHistory, String userId,
			String userAgent)
	throws FailPreparePlayVideoException {
		try {
			DefaultHttpClient httpClient = Util.createHttpClient();
			httpClient.getCookieStore().clear();
			ParseGetFLV parseGetFLV = new ParseGetFLV();
			parseGetFLV.initialize(httpClient, videoNumber,
					cookieUserSession, userAgent);
			ParseGetThreadKey parseGetThreadKey = new ParseGetThreadKey();
			parseGetThreadKey.initialize(httpClient,
					parseGetFLV.threadId, cookieUserSession, userAgent);
			
			if (parseGetFLV.url == null
					|| parseGetFLV.ms == null
					|| parseGetFLV.threadId == null) {
				throw new FailPreparePlayVideoException();
			}
			
			Class<?> activityClass = null;
			// 動画タイプチェック＆Activity選択
			if (parseGetFLV.url.indexOf("?v=") >= 0) {
				// flv
				activityClass = NicoroFFmpegPlayer.class;
			} else if (parseGetFLV.url.indexOf("?m=") >= 0) {
				// mp4
				SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(context);
				if (sharedPreferences.getBoolean(
						context.getString(R.string.pref_key_mp4_mediaplayer), true)) {
					activityClass = NicoroMediaPlayer.class;
				} else {
					activityClass = NicoroFFmpegPlayer.class;
				}
			} else if (parseGetFLV.url.indexOf("?s=") >= 0) {
				// swf
//				// 未対応
//				Log.w(LOG_TAG, "SWF is unsupported");
//				FailPreparePlayVideoException e = new FailPreparePlayVideoException();
//				e.setExtraMessage("swf形式は未対応です");
//				throw e;
				activityClass = NicoroSwfPlayer.class;
			} else {
				// 想定外
				Log.w(LOG_TAG, Log.buf().append("Unrecognized video URL:")
						.append(parseGetFLV.url).toString());
				// とりあえずデフォルトで起動を試みる
				activityClass = NicoroFFmpegPlayer.class;
			}
			
			if (activityClass != null) {
				Intent intent = new Intent(context, activityClass);
				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_VIDEO_URL, parseGetFLV.url);
				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_COOKIE, cookieNicoHistory);
				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_VIDEO_NUMBER, videoNumber);
				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_MESSAGE_URL, parseGetFLV.ms);
				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_THREAD_ID, parseGetFLV.threadId);
				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_USER_ID, userId);
				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_THREAD_KEY, parseGetThreadKey.threadKey);
				intent.putExtra(AbstractNicoroPlayer.INTENT_NAME_FORCE_184, parseGetThreadKey.force184);
				return intent;
			}
		} catch (ClientProtocolException e) {
			Log.d(LOG_TAG, e.getMessage(), e);
		} catch (IOException e) {
			Log.d(LOG_TAG, e.getMessage(), e);
		}
		return null;
	}

	public static String getCookieNicoHistory(DefaultHttpClient httpClient,
			String videoNumber, String cookieUserSession, String userAgent)
	throws ClientProtocolException, IOException {
		HttpRequest httpRequest = new HttpHead("/watch/" + videoNumber);
//		HttpRequest httpRequest = new HttpGet("/watch/" + videoNumber);
		httpRequest.addHeader("Cookie", cookieUserSession);
		if (userAgent != null) {
			httpRequest.setHeader("User-Agent", userAgent);
		}
		HttpResponse httpResponse = httpClient.execute(
				new HttpHost("www.nicovideo.jp", 80),
				httpRequest
				);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "==========getCookieNicoHistory httpResponse==========");
			Util.logHeaders(LOG_TAG, httpResponse.getAllHeaders());
			Log.d(LOG_TAG, "==========httpResponse end==========");
		}
		String cookieVideo = null;
		if (httpResponse.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
			List<Cookie> cookies = httpClient.getCookieStore().getCookies();
			for (Cookie c : cookies) {
				if ("nicohistory".equals(c.getName())) {
					cookieVideo = c.getName() + "=" + c.getValue();
					break;
				}
			}
		}
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, Log.buf().append("getCookieNicoHistory: ")
					.append(cookieVideo).toString());
		}
		return cookieVideo;
	}
}
