package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGV;
import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.SwfLog.LOG_TAG;
import jp.sourceforge.nicoro.FailAnalyzeSwfException;
import android.util.Log;

public class SoundStreamHead {
	public static final int SOUNDRATE_5_5 = 0;
	public static final int SOUNDRATE_11 = 1;
	public static final int SOUNDRATE_22 = 2;
	public static final int SOUNDRATE_44 = 3;
	
	public static final int SOUNDTYPE_MONO = 0;
	public static final int SOUNDTYPE_STEREO = 1;
	
	public static final int SOUNDCOMPRESSION_ADPCM = 1;
	public static final int SOUNDCOMPRESSION_MP3 = 2;
	
	public byte playbackSoundRate;		// UB[2]
	public byte playbackSoundSize;		// UB{1]
	public byte playbackSoundType;		// UB[1]
	public byte streamSoundCompression;	// UB[4]
	public byte streamSoundRate;		// UB[2]
	public byte streamSoundSize;		// UB[1]
	public byte streamSoundType;		// UB[1]
	public int streamSoundSampleCount;	// UI16
	public short latencySeek;		// SI16
	
    public int readSoundStreamHead(byte[] bufferArray, int offset) {
    	SoundStreamHead soundStreamHead = this;
    	
		soundStreamHead.playbackSoundRate =
			(byte) ((bufferArray[offset + 0] >> 2) & 0x03);
		soundStreamHead.playbackSoundSize =
			(byte) ((bufferArray[offset + 0] >> 1) & 0x01);
		soundStreamHead.playbackSoundType =
			(byte) (bufferArray[offset + 0] & 0x01);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "PlaybackSoundRate=" + soundStreamHead.playbackSoundRate);
			Log.d(LOG_TAG, "PlaybackSoundSize=" + soundStreamHead.playbackSoundSize);
			Log.d(LOG_TAG, "PlaybackSoundType=" + soundStreamHead.playbackSoundType);
		}
		
		soundStreamHead.streamSoundCompression =
			(byte) ((bufferArray[offset + 1] >> 4) & 0x0f);
		soundStreamHead.streamSoundRate =
			(byte) ((bufferArray[offset + 1] >> 2) & 0x03);
		soundStreamHead.streamSoundSize =
			(byte) ((bufferArray[offset + 1] >> 1) & 0x01);
		soundStreamHead.streamSoundType =
			(byte) (bufferArray[offset + 1] & 0x01);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "StreamSoundCompression=" + soundStreamHead.streamSoundCompression);
			Log.d(LOG_TAG, "StreamSoundRate=" + soundStreamHead.streamSoundRate);
			Log.d(LOG_TAG, "StreamSoundSize=" + soundStreamHead.streamSoundSize);
			Log.d(LOG_TAG, "StreamSoundType=" + soundStreamHead.streamSoundType);
		}
		
		soundStreamHead.streamSoundSampleCount =
			(bufferArray[offset + 2] & 0xff) | ((bufferArray[offset + 3] & 0xff) << 8);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "StreamSoundSampleCount=" + soundStreamHead.streamSoundSampleCount);
		}
		
		if (soundStreamHead.streamSoundCompression == SoundStreamHead.SOUNDCOMPRESSION_MP3) {
    		soundStreamHead.latencySeek =
    			(short) ((bufferArray[offset + 4] & 0xff) | ((bufferArray[offset + 5] & 0xff) << 8));
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, "LatencySeek=" + soundStreamHead.latencySeek);
    		}
		}
		
//		// test
//		try {
//			mTestOutMP3 = new FileOutputStream("/sdcard/NicoRo/test.mp3");
//		} catch (FileNotFoundException e) {
//			// TODO 自動生成された catch ブロック
//			e.printStackTrace();
//		}
    	
    	return offset + 6;
    }
    
    public StreamSoundDataBase createStreamSoundData() throws FailAnalyzeSwfException {
    	if (streamSoundCompression == SoundStreamHead.SOUNDCOMPRESSION_ADPCM) {
    		return new ADPCMSOUNDDATA();
    	} else if (streamSoundCompression == SoundStreamHead.SOUNDCOMPRESSION_MP3) {
    		return new MP3STREAMSOUNDDATA();
    	} else {
    		throw new FailAnalyzeSwfException("not supported StreamSoundCompression=" + streamSoundCompression);
    	}
    }
}
