package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGV;
import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.SwfLog.LOG_TAG;
import java.util.ArrayList;

import jp.sourceforge.nicoro.FailAnalyzeSwfException;
import android.util.Log;

public class SHAPEWITHSTYLE {
	public FILLSTYLEARRAY fillStyles = new FILLSTYLEARRAY();
	public LINESTYLEARRAY lineStyles = new LINESTYLEARRAY();
	public byte numFillBits;		// UB[4]
	public byte numLineBits;		// UB[4]
	public ArrayList<SHAPERECORD> shapeRecords = new ArrayList<SHAPERECORD>(1);

    public int read(byte[] bufferArray, int offset, int tagType) throws FailAnalyzeSwfException {
    	SHAPEWITHSTYLE shapeWithStyle = this;
    	
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "readSHAPEWITHSTYLE: offset=" + offset);
		}
		
		int offsetLineStyles = shapeWithStyle.fillStyles.read(bufferArray, offset, tagType);
		int offsetNumFillBits = shapeWithStyle.lineStyles.read(bufferArray, offsetLineStyles, tagType);
		shapeWithStyle.numFillBits = (byte) ((bufferArray[offsetNumFillBits] >> 4) & 0x0f);
		shapeWithStyle.numLineBits = (byte) (bufferArray[offsetNumFillBits] & 0x0f);
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, "NumFillBits=" + shapeWithStyle.numFillBits);
    		Log.d(LOG_TAG, "NumLineBits=" + shapeWithStyle.numLineBits);
    	}
		
		return SwfPlayer.readSHAPERECORDs(shapeWithStyle.shapeRecords,
				shapeWithStyle.numFillBits, shapeWithStyle.numLineBits,
				bufferArray, offsetNumFillBits + 1, tagType);
    }
    
}
