package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGV;
import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.SwfLog.LOG_TAG;

import java.io.IOException;
import java.io.OutputStream;

import android.util.Log;

public class MP3STREAMSOUNDDATA extends StreamSoundDataBase {
	public int sampleCount;		// UI16
	// MP3SOUNDDATA
	public short seekSamples;	// SI16
	public byte[] mp3Frames;	// MP3FRAME[zero or more]

	@Override
    public int read(byte[] bufferArray, int offset) {
		MP3STREAMSOUNDDATA mp3 = this;
    	
		int offsetNext = offset;
		mp3.sampleCount = (bufferArray[offsetNext + 0] & 0xff) | ((bufferArray[offsetNext + 1] & 0xff) << 8);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "SampleCount=" + mp3.sampleCount);
		}
		offsetNext += 2;
		
		mp3.seekSamples = (short) ((bufferArray[offsetNext + 0] & 0xff) | (bufferArray[offsetNext + 1] << 8));
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "SeekSamples=" + mp3.seekSamples);
		}
		offsetNext += 2;
		
		mp3.mp3Frames = new byte[bufferArray.length - offsetNext];
		System.arraycopy(bufferArray, offsetNext, mp3.mp3Frames, 0, mp3.mp3Frames.length);
		offsetNext = bufferArray.length;

		mp3.readOffset = 0;
		
		return offsetNext;
    }
	
	@Override
    public void writeData(OutputStream out) throws IOException {
		out.write(mp3Frames);
	}
}
