/**
 * 
 */
package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGV;
import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.SwfLog.LOG_TAG;
import jp.sourceforge.nicoro.BinUtil;
import android.graphics.Matrix;
import android.util.Log;

public class MATRIX {
	public boolean hasScale;		// UB[1]
	public byte nScaleBits;			// UB[5]
	public int scaleX;				// FB[NScaleBits] 最長31bit
	public int scaleY;				// FB[NScaleBits] 最長31bit
	public boolean hasRotate;		// UB[1]
	public byte nRotateBits;		// UB[5]
	public int rotateSkew0;			// FB[NRotateBits] 最長31bit
	public int rotateSkew1;			// FB[NRotateBits] 最長31bit
	public byte nTranslateBits;		// UB[5]
	public int translateX;			// SB[NTranslateBits] 最長31bit
	public int translateY;			// SB[NTranslateBits] 最長31bit
	
    public int read(byte[] bufferArray, int offset) {
    	MATRIX matrix = this;
    	
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "readMATRIX: offset=" + offset);
		}
    	matrix.hasScale = BinUtil.getBitFlag(bufferArray, offset * 8 + 0);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "HasScale=" + matrix.hasScale);
		}
		final int nextRotateOffsetBits;
    	if (matrix.hasScale) {
    		matrix.nScaleBits = (byte) ((bufferArray[offset] >> 2) & 0x1f);
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, "NScaleBits=" + matrix.nScaleBits);
    		}
    		byte[] binary = BinUtil.toBinaryFromBytes(bufferArray, offset * 8 + 6, matrix.nScaleBits * 2);
    		matrix.scaleX = BinUtil.toSIntFromBinary(binary, 0, matrix.nScaleBits);
    		matrix.scaleY = BinUtil.toSIntFromBinary(binary, matrix.nScaleBits, matrix.nScaleBits);
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, "ScaleX=" + (matrix.scaleX >> 16) + "." + (matrix.scaleX & 0xffff));
    			Log.d(LOG_TAG, "ScaleY=" + (matrix.scaleY >> 16) + "." + (matrix.scaleY & 0xffff));
    		}
    		nextRotateOffsetBits = 1 + 5 + matrix.nScaleBits * 2;
    	} else {
    		nextRotateOffsetBits = 1;
    	}
    	
    	matrix.hasRotate = BinUtil.getBitFlag(bufferArray, offset * 8 + nextRotateOffsetBits);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "HasRotate=" + matrix.hasRotate);
		}
		final int nextTranslateOffsetBits;
		if (matrix.hasRotate) {
			byte[] binary = BinUtil.toBinaryFromBytes(bufferArray, offset * 8 + nextRotateOffsetBits + 1, 5);
			matrix.nRotateBits = BinUtil.toByteFromBinary(binary, 0, 5);
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, "NRotateBits=" + matrix.nRotateBits);
    		}
    		binary = BinUtil.toBinaryFromBytes(bufferArray, offset * 8 + nextRotateOffsetBits + 6, matrix.nRotateBits * 2);
    		matrix.rotateSkew0 = BinUtil.toSIntFromBinary(binary, 0, matrix.nRotateBits);
    		matrix.rotateSkew1 = BinUtil.toSIntFromBinary(binary, matrix.nRotateBits, matrix.nRotateBits);
    		if (DEBUG_LOGD) {
    			Log.d(LOG_TAG, "RotateSkew0=" + (matrix.rotateSkew0 >> 16) + "." + (matrix.rotateSkew0 & 0xffff));
    			Log.d(LOG_TAG, "RotateSkew1=" + (matrix.rotateSkew1 >> 16) + "." + (matrix.rotateSkew1 & 0xffff));
    		}
    		nextTranslateOffsetBits = nextRotateOffsetBits + 1 + 5 + matrix.nRotateBits * 2;
		} else {
			nextTranslateOffsetBits = nextRotateOffsetBits + 1;
		}
    	
		byte[] binary = BinUtil.toBinaryFromBytes(bufferArray, offset * 8 + nextTranslateOffsetBits, 5);
		matrix.nTranslateBits = BinUtil.toByteFromBinary(binary, 0, 5);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "NTranslateBits=" + matrix.nTranslateBits);
		}
		binary = BinUtil.toBinaryFromBytes(bufferArray, offset * 8 + nextTranslateOffsetBits + 5, matrix.nTranslateBits * 2);
		matrix.translateX = BinUtil.toSIntFromBinary(binary, 0, matrix.nTranslateBits);
		matrix.translateY = BinUtil.toSIntFromBinary(binary, matrix.nTranslateBits, matrix.nTranslateBits);
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "TranslateX=" + matrix.translateX);
			Log.d(LOG_TAG, "TranslateY=" + matrix.translateY);
		}
    	
    	return offset + (nextTranslateOffsetBits + 5 + matrix.nTranslateBits * 2 + 7) / 8;
    }

	public void toMatrix(Matrix to) {
		MATRIX from = this;
		
		to.reset();
		if (from.hasScale) {
			to.postScale(
					(float) from.scaleX / 65536.0f,
					(float) from.scaleY / 65536.0f);
		}
		
		if (from.hasRotate) {
			to.postSkew(
					(float) from.rotateSkew0 / 65536.0f,
					(float) from.rotateSkew1 / 65536.0f);
		}
	
		to.postTranslate(
				(float) from.translateX,
				(float) from.translateY);
	}

}