package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGV;
import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.SwfLog.LOG_TAG;
import android.graphics.Color;
import android.util.Log;

public class LINESTYLE {
	public int width;		// UI16
	public int color;		// RGB (Shape1 or Shape2), RGBA (Shape3)

    public int read(byte[] bufferArray, int offset, int tagType) {
    	LINESTYLE lineStyle = this;
    	
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "readLINESTYLE: offset=" + offset);
		}
		
		lineStyle.width = 
			((bufferArray[offset + 0] & 0xff) | ((bufferArray[offset + 1] & 0xff) << 8));
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, "Width=" + lineStyle.width);
    	}
    	
    	int offsetNext = offset + 2;
		switch (tagType) {
		case RECORDHEADER.SWFTAG_DEFINESHAPE:
		case RECORDHEADER.SWFTAG_DEFINESHAPE2:
			lineStyle.color = Color.rgb(
					bufferArray[offsetNext + 0],
					bufferArray[offsetNext + 1],
					bufferArray[offsetNext + 2]);
			offsetNext += 3;
			break;
		case RECORDHEADER.SWFTAG_DEFINESHAPE3:
			lineStyle.color = Color.argb(
					bufferArray[offsetNext + 3],
					bufferArray[offsetNext + 0],
					bufferArray[offsetNext + 1],
					bufferArray[offsetNext + 2]);
			offsetNext += 4;
			break;
		default:
			Log.w(LOG_TAG, "LINESTYLE: record tag type mismatch=" + tagType);
			break;
		}
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, "Color=" + Integer.toHexString(lineStyle.color));
    	}
		
		return offsetNext;
    }
    
}
