package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGV;
import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.SwfLog.LOG_TAG;
import android.util.Log;

public class GRADIENT {
	public byte spreadMode;		// UB[2]
	public byte interpolationMode;	// UB[2]
	public byte numGradients;		// UB[4]
	public GRADRECORD[] gradientRecords;	// 最大15個

    public int read(byte[] bufferArray, int offset, int tagType) {
    	GRADIENT gradient = this;
    	
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "readGRADIENT: offset=" + offset);
		}
		
		byte b = bufferArray[offset];
		gradient.spreadMode = (byte) ((b >> 6) & 0x03);
		gradient.interpolationMode = (byte) ((b >> 4) & 0x03);
		gradient.numGradients = (byte) (b & 0x0f);
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, "SpreadMode=" + gradient.spreadMode);
    		Log.d(LOG_TAG, "InterpolationMode=" + gradient.interpolationMode);
    		Log.d(LOG_TAG, "NumGradients=" + gradient.numGradients);
    	}
    	int offsetNext = offset + 1;
    	gradient.gradientRecords = new GRADRECORD[gradient.numGradients];
    	for (int i = 0; i < gradient.numGradients; ++i) {
    		GRADRECORD gradRecord = new GRADRECORD();
    		offsetNext = gradRecord.read(bufferArray, offsetNext, tagType);
    		gradient.gradientRecords[i] = gradRecord;
    	}
		
		return offsetNext;
    }

}
