package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGV;
import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.SwfLog.LOG_TAG;
import android.util.Log;

public class FOCALGRADIENT extends GRADIENT {
	public short focalPoint;	// FIXED8

	@Override
    public int read(byte[] bufferArray, int offset, int tagType) {
    	FOCALGRADIENT focalGradient = this;
    	
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "readFOCALGRADIENT: offset=" + offset);
		}
		
		int offsetNext = super.read(bufferArray, offset, tagType);
		focalGradient.focalPoint = (short) ((bufferArray[offsetNext + 0] & 0xff) | ((bufferArray[offsetNext + 1] & 0xff) << 8));
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, "FocalPoint=" + focalGradient.focalPoint);
    	}
		offsetNext += 2;
		return offsetNext;
    }

}
