package jp.sourceforge.nicoro.swf;

import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGV;
import static jp.sourceforge.nicoro.swf.SwfLog.DEBUG_LOGD;
import static jp.sourceforge.nicoro.swf.SwfLog.LOG_TAG;
import android.util.Log;

public class FILLSTYLEARRAY {
	public short fillStyleCount;		// UI8
	public int fillStyleCountExtended;	// UI16
	public FILLSTYLE[] fillStyles;
	
    public int read(byte[] bufferArray, int offset, int tagType) {
    	FILLSTYLEARRAY fillStyleArray = this;
    	
		if (DEBUG_LOGD) {
			Log.d(LOG_TAG, "readFILLSTYLEARRAY: offset=" + offset);
		}
		
    	int fillStyleCount;
    	int offsetFillStyles;
    	fillStyleArray.fillStyleCount = (short) (bufferArray[offset] & 0xff);
    	if (DEBUG_LOGD) {
    		Log.d(LOG_TAG, "FillStyleCount=" + fillStyleArray.fillStyleCount);
    	}
    	if (fillStyleArray.fillStyleCount == 0xff) {
    		fillStyleArray.fillStyleCountExtended =
    			((bufferArray[offset + 1] & 0xff) | ((bufferArray[offset + 2] & 0xff) << 8));
        	if (DEBUG_LOGD) {
        		Log.d(LOG_TAG, "FillStyleCountExtended=" + fillStyleArray.fillStyleCountExtended);
        	}
    		fillStyleCount = fillStyleArray.fillStyleCountExtended;
    		offsetFillStyles = offset + 1 + 2;
    	} else {
    		fillStyleCount = fillStyleArray.fillStyleCount;
    		offsetFillStyles = offset + 1;
    	}
    	
    	fillStyleArray.fillStyles = new FILLSTYLE[fillStyleCount];
    	for (int i = 0; i < fillStyleCount; ++i) {
    		FILLSTYLE fillStyle = new FILLSTYLE();
    		offsetFillStyles = fillStyle.read(bufferArray, offsetFillStyles, tagType);
    		fillStyleArray.fillStyles[i] = fillStyle;
    	}
    	
    	return offsetFillStyles;
    }
    
}
