package jp.sourceforge.nicoro;

import android.app.Instrumentation;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.test.ActivityUnitTestCase;
import android.view.View;

public class MainFragmentActivityUnitTests extends ActivityUnitTestCase<MainFragmentActivity> {
    private Instrumentation mInstr;
    private Context mContext;

    public MainFragmentActivityUnitTests() throws ClassNotFoundException {
        super(MainFragmentActivity.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        mInstr = getInstrumentation();
        mContext = mInstr.getTargetContext();
    }

    @Override
    protected void tearDown() throws Exception {
        mInstr = null;
        mContext = null;
        super.tearDown();
    }

    public void testOnCreate() throws Exception {
        MainFragmentActivity activity = startMainFragmentActivity(null);

        boolean isDualPane = activity.isDualPane();
        boolean showListMenuInDualPane = activity.showListMenuInDualPane();
        View viewPaneListMenu = activity.findViewById(
                jp.sourceforge.nicoro.R.id.pane_listmenu);
        int viewPaneListMenuVisibility = viewPaneListMenu.getVisibility();

        if (isDualPaneAsTest(activity)) {
            assertTrue(isDualPane);
            assertTrue(showListMenuInDualPane);
            assertEquals(View.VISIBLE, viewPaneListMenuVisibility);
        } else {
            assertFalse(isDualPane);
            assertFalse(showListMenuInDualPane);
            assertEquals(View.GONE, viewPaneListMenuVisibility);
        }

        mInstr.callActivityOnStart(activity);
        mInstr.callActivityOnResume(activity);
        mInstr.callActivityOnPause(activity);
        mInstr.callActivityOnStop(activity);
        mInstr.callActivityOnDestroy(activity);
    }

    public void testOnCreateSavedInstanceStateEmpty() throws Exception {
        Bundle savedInstanceState = new Bundle();
        MainFragmentActivity activity = startMainFragmentActivity(savedInstanceState);

        boolean isDualPane = activity.isDualPane();
        boolean showListMenuInDualPane = activity.showListMenuInDualPane();
        View viewPaneListMenu = activity.findViewById(
                jp.sourceforge.nicoro.R.id.pane_listmenu);
        int viewPaneListMenuVisibility = viewPaneListMenu.getVisibility();

        if (isDualPaneAsTest(activity)) {
            assertTrue(isDualPane);
            assertTrue(showListMenuInDualPane);
            assertEquals(View.VISIBLE, viewPaneListMenuVisibility);
        } else {
            assertFalse(isDualPane);
            assertFalse(showListMenuInDualPane);
            assertEquals(View.GONE, viewPaneListMenuVisibility);
        }

        mInstr.callActivityOnStart(activity);
        mInstr.callActivityOnResume(activity);
        mInstr.callActivityOnPause(activity);
        mInstr.callActivityOnStop(activity);
        mInstr.callActivityOnDestroy(activity);
    }

    public void testOnCreateSavedInstanceStateShowListMenuInDualPaneTrue() throws Exception {
        Bundle savedInstanceState = new Bundle();
        savedInstanceState.putBoolean(
                MainFragmentActivity.KEY_SHOW_LIST_MENU_IN_DUAL_PANE, true);
        MainFragmentActivity activity = startMainFragmentActivity(savedInstanceState);

        boolean isDualPane = activity.isDualPane();
        boolean showListMenuInDualPane = activity.showListMenuInDualPane();
        View viewPaneListMenu = activity.findViewById(
                jp.sourceforge.nicoro.R.id.pane_listmenu);
        int viewPaneListMenuVisibility = viewPaneListMenu.getVisibility();

        if (isDualPaneAsTest(activity)) {
            assertTrue(isDualPane);
            assertTrue(showListMenuInDualPane);
            assertEquals(View.VISIBLE, viewPaneListMenuVisibility);
        } else {
            assertFalse(isDualPane);
            assertTrue(showListMenuInDualPane);
            assertEquals(View.VISIBLE, viewPaneListMenuVisibility);
        }

        mInstr.callActivityOnStart(activity);
        mInstr.callActivityOnResume(activity);
        mInstr.callActivityOnPause(activity);
        mInstr.callActivityOnStop(activity);
        mInstr.callActivityOnDestroy(activity);
    }

    public void testOnCreateSavedInstanceStateShowListMenuInDualPaneFalse() throws Exception {
        Bundle savedInstanceState = new Bundle();
        savedInstanceState.putBoolean(
                MainFragmentActivity.KEY_SHOW_LIST_MENU_IN_DUAL_PANE, false);
        MainFragmentActivity activity = startMainFragmentActivity(savedInstanceState);

        boolean isDualPane = activity.isDualPane();
        boolean showListMenuInDualPane = activity.showListMenuInDualPane();
        View viewPaneListMenu = activity.findViewById(
                jp.sourceforge.nicoro.R.id.pane_listmenu);
        int viewPaneListMenuVisibility = viewPaneListMenu.getVisibility();

        if (isDualPaneAsTest(activity)) {
            assertTrue(isDualPane);
            assertFalse(showListMenuInDualPane);
            assertEquals(View.GONE, viewPaneListMenuVisibility);
        } else {
            assertFalse(isDualPane);
            assertFalse(showListMenuInDualPane);
            assertEquals(View.GONE, viewPaneListMenuVisibility);
        }

        mInstr.callActivityOnStart(activity);
        mInstr.callActivityOnResume(activity);
        mInstr.callActivityOnPause(activity);
        mInstr.callActivityOnStop(activity);
        mInstr.callActivityOnDestroy(activity);
    }

    private MainFragmentActivity startMainFragmentActivity(
            Bundle savedInstanceState) throws Exception {
        NicoroApplication application = (NicoroApplication) Instrumentation.newApplication(
                NicoroApplication.class, mContext);
        setApplication(application);
        Intent intent = new Intent(mContext, MainFragmentActivity.class);
        return startActivity(intent, savedInstanceState, null);
    }

    private boolean isDualPaneAsTest(MainFragmentActivity activity) {
        Configuration config = activity.getResources().getConfiguration();
        return ((config.orientation == Configuration.ORIENTATION_LANDSCAPE
                && ((config.screenLayout & Configuration.SCREENLAYOUT_SIZE_MASK)
                        >= Configuration.SCREENLAYOUT_SIZE_LARGE)));
    }
}
