package jp.sourceforge.nicoro;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.FragmentActivity;

public class RelatedVideoActivity extends FragmentActivity {
    public static final String INTENT_EXTRA_VIDEO_NUMBER =
        ListMenuActivity.INTENT_EXTRA_VIDEO_NUMBER;

    private static final int MSG_ID_START_BROWSER = 1;

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case MSG_ID_START_BROWSER:
                    String url = (String) msg.obj;
                    MainFragmentActivity.startBrowserActivity(
                            RelatedVideoActivity.this, url);
                    finish();
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        CallbackMessage<String, Void> callback =
            new CallbackMessage<String, Void>(mHandler, MSG_ID_START_BROWSER);
        String tag = getString(R.string.tag_related_video_fragment);
        RelatedVideoFragment fragment;
        if (savedInstanceState == null) {
            fragment = new RelatedVideoFragment();
            getSupportFragmentManager().beginTransaction().add(
                    android.R.id.content, fragment,
                    tag).commit();
        } else {
            fragment = Util.findFragmentByTag(getSupportFragmentManager(),
                    tag);
        }
        Intent intent = getIntent();
        ListMenuFragment.updateFragmentRelatedVideo(intent, fragment);
        fragment.setBrowserStarterCallback(callback);
	}
}
