package jp.sourceforge.nicoro;

import jp.sourceforge.nicoro.StaticRes.*;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;

public class NicoroWebBrowser extends FragmentActivity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        String tag = string.tag_webbrowser_fragment;
        WebBrowserFragment fragment;
        if (savedInstanceState == null) {
            fragment = new WebBrowserFragment();
            getSupportFragmentManager().beginTransaction().add(
                    android.R.id.content, fragment,
                    tag).commit();
        } else {
            fragment = Util.findFragmentByTag(getSupportFragmentManager(),
                    tag);
        }

        // TODO fragmentへの設定
        String url = MainFragmentActivity.getUrlFromIntentActionView(getIntent());
        fragment.setStartUrl(url);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        // 1.6向けなのでonKeyDownでback key監視
        // onBackPressedの活用は、API5からのため駄目
        if (keyCode == KeyEvent.KEYCODE_BACK) {
            WebBrowserFragment fragment = Util.findFragmentByTag(
                    getSupportFragmentManager(),
                    string.tag_webbrowser_fragment);
            if (fragment.goBackWebView()) {
                return true;
            }
        }
        // TODO 何故かFragmentManagerImplでIllegalStateException起きるときがある？
        return super.onKeyDown(keyCode, event);
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        setIntent(intent);
        String url = MainFragmentActivity.getUrlFromIntentActionView(intent);
        WebBrowserFragment fragment = Util.findFragmentByTag(
                getSupportFragmentManager(),
                string.tag_webbrowser_fragment);
        fragment.updateCurrentUrl(url);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // TODO Overrideいらないかどうか？
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        // TODO Overrideいらないかどうか？
        return super.onPrepareOptionsMenu(menu);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // TODO Overrideいらないかどうか？
        return false;
    }
}
