package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.preference.PreferenceManager;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.AnalogClock;
import android.widget.CompoundButton;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.ToggleButton;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import jp.sourceforge.nicoro.AbstractNicoroPlayer.MessageData;

public class NicoroLivePlayer extends Activity
        implements SurfaceVideoDrawer.DrawMessage {
    private static final boolean DEBUG_LOGV = Release.IS_DEBUG & true;
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;

    public static final String INTENT_NAME_LIVE_NUMBER = "LIVE_NUMBER";
    public static final String INTENT_NAME_TITLE = "TITLE";
    public static final String INTENT_NAME_DESCRIPTION = "DESCRIPTION";

    private static final int MSG_ID_GET_PLAYER_STATUS_SUCCEEDED = 0;
    private static final int MSG_ID_GET_PLAYER_STATUS_FAILED = 1;
    private static final int MSG_ID_SURFACE_READY = 2;
    private static final int MSG_ID_SURFACE_DESTROYED = 3;
    private static final int MSG_ID_LIVE_CONNECT_SUCCEEDED = 4;
    private static final int MSG_ID_LIVE_CONNECT_FAILED = 5;
    private static final int MSG_ID_MESSAGE_CONNECTED = 6;
    private static final int MSG_ID_MESSAGE_OCCURRED_ERROR = 7;
    private static final int MSG_ID_INFO_TIME_UPDATE = 8;
    private static final int MSG_ID_PLAY_ERROR = 9;
    private static final int MSG_ID_PLAY_FINISHED = 10;
    private static final int MSG_ID_AUTO_CLOSE = 11;

    private static final long INTERVAL_TIME_UPDATE = 100L;
    private static final long FINISH_TIMEOUT_MS = 1000L * 10L;

    private static final String WAKELOCK_TAG = "NicoroLivePlayerWakeLock";

//    private class PrepareFFmpegTask extends AsyncTask<Void, Void, Void> {
//        @Override
//        protected Void doInBackground(Void... params) {
//            // TODO
//            try {
////                mFFmpegVideoDecoder.prepareFFmpeg(false);
//                mFFmpegVideoDecoder.prepareFFmpeg(true);
//            } catch (IllegalArgumentException e) {
//                String error = e.toString();
//                Log.e(LOG_TAG, error, e);
//                Handler handler = mHandler;
//                if (handler != null) {
//                    handler.obtainMessage(MSG_ID_PLAY_ERROR,
//                            error).sendToTarget();
//                }
//            }
//            return null;
//        }
//    }

    private class AsyncDestroyTask extends AsyncTask<Void, Void, Void> {
        private ProgressDialog progressDialog;

        @Override
        protected void onPreExecute() {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                        .append("#onPreExecute").toString());
            }

            stopWakeLock();

            if (!mWasDestroyed) {
                progressDialog = Util.createProgressDialogLoading(
                        NicoroLivePlayer.this,
                        R.string.progress_finish, null);
                progressDialog.show();
            }
        }
        @Override
        protected Void doInBackground(Void... params) {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                        .append("#doInBackground").toString());
            }

            onDestroyImpl();
            synchronized (mDestroyTaskSync) {
                mAsyncDestroyTask = null;
                mDestroyTaskEnd = true;
                mDestroyTaskSync.notifyAll();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                        .append("#onPostExecute").toString());
            }

            if (mWasDestroyed) {
                onDestroyImplPost();
            }
            if (progressDialog != null) {
                progressDialog.dismiss();
            }
            finishReally();
        }

        public void timeout() {
            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                        .append("#timeout").toString());
            }

            if (progressDialog != null) {
                progressDialog.dismiss();
                progressDialog = null;
            }
        }
    }
    private AsyncDestroyTask mAsyncDestroyTask;
    private final Object mDestroyTaskSync = new Object();
    private boolean mDestroyTaskEnd;

    private SurfaceVideoDrawer mSurfaceVideoDrawer;
    /*private*/ StreamAudioPlayer mStreamAudioPlayer;
    private FFmpegVideoDecoder mFFmpegVideoDecoder;
    private LiveMessageLoader mLiveMessageLoader;
    private LiveVideoLoader mLiveVideoLoader;
    private LivePlayerStatusLoader mLivePlayerStatusLoader;
    private MessageChatController mMessageChatController = new MessageChatController();
    private MessageData mMessageData = new MessageData();

    private RelativeLayout mProgressGroup;
    private ProgressBar mProgressBar;
    private VariableLabelView mProgressTextVideo;
    private VariableLabelView mProgressTextThumbinfo;
    private VariableLabelView mProgressTextMessage;
    private VariableLabelView mProgressTextMessageFork;
    private VariableLabelView mProgressTextInner;

    private VariableLabelView mInfoCountPlay;
    private VariableLabelView mInfoCountComment;
    private VariableLabelView mInfoTitle;
    private VariableLabelView mInfoDescription;
    private VariableLabelView mInfoPlayData;
    private VariableLabelView mInfoTime;
    private VariableLabelView mInfoSheet;
    private AnalogClock mInfoClock;
    private ViewGroup mPlayerInfo;

    private ToggleButton mButtonCommentOnOff;
    private ViewGroup mPlayerController;

    private AlertDialog mErrorDialog;

    private String mLiveNumber;
    private String mCookieUserSession;
    private String mTitle;
    private String mDescription;
    private long mStartTime;
    private boolean mMessageDisable;

    private long mDeviceStartTime;
    private long mGetPlayerStatusTime;
    private long mLiveStartTime;

    private String mResInfoLivePastTime;

    private SharedPreferences mSharedPreferences;

    private PlayerInfoControllerManager mPlayerInfoControllerManager;

    private final Rational mRationalCurrentPosition = new Rational();
//    private boolean mIsRestored;
    private boolean mOnResumed;
    private boolean mWasDestroyed;
//    private boolean mFromOnPause;
    private boolean mOnRestarted;

    private volatile boolean mIsPlaying = false;
    private boolean mIsSurfaceOk;

    private int mLastOrientation;

    private PowerManager.WakeLock mWakeLock;

    @SuppressWarnings("unused")
    private Rational mRationalDebugLog = (DEBUG_LOGV | DEBUG_LOGD)
        ? new Rational() : null;

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            if (mHandler == null) {
                if (DEBUG_LOGD) {
                    Log.d(LOG_TAG, Log.buf().append("Activity was destroyed. ignore message=")
                            .append(msg.toString()).toString());
                }
                return;
            }

            if (DEBUG_LOGV) {
                Log.v(LOG_TAG, Log.buf().append("NicoroLivePlayer handleMessage: ")
                        .append(msg.toString()).toString());
            }
            switch (msg.what) {
                case MSG_ID_GET_PLAYER_STATUS_SUCCEEDED:
                    if (mOnResumed) {
                        mProgressTextThumbinfo.setText(
                                getString(R.string.progress_thumbinfo_finished));
                        mProgressTextThumbinfo.clearAnimation();

                        mDeviceStartTime = System.currentTimeMillis();
                        mGetPlayerStatusTime = mLivePlayerStatusLoader.getTime();
                        mLiveStartTime = mLivePlayerStatusLoader.getStartTime();

                        // TODO コメント数等の定期的な更新
                        // →http://watch.live.nicovideo.jp/api/heartbeat?v=（放送ID）
                        //   http://live.nicovideo.jp/api/heartbeat?v=（放送ID）

                        // TODO getplayerstatusでは文が途中で途切れる。タイトルも長ければ同様
                        String title = mTitle;
                        if (title == null) {
                            title = mLivePlayerStatusLoader.getTitle();
                        }
                        mInfoTitle.setText(title);
                        String description = mDescription;
                        if (description == null) {
                            description = mLivePlayerStatusLoader.getDescription();
                        }
                        mInfoDescription.setText(description);
                        mInfoCountPlay.getTextBuilder()
                            .append(getString(R.string.info_live_count_watch))
                            .append(mLivePlayerStatusLoader.getWatchCount());
                        mInfoCountPlay.notifyUpdateText();
                        mInfoCountComment.getTextBuilder()
                            .append(getString(R.string.info_live_count_comment))
                            .append(mLivePlayerStatusLoader.getCommentCount());
                        mInfoCountComment.notifyUpdateText();
                        mInfoSheet.setText(getString(R.string.info_live_sheet,
                                mLivePlayerStatusLoader.getRoomLabel(),
                                mLivePlayerStatusLoader.getRoomSeetNo()));


                        CallbackMessage<Void, LiveVideoLoader.ErrorCode> callbackLiveVideo =
                            new CallbackMessage<Void, LiveVideoLoader.ErrorCode>(
                                    mHandler, MSG_ID_LIVE_CONNECT_SUCCEEDED, MSG_ID_LIVE_CONNECT_FAILED);
                        String url = mLivePlayerStatusLoader.getRtmpUrl();
                        if (url == null) {
                            url = mLivePlayerStatusLoader.getContentsUrl();
                            if (url == null) {
                                // TODO 状況によってはnullになりえる？（通常動画再生指定など）
                                String errorMessage = getString(
                                        R.string.errormessage_live_unsupported);
                                showErrorDialog(errorMessage);
                                return;
                            }
                        }
    //                    url += "/" + mLiveNumber;
    //                    // TODO アクセスできないかつ端末ごとフリーズする傾向があるのでエラーで終了
    //                    if (url.indexOf("/fileorigin/") >= 0) {
    //                        showErrorDialog(getString(R.string.errormessage_live_unsupported));
    //                        return;
    //                    }

                        String extras = null;
                        String playpath = mLivePlayerStatusLoader.getContentsPlaypath();
                        if (playpath == null) {
    //                        playpath = mLivePlayerStatusLoader.getQuePlaypath();
                            playpath = mLivePlayerStatusLoader.getQueContent();
                            if (playpath == null) {
                                // TODO
                                playpath = mLiveNumber;
                            }
                        } else {
                            String contentsUrl = mLivePlayerStatusLoader.getContentsUrl();
                            if (contentsUrl != null) {
//                                extras = " subscribe=" + contentsUrl + playpath;
//                                playpath = "rtmp:" + contentsUrl + playpath;
//                                extras = " conn=S:" + contentsUrl + " conn=S:" + playpath + " conn=S:" + mLiveNumber;
//                                extras = " tcUrl=" + url;
//                                url = contentsUrl;
//                                playpath = playpath + "&" + contentsUrl + "&" + mLiveNumber;
//                                extras = " subscribe=" + "nlPlayNotice";
                                extras = " nlPlayNotice1=" + contentsUrl + " nlPlayNotice2=" + playpath;
                            }
//                            extras = " subscribe=" + playpath;
//                            playpath = mLiveNumber;
//                            extras = " subscribe=" + mLiveNumber;
//                            playpath = "rtmp:" + playpath;
//                            extras = " swfVfy=1 swfAge=0";
                        }
                        // TODO 必ずタイムシフトかどうか？
                        boolean live = (mLivePlayerStatusLoader.getArchive() == 0);
                        int start;
                        if (live) {
                            start = 0;
                        } else {
                            start = mLivePlayerStatusLoader.getQueVpos() / -100;
                        }
                        String ticket = mLivePlayerStatusLoader.getRtmpTicket();
    //                    String ticket = null;
    //                    String akamaiUser = mLivePlayerStatusLoader.getAkamaiUser();
    //                    String akamaiPassword = mLivePlayerStatusLoader.getAkamaiPassword();
    //                    String queContent = mLivePlayerStatusLoader.getQueContent();
    //                    if (queContent != null) {
    //                        extras = "conn=NS:sendFileRequest:" + queContent;
    //                    }
//                        extras = " token=" + ticket;
                        mLiveVideoLoader.startConnect(url, ticket, playpath, live, start,
                                mLiveNumber,
    //                            akamaiUser, akamaiPassword,
                                extras,
                                callbackLiveVideo);

                        if (mLiveMessageLoader != null) {
                            mLiveMessageLoader.finish();
                        }
                        mLiveMessageLoader = new LiveMessageLoader(
                                mLivePlayerStatusLoader.getMsAddr(),
                                mLivePlayerStatusLoader.getMsPort(),
                                mLivePlayerStatusLoader.getMsThread(),
                                mCookieUserSession,
                                mLivePlayerStatusLoader.getUserId(),
                                getApplicationContext());
                        mLiveMessageLoader.setEventListener(new LiveMessageLoader.EventListener() {
                            @Override
                            public void onConnected(LiveMessageLoader loader) {
                                Handler handler = mHandler;
                                if (handler != null) {
                                    handler.sendEmptyMessage(MSG_ID_MESSAGE_CONNECTED);
                                }
                            }
                            @Override
                            public void onOccurredError(LiveMessageLoader loader, String errorMessage) {
                                Handler handler = mHandler;
                                if (handler != null) {
                                    handler.sendEmptyMessage(MSG_ID_MESSAGE_OCCURRED_ERROR);
                                }
                            }
                            @Override
                            public void onFinished(LiveMessageLoader loader) {
                                // nothing
                            }
                            @Override
                            public void onAddedMessage(LiveMessageLoader loader) {
                                // TODO 自動生成されたメソッド・スタブ

                            }
                        });
                        mLiveMessageLoader.startLoad();
                    } else {
                        // 前面に出ていないときは無視
                        if (DEBUG_LOGD) {
                            Log.d(LOG_TAG, "MSG_ID_GET_PLAYER_STATUS_SUCCEEDED not onResume, ignore");
                        }
                    }
                    break;
                case MSG_ID_GET_PLAYER_STATUS_FAILED: {
                    if (mOnResumed) {
                        mProgressTextThumbinfo.setText(
                                getString(R.string.progress_thumbinfo_error));
                        mProgressTextThumbinfo.clearAnimation();

                        showErrorDialog((String) msg.obj);
                    } else {
                        // 前面に出ていないときは無視
                        if (DEBUG_LOGD) {
                            Log.d(LOG_TAG, "MSG_ID_GET_PLAYER_STATUS_SUCCEEDED not onResume, ignore");
                        }
                    }
                    stopWakeLock();
                } break;
                case MSG_ID_SURFACE_READY:
                    mIsSurfaceOk = true;
                    // TODO
                    if (!mIsPlaying && canStartPlay()) {
                        startPlay();
                    }
                    break;
                case MSG_ID_SURFACE_DESTROYED:
                    mIsSurfaceOk = false;
                    break;
                case MSG_ID_LIVE_CONNECT_SUCCEEDED:
                    if (!isFinishing()) {
                        // TODO
    //                    new PrepareFFmpegTask().execute();
                        mFFmpegVideoDecoder.new PrepareFFmpegTask() {
                            @Override
                            protected void onPostExecute(Boolean result) {
                                Handler handler = mHandler;
                                Exception e = getException();
                                if (e != null) {
                                    if (handler != null) {
                                        handler.obtainMessage(MSG_ID_PLAY_ERROR,
                                                e.toString()).sendToTarget();
                                    }
                                }
                                if (!result) {
                                    // TODO しばらくしてからもう一回チャレンジ
                                    if (handler != null) {
                                        handler.sendEmptyMessageDelayed(
                                                MSG_ID_LIVE_CONNECT_SUCCEEDED, 3000L);
                                    }
                                }
                            }
    //                    }.executeWrapper(false);
                        }.executeWrapper(true);
                    }
                    break;
                case MSG_ID_LIVE_CONNECT_FAILED: {
                    if (!isFinishing()) {
                        LiveVideoLoader.ErrorCode errorCode =
                            (LiveVideoLoader.ErrorCode) msg.obj;
                        int stringId;
                        switch (errorCode) {
                            case FAIL_SETUP_URL:
                                stringId = R.string.errormessage_live_setup;
                                break;
                            case FAIL_CONNECT:
                            case FAIL_CONNECT_STREAM:
                                stringId = R.string.errormessage_live_connect;
                                break;
                            case FAIL_RECONNECT_STREAM:
                                stringId = R.string.errormessage_live_reconnect;
                                break;
                            case FAIL_CACHE_FILE:
                                stringId = R.string.errormessage_live_cache_file;
                                break;
                            case READ_ERROR:
                                stringId = R.string.errormessage_live_read_error;
                                break;
                            case READ_COMPLETE:
                                stringId = R.string.errormessage_live_read_complete;
                                break;
                            default:
                                assert false : errorCode;
                                stringId = R.string.errormessage_unknown;
                                break;
                        }
                        showErrorDialog(getString(stringId));
                    }
                    stopWakeLock();
                } break;
                case MSG_ID_MESSAGE_CONNECTED:
                    mProgressTextMessage.setText(
                            getString(R.string.progress_message_live_connected));
                    mProgressTextMessage.clearAnimation();
                    break;
                case MSG_ID_MESSAGE_OCCURRED_ERROR:
                    mProgressTextMessage.setText(
                            getString(R.string.progress_message_live_error));
                    mProgressTextMessage.clearAnimation();
                    break;
                case MSG_ID_INFO_TIME_UPDATE:
                    if (!isFinishing()) {
                        if (mOnResumed) {
                            StringBuilder infoTimeData = mInfoTime.getTextBuilder();
                            infoTimeData.setLength(0);
                            if (mLivePlayerStatusLoader.getArchive() == 0) {
                                // 生放送
                                infoTimeData.append(mResInfoLivePastTime);
                                int timeS = (int) ((System.currentTimeMillis() - mDeviceStartTime) / 1000);
                                if (mGetPlayerStatusTime > 0 && mLiveStartTime > 0) {
                                    timeS += (mGetPlayerStatusTime - mLiveStartTime);
                                }
                                int s = timeS % 60;
                                int m = timeS / 60 % 60;
                                int h = timeS / (60 * 60);
                                Util.appendPlayTime(infoTimeData, h, m, s);
                            } else {
                                // タイムシフト
                                mSurfaceVideoDrawer.getCurrentPosition(mRationalCurrentPosition);
                                final long posNum = mRationalCurrentPosition.num;
                                final int posDen = mRationalCurrentPosition.den;
                                if (posDen != 0) {
                                    int minutes = (int) (posNum / (posDen * 60));
                                    int seconds = (int) (posNum / posDen % 60);
                                    Util.appendPlayTime(infoTimeData, minutes, seconds);
                                } else {
                                    infoTimeData.append(AbstractNicoroPlayer.INFO_TIME_DEFAULT);
                                }
                            }
                            mInfoTime.notifyUpdateText();

                            // 繰り返し
                            mHandler.sendEmptyMessageDelayed(
                                    MSG_ID_INFO_TIME_UPDATE, INTERVAL_TIME_UPDATE);

                            if (DEBUG_LOGV) {
                                Rational r = mRationalDebugLog;
                                mSurfaceVideoDrawer.getCurrentPosition(r);
                                if (r.den == 0) { r.den = 1; }
                                Log.v(LOG_TAG, Log.buf().append("VideoPlayTime: ")
                                        .append(r.num).append("/").append(r.den).append(" ")
                                        .append(r.getDivideFloat()).toString());
                                mStreamAudioPlayer.getCurrentPosition(r);
                                if (r.den == 0) { r.den = 1; }
                                Log.v(LOG_TAG, Log.buf().append("AudioPlayTime: ")
                                        .append(r.num).append("/").append(r.den).append(" ")
                                        .append(r.getDivideFloat()).toString());
                            }
                        }
                    }
                    break;
                case MSG_ID_PLAY_ERROR:
                    showErrorDialog((String) msg.obj);
                    break;
                case MSG_ID_PLAY_FINISHED:
                    // TODO 生放送でこれが起きるのは実質エラー？
                    stopWakeLock();
                    break;
                case MSG_ID_AUTO_CLOSE:
                    finish();
                    break;
                default:
                    assert false : msg.what;
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onCreate: savedInstanceState=")
                    .append(savedInstanceState).toString());
        }
        super.onCreate(savedInstanceState);


        if (savedInstanceState == null) {
//            mIsRestored = false;
        } else {
//            mIsRestored = true;
        }

        mOnResumed = false;
        mWasDestroyed = false;
//        mFromOnPause = false;
        mOnRestarted = false;

        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences(
                getApplicationContext());
        mSharedPreferences = sharedPreferences;
        boolean playerLandscapeOnly = sharedPreferences.getBoolean(
                getString(R.string.pref_key_player_landscape_only), false);
        if (playerLandscapeOnly) {
            setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
        }

        Intent intent = getIntent();
        String liveNumber = intent.getStringExtra(INTENT_NAME_LIVE_NUMBER);
        mLiveNumber = liveNumber;
        String cookieUserSession = intent.getStringExtra(AbstractNicoroPlayer.INTENT_NAME_COOKIE_USER_SESSION);
        mCookieUserSession = cookieUserSession;
        mTitle = intent.getStringExtra(INTENT_NAME_TITLE);
        mDescription = intent.getStringExtra(INTENT_NAME_DESCRIPTION);
//        mLivePlayerStatusLoader = new LivePlayerStatusLoader(liveNumber,
//                cookieUserSession);
//        CallbackMessage<Void, String> callbackLivePlayerStatus = new CallbackMessage<Void, String>(
//                mHandler, MSG_ID_GET_PLAYER_STATUS_SUCCEEDED, MSG_ID_GET_PLAYER_STATUS_FAILED);
//        mLivePlayerStatusLoader.registerCallback(callbackLivePlayerStatus);
//        mLivePlayerStatusLoader.startLoad();

        setContentView(R.layout.nicoro_liveplayer);
        mSurfaceVideoDrawer = new SurfaceVideoDrawer(
                (SurfaceView) findViewById(R.id.surface));
        mSurfaceVideoDrawer.registerEventHandler(mHandler,
                MSG_ID_SURFACE_READY, MSG_ID_SURFACE_DESTROYED,
                MSG_ID_PLAY_FINISHED);
        mSurfaceVideoDrawer.setDrawMessage(this);
        mLiveVideoLoader = new LiveVideoLoader();
        mLiveVideoLoader.start();

        mStreamAudioPlayer = new StreamAudioPlayer(getApplicationContext());
        mFFmpegVideoDecoder = new FFmpegVideoDecoder(mSurfaceVideoDrawer,
                mStreamAudioPlayer, mLiveVideoLoader, NicoroLivePlayer.this);
//        mFFmpegVideoDecoder.setCacheDecodeFirst(false);
        // TODO AudioTrackが起きるのに異常に時間がかかるので、生放送でもとりあえずキャッシュ
        mFFmpegVideoDecoder.setCacheDecodeFirst(true);

        boolean messageAntialias = sharedPreferences.getBoolean(
                getString(R.string.pref_key_message_antialias), false);
        mMessageChatController.setAntiAlias(messageAntialias);

        mMessageDisable = sharedPreferences.getBoolean(
                getString(R.string.pref_key_message_disable), false);

        mMessageData.mChatsWait =
            new LinkedList<MessageChat>();
        mMessageData.mChatsRunningNaka =
            new LinkedList<MessageChat>();
        mMessageData.mChatsRunningShita =
            new LinkedList<MessageChat>();
        mMessageData.mChatsRunningUe =
            new LinkedList<MessageChat>();

        Resources res = getResources();
        mResInfoLivePastTime = res.getString(R.string.info_live_time_past);

        mLastOrientation = res.getConfiguration().orientation;

        initializeView();

        PowerManager powerManager = (PowerManager) getSystemService(POWER_SERVICE);
        mWakeLock = powerManager.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK,
                WAKELOCK_TAG);
        mWakeLock.setReferenceCounted(false);

        mIsSurfaceOk = false;
        mIsPlaying = false;

        mDestroyTaskEnd = false;

        mStartTime = SystemClock.elapsedRealtime();
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        mOnRestarted = true;
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (!mOnRestarted) {
            assert mLivePlayerStatusLoader == null;
            mLivePlayerStatusLoader = new LivePlayerStatusLoader(mLiveNumber,
                    mCookieUserSession, getApplicationContext());
            CallbackMessage<Void, String> callbackLivePlayerStatus = new CallbackMessage<Void, String>(
                    mHandler, MSG_ID_GET_PLAYER_STATUS_SUCCEEDED, MSG_ID_GET_PLAYER_STATUS_FAILED);
            mLivePlayerStatusLoader.registerCallback(callbackLivePlayerStatus);
            mLivePlayerStatusLoader.startLoad();
        }
        mFFmpegVideoDecoder.setIsVisible(true);
    }

    @Override
    protected void onResume() {
        super.onResume();
        mOnResumed = true;
//        mFromOnPause = false;
    }

    @Override
    protected void onPause() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onPause").toString());
        }

        super.onPause();
        mOnResumed = false;
//        mFromOnPause = true;
//        // TODO pauseがどうにもうまくいかないので、とりあえず落とす
//        if (true) {
//            finish();
//            return;
//        }
//
//        assert mLivePlayerStatusLoader != null;
//        mLivePlayerStatusLoader.finish();
//        mLivePlayerStatusLoader = null;
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (mFFmpegVideoDecoder != null) {
            mFFmpegVideoDecoder.setIsVisible(false);
        }
    }

    @Override
    public void finish() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#finish").toString());
        }

        if (mErrorDialog != null) {
            mErrorDialog.dismiss();
            mErrorDialog = null;
        }

        synchronized (mDestroyTaskSync) {
            if (mAsyncDestroyTask == null && !mDestroyTaskEnd) {
                mAsyncDestroyTask = new AsyncDestroyTask();
                mAsyncDestroyTask.execute();
                // 専用のHandler使用
                Handler handler = new Handler();
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (!mDestroyTaskEnd) {
                            mAsyncDestroyTask.timeout();
                            finishReally();
                        }
                    }
                }, FINISH_TIMEOUT_MS);
            }
        }
    }

    public void finishReally() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#finishReally").toString());
        }

        if (!mWasDestroyed) {
            super.finish();
        }
    }

    @Override
    protected void onDestroy() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onDestroy").toString());
        }

        super.onDestroy();
        mWasDestroyed = true;
        synchronized (mDestroyTaskSync) {
            if (mAsyncDestroyTask == null && !mDestroyTaskEnd) {
                // XXX 終了後も動作し続けるのでメモリの問題等発生の恐れ有り
                mAsyncDestroyTask = new AsyncDestroyTask();
                mAsyncDestroyTask.execute();
                // 警告表示
                Util.showErrorToast(getApplicationContext(),
                        R.string.toast_finish_timeout);
            } else {
                if (mDestroyTaskEnd) {
                    onDestroyImplPost();
                } else {
                    // タスクが終わるのは待たない
                    // 警告表示
                    Util.showErrorToast(getApplicationContext(),
                            R.string.toast_finish_timeout);
                }
            }
        }
    }

    /**
     * onDestroyで行うべき終了処理の本体<BR>
     * onPauseよりも先に実行される可能性がある<BR>
     * 外部スレッドとMainスレッドのどちらででも実行される可能性がある
     */
    protected void onDestroyImpl() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        CountDownLatch latch = new CountDownLatch(4);
        if (mLiveVideoLoader == null) {
            latch.countDown();
        } else {
            mLiveVideoLoader.closeAsync(executorService, latch);
        }
        if (mSurfaceVideoDrawer == null) {
            latch.countDown();
        } else {
            mSurfaceVideoDrawer.quitAsync(executorService, latch);
        }
        if (mFFmpegVideoDecoder == null) {
            latch.countDown();
        } else {
            mFFmpegVideoDecoder.quitAsync(executorService, latch);
        }
        if (mLiveMessageLoader == null) {
            latch.countDown();
        } else {
            mLiveMessageLoader.finishAsync(executorService, latch);
        }

        if (mStreamAudioPlayer != null) {
            mStreamAudioPlayer.finish();
        }
//        mLivePlayerStatusLoader.finish();
//        mLivePlayerStatusLoader = null;

        while (true) {
            try {
                latch.await();
                break;
            } catch (InterruptedException e) {
                Log.d(LOG_TAG, e.toString(), e);
            }
        }
        executorService.shutdown();

        if (mLiveVideoLoader != null) {
            mLiveVideoLoader.quit();
            mLiveVideoLoader.free();
        }
    }

    /**
     * onDestroyで行うべき終了処理の本体<BR>
     * onDestroy上またはその後に実行される<BR>
     * onDestroyImplの後に実行される<BR>
     * Mainスレッドで実行される<BR>
     * 二重実行される可能性がある
     */
    protected void onDestroyImplPost() {
        mHandler = null;
        mStreamAudioPlayer = null;
        mSurfaceVideoDrawer = null;
        mFFmpegVideoDecoder = null;
        mLiveMessageLoader = null;
        mLiveVideoLoader = null;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (mLastOrientation != newConfig.orientation) {
            onOrientationChanged(newConfig.orientation);
            mLastOrientation = newConfig.orientation;
        }
    }

    private void onOrientationChanged(int orientation) {
        mFFmpegVideoDecoder.updateDisplayMetrics(this);
        mFFmpegVideoDecoder.setOrientation(orientation);
        mFFmpegVideoDecoder.updateSurfaceSize();

        RelativeLayout temp = Util.inflate(getLayoutInflater(),
                R.layout.nicoro_liveplayer,
                (ViewGroup) getWindow().getDecorView(), false);

        Util.copyLayoutParamsById(mProgressBar, temp);
        Util.copyLayoutParamsById(mProgressTextVideo, temp);
        Util.copyLayoutParamsById(mProgressTextThumbinfo, temp);
        Util.copyLayoutParamsById(mProgressTextMessage, temp);
        Util.copyLayoutParamsById(mProgressTextMessageFork, temp);
        Util.copyLayoutParamsById(mProgressTextInner, temp);

        Util.copyLayoutParamsById(mInfoClock, temp);
        Util.copyLayoutParamsById(mInfoCountPlay, temp);
        Util.copyLayoutParamsById(mInfoCountComment, temp);
        Util.copyLayoutParamsById(mInfoSheet, temp);
        Util.copyLayoutParamsById(mInfoTime, temp);
        Util.copyLayoutParamsById(mInfoTitle, temp);
        Util.copyLayoutParamsById(mInfoDescription, temp);
        Util.copyLayoutParamsById(mInfoPlayData, temp);
        Util.copyLayoutParamsById(mPlayerInfo, temp);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onTouchEvent: event=").append(event)
                    .toString());
        }
        if (mPlayerInfoControllerManager.onTouchEvent(event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onKeyDown: keyCode=").append(keyCode)
                    .append(" event=").append(event)
                    .toString());
        }
        if (mPlayerInfoControllerManager.onKeyDown(keyCode, event)) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append("#onKeyUp: keyCode=").append(keyCode)
                    .append(" event=").append(event)
                    .toString());
        }
        return super.onKeyUp(keyCode, event);
    }

    // SurfaceVideoDrawer.DrawMessage

    @Override
    public void drawMessage(Canvas canvas, int vpos) {
        // TODO vposは現在時間基準
        vpos = (int) (SystemClock.elapsedRealtime() - mStartTime) / 10;

        mMessageChatController.drawMessageForLive(
                canvas, mMessageData, null, vpos,
                canvas.getWidth(), canvas.getHeight(),
                mMessageDisable, mLiveMessageLoader);
    }

    private void startPlay() {
        mIsPlaying = true;

        startWakeLock();

        mProgressGroup.setVisibility(View.GONE);
        if (!mPlayerInfoControllerManager.isPlayerInfoShown()) {
            mPlayerInfoControllerManager.showPlayerInfo();
        }

        mHandler.sendEmptyMessage(MSG_ID_INFO_TIME_UPDATE);

        mStreamAudioPlayer.prepareStart();
//        mFFmpegVideoDecoder.prepareFFmpeg();
        mFFmpegVideoDecoder.prepareDecode();
        mFFmpegVideoDecoder.start();
    }

    private void initializeView() {
        mProgressGroup = Util.findViewById(this, R.id.progress_group);
        mProgressBar = Util.findViewById(this, R.id.progress);
        mProgressTextVideo = Util.findViewById(this, R.id.progress_text_video);
        mProgressTextVideo.setText(getString(R.string.progress_video_wait_connect));
        mProgressTextVideo.startAnimation(
                AnimationUtils.loadAnimation(getApplicationContext(),
                        R.anim.blink));
        mProgressTextThumbinfo = Util.findViewById(this, R.id.progress_text_thumbinfo);
        mProgressTextThumbinfo.setText(getString(R.string.progress_thumbinfo_wait));
        mProgressTextThumbinfo.startAnimation(
                AnimationUtils.loadAnimation(getApplicationContext(),
                        R.anim.blink));
        mProgressTextMessage = Util.findViewById(this, R.id.progress_text_message);
        mProgressTextMessage.setText(getString(R.string.progress_message_wait));
        mProgressTextMessage.startAnimation(
                AnimationUtils.loadAnimation(getApplicationContext(),
                        R.anim.blink));
        mProgressTextMessageFork = Util.findViewById(this,
                R.id.progress_text_message_fork);
        mProgressTextMessageFork.setVisibility(View.GONE);
        mProgressTextInner = Util.findViewById(this, R.id.progress_text_inner);

        mInfoCountPlay = Util.findViewById(this, R.id.info_count_play);
        mInfoCountComment = Util.findViewById(this, R.id.info_count_comment);
        mInfoTime = Util.findViewById(this, R.id.info_time);
        mInfoTitle = Util.findViewById(this, R.id.info_title);
        mInfoDescription = Util.findViewById(this, R.id.info_description);
        mInfoPlayData = Util.findViewById(this, R.id.info_play_data);
        mInfoSheet = Util.findViewById(this, R.id.info_sheet);
        mPlayerInfo = Util.findViewById(this, R.id.player_info);
        mInfoClock = Util.findViewById(this, R.id.info_clock);

        mButtonCommentOnOff = Util.findViewById(this, R.id.button_comment_onoff);
        mButtonCommentOnOff.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView,
                    boolean isChecked) {
                boolean messageDisable = !isChecked;
                if (mMessageDisable != messageDisable) {
                    mMessageDisable = messageDisable;
                    SharedPreferences.Editor editor = mSharedPreferences.edit();
                    editor.putBoolean(
                            getString(R.string.pref_key_message_disable),
                            mMessageDisable);
                    editor.commit();
                }
            }
        });
        mButtonCommentOnOff.setChecked(!mMessageDisable);
        mPlayerController = Util.findViewById(this, R.id.player_controller);

        // Viewが必要なためここで初期化
        mPlayerInfoControllerManager = new PlayerInfoControllerManager(
                getApplicationContext(), mPlayerInfo, mPlayerController, null);
    }

    private boolean canStartPlay() {
        return mOnResumed && mIsSurfaceOk;
    }

    void showErrorDialog(String errorMessage) {
        mErrorDialog = Util.showErrorDialog(this,
                errorMessage + getString(R.string.dialog_text_suffix_player_auto_close),
                true);
        stopWakeLock();
        Handler handler = mHandler;
        if (handler != null) {
            handler.removeMessages(MSG_ID_AUTO_CLOSE);
            handler.sendEmptyMessageDelayed(MSG_ID_AUTO_CLOSE, 30000);
        }
    }

    private void startWakeLock() {
        if (!mWakeLock.isHeld()) {
            mWakeLock.acquire();
        }
        AbstractNicoroPlayer.setNotificationRunningPlayer(
                getApplicationContext(), getClass());
    }
    private void stopWakeLock() {
        if (mWakeLock.isHeld()) {
            mWakeLock.release();
        }
        AbstractNicoroPlayer.clearNotificationRunningPlayer(
                getApplicationContext());
    }
}
